/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.layermerge;

import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import xfy.fakeview.library.layermerge.MergeStatusListener;
import xfy.fakeview.library.layermerge.OnExtractViewGroupListener;

public class LayoutData
implements ViewTreeObserver.OnPreDrawListener {
    FrameLayout layout;
    int extractInfo = 273;
    Object tag;
    int maxFailTimes = 0;
    int maxNotReadyCount = 3;
    int maxZeroLocCountWhenExtracting = 3;
    OnExtractViewGroupListener onExtractViewGroupListener;
    MergeStatusListener mergeStatusListener;
    int failTimes = 0;
    boolean canMerge = false;
    long waitMill = 0L;

    public LayoutData(Object tag, FrameLayout layout) {
        this.tag = tag;
        this.layout = layout;
        layout.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.checkValid();
    }

    public LayoutData withExtractInfo(int extractInfo) {
        this.extractInfo = extractInfo;
        return this;
    }

    public LayoutData withMaxFailTimes(int maxFailTimes) {
        this.maxFailTimes = maxFailTimes;
        return this;
    }

    public LayoutData withOnExtractViewGroupListener(OnExtractViewGroupListener listener) {
        this.onExtractViewGroupListener = listener;
        return this;
    }

    public LayoutData withMaxNotReadyCount(int maxNotReadyCount) {
        this.maxNotReadyCount = maxNotReadyCount;
        return this;
    }

    public LayoutData withMaxZeroLocCountWhenExtracting(int maxZeroLocCountWhenExtracting) {
        this.maxZeroLocCountWhenExtracting = maxZeroLocCountWhenExtracting;
        return this;
    }

    public LayoutData withMergeFailedListener(MergeStatusListener listener) {
        this.mergeStatusListener = listener;
        return this;
    }

    public LayoutData withExtractViewGroupListener(OnExtractViewGroupListener listener) {
        this.onExtractViewGroupListener = listener;
        return this;
    }

    public LayoutData withWaitMillTime(long millTime) {
        this.waitMill = millTime;
        return this;
    }

    public LayoutData canMergeNow() {
        this.canMerge = true;
        this.removeListener();
        return this;
    }

    public LayoutData checkValid() {
        if (this.layout == null) {
            throw new NullPointerException("layout must not be null!");
        }
        if (this.tag == null) {
            throw new NullPointerException("tag must not be null!");
        }
        if (this.extractInfo < 0) {
            throw new IllegalArgumentException("extract info is invalid!");
        }
        return this;
    }

    public String toString() {
        return this.layout + " info: " + this.extractInfo + " " + this.tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPreDraw() {
        this.canMerge = true;
        LayoutData layoutData = this;
        synchronized (layoutData) {
            this.notifyAll();
        }
        this.removeListener();
        return false;
    }

    public void removeListener() {
        this.layout.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    synchronized boolean canMerge() {
        if (this.canMerge) {
            return true;
        }
        try {
            if (this.waitMill > 0L) {
                this.wait(this.waitMill);
            } else {
                this.wait();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.canMerge;
    }
}

