/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.utils;

public class SimpleGravity {
    public static long apply(int gravity, int cl, int ct, int cr, int cb, int w, int h) {
        int left = 0;
        int top = 0;
        switch (gravity & 6) {
            case 0: {
                left = cl + (cr - cl - w >> 1);
                if ((gravity & 8) != 8) break;
                left = left < cl ? cl : left;
                break;
            }
            case 4: {
                left = cr - w;
                if ((gravity & 8) != 8) break;
                left = left < cl ? cl : left;
                break;
            }
            default: {
                left = cl;
            }
        }
        switch (gravity & 0x60) {
            case 0: {
                top = ct + (cb - ct - h >> 1);
                if ((gravity & 0x80) != 128) break;
                top = top < ct ? ct : top;
                break;
            }
            case 64: {
                top = cb - h;
                if ((gravity & 0x80) != 128) break;
                top = top < ct ? ct : top;
                break;
            }
            default: {
                top = ct;
            }
        }
        return SimpleGravity.combine(left, top);
    }

    public static long combine(int left, int top) {
        long tl = top;
        return (tl <<= 32) | (long)left;
    }

    public static int getLeft(long flag) {
        return (int)flag;
    }

    public static int getTop(long flag) {
        return (int)(flag >>>= 32);
    }
}

