/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.param;

import android.graphics.Typeface;
import android.text.TextPaint;
import java.util.ArrayList;
import xfy.fakeview.library.text.utils.BaseSpan;

public class SpecialStyleParams {
    public boolean hasFColor;
    public int foregroundColor;
    public boolean hasBColor;
    public int backgroundColor;
    public boolean bold;
    public boolean underline;
    public boolean italic;
    public boolean hasTextSize;
    public float textSize;
    private static final ArrayList<SpecialStyleParams> cache = new ArrayList();
    private static final int DEFAULT_SIZE = 30;

    private SpecialStyleParams() {
    }

    private static synchronized void putToCache(SpecialStyleParams params) {
        cache.add(params);
    }

    public static synchronized SpecialStyleParams obtain() {
        if (cache.isEmpty()) {
            return new SpecialStyleParams();
        }
        return cache.remove(0);
    }

    public static synchronized SpecialStyleParams obtain(BaseSpan span) {
        SpecialStyleParams params = null;
        params = cache.isEmpty() ? new SpecialStyleParams() : cache.remove(0);
        return params.initBySpan(span);
    }

    public void recycle() {
        this.hasFColor = false;
        this.foregroundColor = 0;
        this.hasBColor = false;
        this.backgroundColor = 0;
        this.italic = false;
        this.underline = false;
        this.bold = false;
        this.hasTextSize = false;
        this.textSize = 0.0f;
        SpecialStyleParams.putToCache(this);
    }

    public SpecialStyleParams initByPaint(TextPaint paint) {
        this.underline = paint.isUnderlineText();
        Typeface typeface = paint.getTypeface();
        if (typeface != null) {
            this.bold = typeface.isBold() || paint.isFakeBoldText();
            this.italic = typeface.isItalic();
        }
        return this;
    }

    public SpecialStyleParams initBySpan(BaseSpan span) {
        this.hasFColor = span.isHasFColor();
        this.foregroundColor = span.getForegroundColor();
        this.hasBColor = span.isHasBColor();
        this.backgroundColor = span.getBackgroundColor();
        this.bold = span.isBold();
        this.underline = span.isUnderline();
        this.italic = span.isItalic();
        return this;
    }

    public SpecialStyleParams withForegroundColor(int color) {
        this.hasFColor = true;
        this.foregroundColor = color;
        return this;
    }

    public SpecialStyleParams withBackgroundColor(int color) {
        this.hasBColor = true;
        this.backgroundColor = color;
        return this;
    }

    public SpecialStyleParams boldText() {
        this.bold = true;
        return this;
    }

    public SpecialStyleParams underlineText() {
        this.underline = true;
        return this;
    }

    public SpecialStyleParams italicText() {
        this.italic = true;
        return this;
    }

    public SpecialStyleParams withTextSize(float px) {
        this.hasTextSize = true;
        this.textSize = px;
        return this;
    }

    static {
        for (int i = 0; i < 30; ++i) {
            cache.add(new SpecialStyleParams());
        }
    }
}

