/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import java.lang.reflect.Method;
import xfy.fakeview.library.R;
import xfy.fakeview.library.text.compiler.ClickSpanTextCompiler;
import xfy.fakeview.library.text.compiler.DefaultTextCompiler;
import xfy.fakeview.library.text.compiler.DrawableTextCompiler;
import xfy.fakeview.library.text.compiler.ITextCompiler;
import xfy.fakeview.library.text.compiler.SpecialTextHelper;

public class StyleHelper {
    public int maxWidth;
    public int maxHeight;
    public int maxLines = -1;
    public int textSize = -1;
    public int lineSpace = 0;
    public int textColor = -16777216;
    public int gravity = 51;
    public float drawableScale = 1.0f;
    public int drawableSize = -1;
    public CharSequence text;
    public boolean measureWhenSetText = false;
    public ITextCompiler textCompiler;
    public String ellipsizeText = "...";

    public StyleHelper(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (context == null || attrs == null) {
            return;
        }
        Resources.Theme theme = context.getTheme();
        if (theme == null) {
            return;
        }
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.FNewTextView, defStyleAttr, defStyleRes);
        TypedArray appearance = null;
        int ap = a.getResourceId(R.styleable.FNewTextView_fntv_style, -1);
        if (ap != -1) {
            appearance = theme.obtainStyledAttributes(ap, R.styleable.FNewTextView);
        }
        this.initStyle(context, appearance);
        this.initStyle(context, a);
    }

    private void initStyle(Context context, TypedArray appearance) {
        if (appearance != null) {
            int len = appearance.getIndexCount();
            for (int i = 0; i < len; ++i) {
                String ellipsizeText;
                int attr = appearance.getIndex(i);
                if (attr == R.styleable.FNewTextView_android_textSize) {
                    this.textSize = appearance.getDimensionPixelSize(attr, this.textSize);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_android_text) {
                    this.text = appearance.getString(attr);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_android_maxLines) {
                    this.maxLines = appearance.getInt(attr, this.maxLines);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_android_textColor) {
                    this.textColor = appearance.getColor(attr, this.textColor);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_android_gravity) {
                    this.gravity = appearance.getInt(attr, this.gravity);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_android_maxWidth) {
                    this.maxWidth = appearance.getDimensionPixelOffset(attr, this.maxWidth);
                    if (this.maxWidth >= 0) continue;
                    this.maxWidth += this.getScreenWidth(context);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_android_maxHeight) {
                    this.maxHeight = appearance.getDimensionPixelOffset(attr, this.maxHeight);
                    if (this.maxHeight >= 0) continue;
                    this.maxHeight += this.getScreenHeight(context);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_fntv_drawable_scale) {
                    this.drawableScale = appearance.getFloat(attr, this.drawableScale);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_fntv_drawable_size) {
                    this.drawableSize = appearance.getDimensionPixelSize(attr, this.drawableSize);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_android_lineSpacingExtra) {
                    this.lineSpace = appearance.getDimensionPixelOffset(attr, this.lineSpace);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_fntv_measure_when_set_text) {
                    this.measureWhenSetText = appearance.getBoolean(attr, this.measureWhenSetText);
                    continue;
                }
                if (attr == R.styleable.FNewTextView_fntv_text_compiler) {
                    this.setTextCompiler(context, appearance, attr);
                    continue;
                }
                if (attr != R.styleable.FNewTextView_fntv_ellepsize_text || TextUtils.isEmpty((CharSequence)(ellipsizeText = appearance.getString(attr)))) continue;
                this.ellipsizeText = ellipsizeText;
            }
            appearance.recycle();
        }
    }

    private void setTextCompiler(Context context, TypedArray a, int attr) {
        try {
            Compiler[] compilers;
            int e = a.getInt(attr, -1);
            if (e >= 0 && e < (compilers = Compiler.values()).length) {
                this.textCompiler = compilers[e].getCompiler(context);
                return;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        String clz = a.getString(attr);
        if (!TextUtils.isEmpty((CharSequence)clz)) {
            try {
                Class<?> c = Class.forName(clz);
                Method m = c.getDeclaredMethod("getCompiler", new Class[0]);
                m.setAccessible(true);
                this.textCompiler = (ITextCompiler)m.invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    private int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    static enum Compiler {
        text_only{

            @Override
            ITextCompiler getCompiler(Context context) {
                return DefaultTextCompiler.getCompiler();
            }
        }
        ,
        contain_image{

            @Override
            ITextCompiler getCompiler(Context context) {
                return DrawableTextCompiler.getCompiler();
            }
        }
        ,
        click_span{

            @Override
            ITextCompiler getCompiler(Context context) {
                return ClickSpanTextCompiler.getCompiler();
            }
        }
        ,
        spcial_text{

            @Override
            ITextCompiler getCompiler(Context context) {
                return SpecialTextHelper.getSpecialCompiler(context);
            }
        };


        abstract ITextCompiler getCompiler(Context var1);
    }
}

