/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.compiler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xfy.fakeview.library.text.block.DefaultDrawableBlockList;
import xfy.fakeview.library.text.compiler.DefaultTextCompiler;
import xfy.fakeview.library.text.compiler.ITextCompiler;
import xfy.fakeview.library.text.param.SpecialStyleParams;

public class SpecialCompiler
extends DefaultTextCompiler {
    private static volatile SpecialCompiler compiler;
    private static final String RICH_REG = "(?<=\\([Ff][Oo][Nn][Tt])[\\s\\S]*?(?=\\(/[Ff][Oo][Nn][Tt]\\))";
    private static final String STYLE_SPLIT = "\\s";
    private static final String STYLE_PARAMS_SPLIT = "=";
    private static final String PARAMS_WRAPPER = "'";
    private static final String STYLE_END = ")";
    private Pattern pattern;
    private final HashMap<String, SpecialStyleAdapter> adapterMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpecialCompiler getCompiler() {
        if (compiler != null) return compiler;
        Class<SpecialCompiler> clazz = SpecialCompiler.class;
        synchronized (SpecialCompiler.class) {
            if (compiler != null) return compiler;
            compiler = new SpecialCompiler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return compiler;
        }
    }

    protected SpecialCompiler() {
    }

    public SpecialCompiler(ITextCompiler<DefaultDrawableBlockList> innerCompiler) {
        super(innerCompiler);
    }

    @NonNull
    protected String getReg() {
        return RICH_REG;
    }

    @NonNull
    protected Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.getReg());
        }
        return this.pattern;
    }

    @NonNull
    protected String getStyleSplit() {
        return STYLE_SPLIT;
    }

    @NonNull
    protected String getStyleParamsSplit() {
        return STYLE_PARAMS_SPLIT;
    }

    @NonNull
    protected String getParamsWrapper() {
        return PARAMS_WRAPPER;
    }

    @NonNull
    protected String getStyleEnd() {
        return STYLE_END;
    }

    @Override
    public void compileInternal(@NonNull DefaultDrawableBlockList list, @NonNull CharSequence text, int start, int end, @Nullable SpecialStyleParams specialStyleParams) {
        CharSequence sub = text.subSequence(start, end);
        Matcher m = this.getPattern().matcher(sub);
        int lastEnd = start;
        while (m.find()) {
            String t = m.group().trim();
            int gs = m.start();
            int ge = m.end();
            int ss = this.getStyleStart(gs);
            if (lastEnd < ss) {
                super.compileInternal(list, sub, lastEnd, ss, specialStyleParams);
            }
            this.compileSpecialText(list, t, specialStyleParams);
            lastEnd = this.getStyleEnd(ge);
        }
        if (lastEnd < end) {
            super.compileInternal(list, sub, lastEnd, end, specialStyleParams);
        }
    }

    protected int getStyleStart(int start) {
        return start - 5;
    }

    protected int getStyleEnd(int end) {
        return end + 7;
    }

    protected int getTextStyleEndIndex(String text) {
        return text.indexOf(this.getStyleEnd());
    }

    @Override
    protected boolean compileSpecialText(DefaultDrawableBlockList list, CharSequence t, @Nullable SpecialStyleParams specialStyleParams) {
        String text = t.toString();
        int index = this.getTextStyleEndIndex(text);
        if (index < 0) {
            super.compileInternal(list, (CharSequence)text, 0, text.length(), specialStyleParams);
            return false;
        }
        String styles = text.substring(0, index);
        String content = text.substring(index + 1);
        if (TextUtils.isEmpty((CharSequence)styles)) {
            super.compileInternal(list, (CharSequence)content, 0, content.length(), specialStyleParams);
            return false;
        }
        String[] ss = styles.split(this.getStyleSplit());
        if (ss == null || ss.length == 0) {
            super.compileInternal(list, (CharSequence)content, 0, content.length(), specialStyleParams);
            return false;
        }
        SpecialStyleParams inner = SpecialStyleParams.obtain();
        for (String style : ss) {
            SpecialStyleAdapter adapter;
            String[] param = style.split(this.getStyleParamsSplit());
            if (param == null || param.length != 2 || (adapter = this.adapterMap.get(param[0])) == null) continue;
            String value = param[1];
            String pw = this.getParamsWrapper();
            if (value.startsWith(pw)) {
                value = value.substring(1);
            }
            if (value.endsWith(pw)) {
                value = value.substring(0, value.length() - 1);
            }
            if (value.length() == 0) continue;
            adapter.setStyle(inner, value);
        }
        super.compileInternal(list, (CharSequence)content, 0, content.length(), inner);
        return true;
    }

    public void register(String key, SpecialStyleAdapter adapter) {
        this.adapterMap.put(key, adapter);
    }

    public void unRegister(String key) {
        this.adapterMap.remove(key);
    }

    public static interface SpecialStyleAdapter {
        public void setStyle(SpecialStyleParams var1, String var2);
    }
}

