/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.block;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.view.MotionEvent;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import xfy.fakeview.library.text.block.BlockMeasureParams;
import xfy.fakeview.library.text.block.DefaultDrawableBlockList;
import xfy.fakeview.library.text.block.IDrawableBlock;
import xfy.fakeview.library.text.drawer.TextDrawableDrawer;
import xfy.fakeview.library.text.drawer.TextDrawer;
import xfy.fakeview.library.text.param.ClickSpanBlockInfo;
import xfy.fakeview.library.text.param.ImmutableParams;
import xfy.fakeview.library.text.param.SpecialStyleParams;
import xfy.fakeview.library.text.param.VariableParams;
import xfy.fakeview.library.text.utils.BaseSpan;
import xfy.fakeview.library.text.utils.FClickableSpan;
import xfy.fakeview.library.text.utils.IDrawableStats;
import xfy.fakeview.library.text.utils.IllegalDrawableException;
import xfy.fakeview.library.text.utils.LineUtils;
import xfy.fakeview.library.text.utils.MeasureTextUtils;
import xfy.fakeview.library.text.utils.NoCacheSpanRegister;

public class DefaultDrawableBlock
implements IDrawableBlock<DefaultDrawableBlockList>,
Drawable.Callback {
    private int type;
    private CharSequence mText;
    private SpecialStyleParams textStyleParams;
    private int drawableRes;
    private Drawable specialDrawable;
    private DefaultDrawableBlockList children;
    private BaseSpan span;
    private final ArrayList<WeakReference<Drawable.Callback>> callbacks = new ArrayList();
    private boolean hasCreateNewDrawableForSpecialDrawable;
    private long flag;
    private int baseLine;
    private int needSetCallbackCount;
    private static final int DEFAULT_SIZE = 20;
    private static final List<DefaultDrawableBlock> cache = new ArrayList<DefaultDrawableBlock>(20);

    private DefaultDrawableBlock() {
    }

    private static synchronized DefaultDrawableBlock obtain() {
        if (cache.isEmpty()) {
            return new DefaultDrawableBlock();
        }
        return cache.remove(0);
    }

    private static synchronized void putToCache(DefaultDrawableBlock block) {
        cache.add(block);
    }

    public void recycle() {
        this.callbacks.clear();
        this.hasCreateNewDrawableForSpecialDrawable = false;
        this.span = null;
        this.flag = 0L;
        this.type = 0;
        this.baseLine = 0;
        this.mText = null;
        if (this.textStyleParams != null) {
            this.textStyleParams.recycle();
        }
        this.textStyleParams = null;
        this.drawableRes = 0;
        if (this.specialDrawable != null && this.specialDrawable instanceof IDrawableStats) {
            ((IDrawableStats)this.specialDrawable).recycle();
        }
        this.specialDrawable = null;
        if (this.children != null) {
            this.children.notUse();
        }
        this.children = null;
        DefaultDrawableBlock.putToCache(this);
    }

    @Override
    public void onNoOneUse() {
        if (this.specialDrawable instanceof IDrawableStats) {
            ((IDrawableStats)this.specialDrawable).recycle();
        } else if (this.children != null) {
            this.children.onNoOneUse();
        }
    }

    @Override
    public boolean canSaveToCache() {
        return !NoCacheSpanRegister.contain(this.span);
    }

    @Override
    public long getFlag() {
        return this.flag;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getBaseLine() {
        return this.baseLine;
    }

    @Override
    public CharSequence getText() {
        return this.mText;
    }

    @Override
    public int getDrawableRes() {
        return this.drawableRes;
    }

    @Override
    public Drawable getSpecialDrawable() {
        return this.specialDrawable;
    }

    @Override
    public DefaultDrawableBlockList getChildren() {
        return this.children;
    }

    @Override
    public long measure(BlockMeasureParams measureParams, @NonNull ImmutableParams immutableParams) {
        TextPaint textPaint = immutableParams.paint;
        int drawableSize = measureParams.drawableSize;
        int left = measureParams.left;
        int currentLeft = measureParams.currentLeft;
        int right = measureParams.right;
        boolean includePad = measureParams.includePad;
        int lineInfo = measureParams.lineInfo;
        int top = measureParams.currentTop;
        int fontHeight = LineUtils.getLineHeight(lineInfo);
        this.baseLine = LineUtils.getBaseLine(lineInfo);
        switch (this.type) {
            case 0: {
                float oldTextSize = textPaint.getTextSize();
                if (this.textStyleParams != null && this.textStyleParams.hasTextSize) {
                    textPaint.setTextSize(this.textStyleParams.textSize);
                    if (this.textStyleParams.textSize > oldTextSize) {
                        int flag = TextDrawer.getLineInfo(textPaint, drawableSize, includePad);
                        fontHeight = LineUtils.getLineHeight(flag);
                        this.baseLine = LineUtils.getBaseLine(flag);
                        measureParams.lineInfo = LineUtils.combime(fontHeight, this.baseLine);
                    }
                }
                this.flag = TextDrawer.measureText(textPaint, this.mText, currentLeft, left, right, 0L);
                this.flag = MeasureTextUtils.setMaxHeight(this.flag, fontHeight);
                textPaint.setTextSize(oldTextSize);
                break;
            }
            case 4: {
                this.flag = MeasureTextUtils.setLines(0L, 2);
                break;
            }
            case 1: {
                if (this.specialDrawable == null && this.drawableRes > 0) {
                    this.specialDrawable = TextDrawableDrawer.getDrawableDrawer().getSpecialDrawable(this.drawableRes, drawableSize);
                }
                if (this.specialDrawable == null) {
                    this.flag = TextDrawer.measureText(textPaint, this.mText, currentLeft, left, right, 0L);
                }
                this.flag = TextDrawer.measureFixWidth(TextDrawableDrawer.measureDrawableWidth(this.specialDrawable, drawableSize), currentLeft, left, right);
                break;
            }
            case 2: {
                if (this.specialDrawable == null) {
                    this.flag = TextDrawer.measureText(textPaint, this.mText, currentLeft, left, right, 0L);
                }
                this.flag = TextDrawer.measureFixWidth(TextDrawableDrawer.measureDrawableWidth(this.specialDrawable, drawableSize), currentLeft, left, right);
                break;
            }
            case 5: {
                if (!this.hasCreateNewDrawableForSpecialDrawable) {
                    IDrawableStats observer = (IDrawableStats)this.specialDrawable;
                    this.specialDrawable = TextDrawableDrawer.getDrawableDrawer().getSpecialDrawable(this.specialDrawable, drawableSize, observer.needCreateNewDrawable());
                    observer = (IDrawableStats)this.specialDrawable;
                    this.hasCreateNewDrawableForSpecialDrawable = true;
                    observer.onCallbackSet(this);
                    observer.setCountInText(this.needSetCallbackCount);
                }
                this.flag = TextDrawer.measureFixWidth(TextDrawableDrawer.measureDrawableWidth(this.specialDrawable, drawableSize), currentLeft, left, right);
                break;
            }
            case 3: {
                DefaultDrawableBlockList children = this.getChildren();
                this.flag = children == null ? 0L : children.measure(measureParams, immutableParams);
                if (!(this.span instanceof FClickableSpan)) break;
                immutableParams.addClickSpanBlockInfo(this, currentLeft, top, this.flag);
            }
        }
        measureParams.currentLeft = MeasureTextUtils.getCurrentLeft(this.flag);
        int lines = MeasureTextUtils.getLines(this.flag);
        if (lines > 1) {
            measureParams.currentTop = top += (lines - 1) * MeasureTextUtils.getMaxHeight(this.flag);
        }
        return this.flag;
    }

    @Override
    public boolean draw(Canvas canvas, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        if (variableParams.isDrawEndEllipsize) {
            return true;
        }
        switch (this.type) {
            case 0: {
                TextDrawer.drawText(canvas, this.mText, variableParams, immutableParams, this.textStyleParams);
                break;
            }
            case 4: {
                TextDrawer.drawNextLine(canvas, variableParams, immutableParams);
                break;
            }
            case 1: {
                if (this.drawableRes <= 0) {
                    TextDrawer.drawText(canvas, this.mText, variableParams, immutableParams, this.textStyleParams);
                    break;
                }
                if (this.specialDrawable != null) {
                    TextDrawableDrawer.getDrawableDrawer().drawSpecialDrawable(canvas, this.specialDrawable, variableParams, immutableParams);
                    break;
                }
                this.specialDrawable = TextDrawableDrawer.getDrawableDrawer().drawResource(canvas, this.drawableRes, variableParams, immutableParams);
                break;
            }
            case 2: {
                if (this.specialDrawable == null) {
                    TextDrawer.drawText(canvas, this.mText, variableParams, immutableParams, this.textStyleParams);
                    break;
                }
                TextDrawableDrawer.getDrawableDrawer().drawSpecialDrawable(canvas, this.specialDrawable, variableParams, immutableParams);
                break;
            }
            case 5: {
                if (this.specialDrawable == null) {
                    TextDrawer.drawText(canvas, this.mText, variableParams, immutableParams, this.textStyleParams);
                    break;
                }
                TextDrawableDrawer.getDrawableDrawer().drawSpecialDrawable(canvas, this.specialDrawable, variableParams, immutableParams);
                break;
            }
            case 3: {
                DefaultDrawableBlockList children = this.getChildren();
                if (children == null) {
                    return false;
                }
                boolean result = true;
                int l = children.size();
                for (int i = 0; i < l; ++i) {
                    if (((DefaultDrawableBlock)children.get(i)).draw(canvas, variableParams, immutableParams)) continue;
                    result = false;
                }
                return result;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onTouchEvent(@NonNull View v, MotionEvent event, @NonNull ImmutableParams immutableParams, @NonNull ClickSpanBlockInfo blockInfo) {
        if (this.type != 3) {
            return false;
        }
        if (!(this.span instanceof FClickableSpan)) {
            return false;
        }
        int action = event.getAction();
        boolean handleEvent = false;
        if (action == 1 || action == 0) {
            handleEvent = false;
            if (this.isPointInThisBlock(event.getX(), event.getY(), immutableParams, blockInfo)) {
                if (action == 1) {
                    ((FClickableSpan)this.span).onClick(v);
                    return true;
                }
                handleEvent = true;
            }
        }
        return handleEvent;
    }

    @Override
    public void addCallback(Drawable.Callback callback) {
        if (this.type != 5) {
            return;
        }
        boolean needAdd = true;
        for (int i = this.callbacks.size() - 1; i >= 0; --i) {
            Drawable.Callback c;
            WeakReference<Drawable.Callback> ref = this.callbacks.get(i);
            Drawable.Callback callback2 = c = ref != null ? (Drawable.Callback)ref.get() : null;
            if (c == null) {
                this.callbacks.remove(i);
                continue;
            }
            if (c != callback) continue;
            needAdd = false;
        }
        if (needAdd) {
            this.callbacks.add(new WeakReference<Drawable.Callback>(callback));
        }
        if (this.hasCreateNewDrawableForSpecialDrawable) {
            ((IDrawableStats)this.specialDrawable).onCallbackSet(this);
        }
    }

    @Override
    public void removeCallback(Drawable.Callback callback) {
        for (int i = this.callbacks.size() - 1; i >= 0; --i) {
            Drawable.Callback c;
            WeakReference<Drawable.Callback> ref = this.callbacks.get(i);
            Drawable.Callback callback2 = c = ref != null ? (Drawable.Callback)ref.get() : null;
            if (c != null && c != callback) continue;
            this.callbacks.remove(i);
        }
    }

    @Override
    public void setNeedSetCallbackCount(int c) {
        this.needSetCallbackCount = c;
        if (this.hasCreateNewDrawableForSpecialDrawable) {
            ((IDrawableStats)this.specialDrawable).setCountInText(c);
        }
    }

    private boolean isPointInThisBlock(float x, float y, @NonNull ImmutableParams immutableParams, @NonNull ClickSpanBlockInfo blockInfo) {
        long flag = blockInfo.blockFlag;
        int h = MeasureTextUtils.getMaxHeight(flag);
        if (h <= 0) {
            return false;
        }
        int cl = MeasureTextUtils.getCurrentLeft(flag);
        if (cl == 0) {
            return false;
        }
        int lines = MeasureTextUtils.getLines(flag);
        if (lines == 0) {
            return false;
        }
        y -= (float)immutableParams.top;
        if ((x -= (float)immutableParams.left) < 0.0f || y < 0.0f) {
            return false;
        }
        int left = blockInfo.blockLeft;
        int top = blockInfo.blockTop;
        int b = h + top;
        if (lines == 1) {
            return x >= (float)left && x <= (float)cl && y >= (float)top && y <= (float)b;
        }
        int vr = immutableParams.right;
        if (x > (float)vr || y > (float)b) {
            return false;
        }
        float lh = (float)h / (float)lines;
        if (left < cl) {
            if (this.isPointInRect(x, y, left, top, vr, b)) {
                return true;
            }
            if (this.isPointInRect(x, y, 0, (int)((float)top + lh), left, b)) {
                return true;
            }
            return this.isPointInRect(x, y, cl, top, vr, (int)((float)b - lh));
        }
        if (this.isPointInRect(x, y, 0, (int)((float)top + lh), cl, b)) {
            return true;
        }
        if (this.isPointInRect(x, y, cl, top, left, (int)((float)b - lh))) {
            return true;
        }
        return this.isPointInRect(x, y, left, top, vr, (int)((float)b - lh));
    }

    private boolean isPointInRect(float x, float y, int l, int t, int r, int b) {
        return x >= (float)l && x <= (float)r && y >= (float)t && y <= (float)b;
    }

    public static DefaultDrawableBlock createTextBlock(CharSequence text, @Nullable SpecialStyleParams params) {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 0;
        block.textStyleParams = params;
        return block;
    }

    public static DefaultDrawableBlock createDrawableBlock(CharSequence text, int res) {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 1;
        block.drawableRes = res;
        return block;
    }

    public static DefaultDrawableBlock createSpecialDrawableBlock(CharSequence text, Drawable d) {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 2;
        block.specialDrawable = d;
        return block;
    }

    public static DefaultDrawableBlock createNeedSetCallbackDrawableBlock(CharSequence text, Drawable d) {
        if (!(d instanceof IDrawableStats)) {
            throw new IllegalDrawableException("drawble " + d.getClass().getName() + " is not a IDrawableStats");
        }
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 5;
        block.specialDrawable = d;
        return block;
    }

    public static DefaultDrawableBlock createSpanBlock(CharSequence text, BaseSpan span, DefaultDrawableBlockList children) {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 3;
        block.children = children;
        block.span = span;
        block.textStyleParams = SpecialStyleParams.obtain(span);
        int l = children.size();
        for (int i = 0; i < l; ++i) {
            DefaultDrawableBlock b = (DefaultDrawableBlock)children.get(i);
            if (b == null || b.textStyleParams != null) continue;
            b.textStyleParams = block.textStyleParams;
        }
        return block;
    }

    public static DefaultDrawableBlock createNextLineBlock() {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = "\n";
        block.type = 4;
        return block;
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        int l = this.callbacks.size();
        for (int i = 0; i < l; ++i) {
            Drawable.Callback callback;
            WeakReference<Drawable.Callback> ref = this.callbacks.get(i);
            Drawable.Callback callback2 = callback = ref != null ? (Drawable.Callback)ref.get() : null;
            if (callback == null) continue;
            callback.invalidateDrawable(who);
        }
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        WeakReference<Drawable.Callback> ref;
        Drawable.Callback callback;
        int i = 0;
        int len = this.callbacks.size();
        if (len <= i) {
            return;
        }
        Drawable.Callback callback2 = callback = (ref = this.callbacks.get(i++)) != null ? (Drawable.Callback)ref.get() : null;
        while (callback == null && len > i) {
            ref = this.callbacks.get(i);
            callback = ref != null ? (Drawable.Callback)ref.get() : null;
        }
        if (callback != null) {
            callback.scheduleDrawable(who, what, when);
        }
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        int l = this.callbacks.size();
        for (int i = 0; i < l; ++i) {
            Drawable.Callback callback;
            WeakReference<Drawable.Callback> ref = this.callbacks.get(i);
            Drawable.Callback callback2 = callback = ref != null ? (Drawable.Callback)ref.get() : null;
            if (callback == null) continue;
            callback.unscheduleDrawable(who, what);
        }
    }

    static {
        for (int i = 0; i < 20; ++i) {
            cache.add(new DefaultDrawableBlock());
        }
    }
}

