/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import xfy.fakeview.library.text.FTextDrawable;
import xfy.fakeview.library.text.StyleHelper;
import xfy.fakeview.library.text.compiler.DefaultTextCompiler;
import xfy.fakeview.library.text.compiler.ITextCompiler;
import xfy.fakeview.library.text.drawer.TextDrawableDrawer;

public class NewTextView
extends View
implements FTextDrawable.LayoutRequestListener {
    private static final String TAG = "Fake--NewTextView";
    private final FTextDrawable textDrawable;
    private int maxWidth;
    private int maxHeight;

    public NewTextView(Context context) {
        this(context, null);
    }

    public NewTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NewTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        StyleHelper styleHelper = new StyleHelper(context, attrs, defStyleAttr, 0);
        this.textDrawable = new FTextDrawable(styleHelper);
        this.init(styleHelper);
    }

    @RequiresApi(api=21)
    public NewTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        StyleHelper styleHelper = new StyleHelper(context, attrs, defStyleAttr, defStyleRes);
        this.textDrawable = new FTextDrawable(styleHelper);
        this.init(styleHelper);
    }

    private void init(StyleHelper helper) {
        TextDrawableDrawer.init(this.getContext());
        this.textDrawable.setCallback((Drawable.Callback)this);
        this.textDrawable.setLayoutRequestListener(this);
        if (this.textDrawable.getCompiler() == null) {
            this.textDrawable.setTextCompiler(this.getDefaultCompiler());
        }
        if (helper == null) {
            return;
        }
        this.maxWidth = helper.maxWidth;
        this.maxHeight = helper.maxHeight;
    }

    public FTextDrawable getTextDrawable() {
        return this.textDrawable;
    }

    public void setCompiler(@NonNull ITextCompiler compiler) {
        this.textDrawable.setTextCompiler(compiler);
    }

    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        this.textDrawable.setTextSize(this.getPx(size, unit));
    }

    public void setTextColor(int color) {
        this.textDrawable.setTextColor(color);
    }

    public void setMaxLines(int max) {
        this.textDrawable.setMaxLines(max);
    }

    public void setLineSpace(int px) {
        this.textDrawable.setLineSpace(px);
    }

    public void setDrawableSize(int px) {
        this.textDrawable.setDrawableSize(px);
    }

    public void setDrawableScale(float scale) {
        this.textDrawable.setDrawableScale(scale);
    }

    public void setUnderLineText(boolean underline) {
        this.textDrawable.setUnderLineText(underline);
    }

    public void setBoldText(boolean bold) {
        this.textDrawable.setBoldText(bold);
    }

    public void setItalicText(boolean italic) {
        this.textDrawable.setItalicText(italic);
    }

    public void setText(CharSequence text) {
        this.textDrawable.setText(text);
    }

    public void setGravity(int gravity) {
        this.textDrawable.setGravity(gravity);
    }

    public void setIncludePad(boolean inlucdePad) {
        this.textDrawable.setIncludePad(inlucdePad);
    }

    public void setForceMeasureBlockList(boolean force) {
        this.textDrawable.setForceMeasureBlockList(force);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.textDrawable.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.textDrawable.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int pl = this.getPaddingLeft();
        int pt = this.getPaddingTop();
        int pr = this.getPaddingRight();
        int pb = this.getPaddingBottom();
        int maxWidth = (widthSize == 0 ? this.maxWidth : widthSize) - pl - pr;
        int maxHeight = (heightSize == 0 ? this.maxHeight : heightSize) - pl - pr;
        maxHeight = maxHeight == 0 ? 4096 : maxHeight;
        this.textDrawable.setMaxWidth(maxWidth);
        this.textDrawable.setMaxHeight(maxHeight);
        if (!this.textDrawable.isAutoMeasure()) {
            this.textDrawable.measure();
        }
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            width = Math.max(this.textDrawable.getIntrinsicWidth(), this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            height = Math.max(this.textDrawable.getIntrinsicHeight(), this.getSuggestedMinimumHeight());
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(heightSize, height);
            }
        }
        this.setMeasuredDimension(width, height);
        this.textDrawable.setBounds(pl, pt, width - pr, height - pb);
    }

    @Override
    public void needRequest(FTextDrawable drawable) {
        this.requestLayout();
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || this.textDrawable == who;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean result = super.onTouchEvent(ev);
        result = this.textDrawable.onTouchEvent(this, ev) || result;
        return result;
    }

    protected void onDraw(Canvas canvas) {
        this.textDrawable.draw(canvas);
    }

    protected ITextCompiler getDefaultCompiler() {
        return DefaultTextCompiler.getCompiler();
    }

    private float getPxFromSp(float sp) {
        return this.getPx(sp, 2);
    }

    private float getPx(float s, int type) {
        Resources resources = this.getResources();
        return TypedValue.applyDimension((int)type, (float)s, (DisplayMetrics)resources.getDisplayMetrics());
    }

    private static long now() {
        return System.nanoTime();
    }

    private static long logCast(String pre, long now) {
        long end = NewTextView.now();
        Log.d((String)TAG, (String)(pre + (end - now)));
        return end;
    }
}

