/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.utils;

public class MeasureTextUtils {
    public static final int STATE_SUCCESS = 0;
    public static final int STATE_TIMEOUT = 1;
    public static final int STATE_ERROR = 2;
    public static final int HEIGHT_MAX_SIZE = 4096;
    private static final long WIDTH_FLAG = 4095L;
    private static final long LEFT_FLAG = 0xFFF000L;
    private static final int LEFT_OFFSET = 12;
    private static final long HEIGHT_FLAG = 0xFFF000000L;
    private static final int HEIGHT_OFFSET = 24;
    private static final long LINES_FLAG = 0x1FFFFFF000000000L;
    private static final int LINES_OFFSET = 36;
    private static final long WILL_DRAW_ON_FIRST_LINE_FLAG = 0x2000000000000000L;
    private static final int STATE_OFFSET = 62;
    private static boolean libraryLoaded;

    public static boolean willDrawOnFirstLine(long flag) {
        return (flag & 0x2000000000000000L) != 0L;
    }

    public static int getState(long flag) {
        return (int)(flag >>> 62);
    }

    public static int getCurrentLeft(long flag) {
        return (int)((flag & 0xFFF000L) >>> 12);
    }

    public static int getLines(long flag) {
        return (int)((flag & 0x1FFFFFF000000000L) >>> 36);
    }

    public static int getMaxWidth(long flag) {
        return (int)(flag & 0xFFFL);
    }

    public static int getMaxHeight(long flag) {
        return (int)((flag & 0xFFF000000L) >>> 24);
    }

    public static long setState(long flag, int state) {
        long stateL = state;
        flag = flag & 0x3FFFFFFFFFFFFFFFL | stateL << 62;
        return flag;
    }

    public static long setCurrentLeft(long flag, int currentLeft) {
        long leftL = currentLeft;
        flag = flag & 0xFFFFFFFFFF000FFFL | leftL << 12;
        return flag;
    }

    public static long setLines(long flag, int lines) {
        long ll = lines;
        flag = flag & 0xE000000FFFFFFFFFL | ll << 36;
        return flag;
    }

    public static long setMaxWidth(long flag, int maxWidth) {
        flag = flag & 0xFFFFFFFFFFFFF000L | (long)maxWidth;
        return flag;
    }

    public static long setMaxHeight(long flag, int maxHeight) {
        long hl = maxHeight;
        flag = flag & 0xFFFFFFF000FFFFFFL | hl << 24;
        return flag;
    }

    public static long setWillDrawOnFirstLine(long flag) {
        return flag |= 0x2000000000000000L;
    }

    public static long measureTextByNative(long flag, int left, int right, float[] widths) {
        if (libraryLoaded) {
            return MeasureTextUtils.nativeMeasureText(flag, left, right, widths);
        }
        return MeasureTextUtils.measureText(flag, left, right, widths, 0L);
    }

    private static native long nativeMeasureText(long var0, int var2, int var3, float[] var4);

    public static long measureText(long flag, int left, int right, float[] widths, long timeout) {
        long now = MeasureTextUtils.now();
        int contentWidth = right - left;
        int l = widths.length;
        for (int i = 0; i < l; ++i) {
            if ((float)contentWidth < widths[i]) {
                return MeasureTextUtils.setState(flag, 2);
            }
            if (timeout > 0L && MeasureTextUtils.now() - now >= timeout) {
                return MeasureTextUtils.setState(flag, 1);
            }
            if ((float)MeasureTextUtils.getCurrentLeft(flag) + widths[i] > (float)right) {
                if (i != 0) {
                    flag = MeasureTextUtils.setWillDrawOnFirstLine(flag);
                }
                flag = MeasureTextUtils.gotoCalNextLine(flag, left);
            }
            flag = MeasureTextUtils.setCurrentLeft(flag, (int)((double)MeasureTextUtils.getCurrentLeft(flag) + Math.ceil(widths[i])));
        }
        flag = MeasureTextUtils.calContentMaxWidth(flag, left);
        return flag;
    }

    public static long calContentMaxWidth(long flag, int left) {
        int max = Math.max(MeasureTextUtils.getMaxWidth(flag), MeasureTextUtils.getCurrentLeft(flag) - left);
        return MeasureTextUtils.setMaxWidth(flag, max);
    }

    public static long gotoCalNextLine(long flag, int left) {
        flag = MeasureTextUtils.setLines(flag, MeasureTextUtils.getLines(flag) + 1);
        flag = MeasureTextUtils.calContentMaxWidth(flag, left);
        return MeasureTextUtils.setCurrentLeft(flag, left);
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    static {
        try {
            System.loadLibrary("measure");
            libraryLoaded = true;
        }
        catch (Throwable e) {
            libraryLoaded = false;
        }
    }
}

