/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview.normal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import xfy.fakeview.library.fview.FView;
import xfy.fakeview.library.fview.IFViewRoot;
import xfy.fakeview.library.fview.utils.FMeasureSpec;

public class FImageView
extends FView {
    private Drawable mDrawable;
    private int mResource;
    private int mDrawableWidth;
    private int mDrawableHeight;
    private ScaleType mScaleType = ScaleType.FIT_CENTER;
    private Matrix mDrawMatrix;
    private Matrix mMatrix;
    private ColorFilter mColorFilter = null;
    private final RectF mTempSrc = new RectF();
    private final RectF mTempDst = new RectF();
    private boolean hasFrame = false;
    private static final Matrix.ScaleToFit[] sS2FArray = new Matrix.ScaleToFit[]{Matrix.ScaleToFit.FILL, Matrix.ScaleToFit.START, Matrix.ScaleToFit.CENTER, Matrix.ScaleToFit.END};

    public FImageView(Context context, IFViewRoot viewRoot) {
        super(context, viewRoot);
        this.mMatrix = new Matrix();
    }

    public void setScaleType(ScaleType scaleType) {
        if (scaleType == null) {
            throw new NullPointerException();
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.requestFViewTreeLayout();
            this.invalidate();
        }
    }

    public void setImageBitmap(Bitmap bitmap) {
        if (this.mDrawable instanceof BitmapDrawable && ((BitmapDrawable)this.mDrawable).getBitmap() == bitmap) {
            return;
        }
        this.setImageDrawable((Drawable)new BitmapDrawable(bitmap));
    }

    public void setImageResource(@DrawableRes int res) {
        int oldWidth = this.mDrawableWidth;
        int oldHeight = this.mDrawableHeight;
        this.updateDrawable(null);
        this.mResource = res;
        this.resolveRes();
        if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
            this.requestFViewTreeLayout();
        }
        this.invalidate();
    }

    public void setImageDrawable(Drawable drawable) {
        if (this.mDrawable != drawable) {
            this.mResource = 0;
            int oldWidth = this.mDrawableWidth;
            int oldHeight = this.mDrawableHeight;
            this.updateDrawable(drawable);
            if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
                this.requestFViewTreeLayout();
            }
            this.invalidate();
        }
    }

    private void resolveRes() {
        if (this.mDrawable != null) {
            return;
        }
        if (this.getResources() == null) {
            return;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = this.getResources().getDrawable(this.mResource);
            }
            catch (Exception exception) {}
        } else {
            return;
        }
        this.updateDrawable(d);
    }

    private void updateDrawable(Drawable d) {
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
            this.unscheduleDrawable(this.mDrawable);
            if (this.isAttachedToWindow()) {
                this.mDrawable.setVisible(false, false);
            }
        }
        this.mDrawable = d;
        if (d != null) {
            d.setCallback((Drawable.Callback)this);
            if (this.isAttachedToWindow()) {
                d.setVisible(this.getVisibility() == 0, true);
            }
            this.mDrawableWidth = d.getIntrinsicWidth();
            this.mDrawableHeight = d.getIntrinsicHeight();
            this.applyColorMod();
            this.configureBounds();
        } else {
            this.mDrawableHeight = -1;
            this.mDrawableWidth = -1;
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int w;
        int h;
        this.resolveRes();
        if (this.mDrawable == null) {
            this.mDrawableWidth = -1;
            this.mDrawableHeight = -1;
            h = 0;
            w = 0;
        } else {
            w = this.mDrawableWidth;
            h = this.mDrawableHeight;
            if (w <= 0) {
                w = 1;
            }
            if (h <= 0) {
                h = 1;
            }
        }
        int pleft = this.padding.left;
        int pright = this.padding.right;
        int ptop = this.padding.top;
        int pbottom = this.padding.bottom;
        w += pleft + pright;
        h += ptop + pbottom;
        w = Math.max(w, this.getSuggestedMinimumWidth());
        h = Math.max(h, this.getSuggestedMinimumHeight());
        int widthSize = FMeasureSpec.resolveSizeAndState(w, widthMeasureSpec, 0);
        int heightSize = FMeasureSpec.resolveSizeAndState(h, heightMeasureSpec, 0);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    @Override
    protected void setFrame(int l, int t, int r, int b) {
        super.setFrame(l, t, r, b);
        this.hasFrame = true;
        this.configureBounds();
    }

    private void configureBounds() {
        boolean fits;
        if (this.mDrawable == null || !this.hasFrame) {
            return;
        }
        int dwidth = this.mDrawableWidth;
        int dheight = this.mDrawableHeight;
        int vwidth = this.getWidth() - this.padding.left - this.padding.right;
        int vheight = this.getHeight() - this.padding.top - this.padding.bottom;
        boolean bl = fits = !(dwidth >= 0 && vwidth != dwidth || dheight >= 0 && vheight != dheight);
        if (dwidth <= 0 || dheight <= 0 || ScaleType.FIT_XY == this.mScaleType) {
            this.mDrawable.setBounds(0, 0, vwidth, vheight);
            this.mDrawMatrix = null;
        } else {
            this.mDrawable.setBounds(0, 0, dwidth, dheight);
            if (ScaleType.MATRIX == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix.isIdentity() ? null : this.mMatrix;
            } else if (fits) {
                this.mDrawMatrix = null;
            } else if (ScaleType.CENTER == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setTranslate((float)Math.round((float)(vwidth - dwidth) * 0.5f), (float)Math.round((float)(vheight - dheight) * 0.5f));
            } else if (ScaleType.CENTER_CROP == this.mScaleType) {
                float scale;
                this.mDrawMatrix = this.mMatrix;
                float dx = 0.0f;
                float dy = 0.0f;
                if (dwidth * vheight > vwidth * dheight) {
                    scale = (float)vheight / (float)dheight;
                    dx = ((float)vwidth - (float)dwidth * scale) * 0.5f;
                } else {
                    scale = (float)vwidth / (float)dwidth;
                    dy = ((float)vheight - (float)dheight * scale) * 0.5f;
                }
                this.mDrawMatrix.setScale(scale, scale);
                this.mDrawMatrix.postTranslate((float)Math.round(dx), (float)Math.round(dy));
            } else if (ScaleType.CENTER_INSIDE == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                float scale = dwidth <= vwidth && dheight <= vheight ? 1.0f : Math.min((float)vwidth / (float)dwidth, (float)vheight / (float)dheight);
                float dx = Math.round(((float)vwidth - (float)dwidth * scale) * 0.5f);
                float dy = Math.round(((float)vheight - (float)dheight * scale) * 0.5f);
                this.mDrawMatrix.setScale(scale, scale);
                this.mDrawMatrix.postTranslate(dx, dy);
            } else {
                this.mTempSrc.set(0.0f, 0.0f, (float)dwidth, (float)dheight);
                this.mTempDst.set(0.0f, 0.0f, (float)vwidth, (float)vheight);
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setRectToRect(this.mTempSrc, this.mTempDst, FImageView.scaleTypeToScaleToFit(this.mScaleType));
            }
        }
    }

    private void applyColorMod() {
        if (this.mDrawable != null) {
            this.mDrawable = this.mDrawable.mutate();
            if (this.mColorFilter != null) {
                this.mDrawable.setColorFilter(this.mColorFilter);
            }
        }
    }

    @Override
    public void invalidateDrawable(@NonNull Drawable dr) {
        if (dr == this.mDrawable) {
            if (dr != null) {
                int w = dr.getIntrinsicWidth();
                int h = dr.getIntrinsicHeight();
                if (w != this.mDrawableWidth || h != this.mDrawableHeight) {
                    this.mDrawableWidth = w;
                    this.mDrawableHeight = h;
                    this.configureBounds();
                }
            }
            this.invalidate();
        }
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        return who == this.mDrawable || super.verifyDrawable(who);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable == null) {
            return;
        }
        if (this.mDrawableWidth == 0 || this.mDrawableHeight == 0) {
            return;
        }
        if (this.mDrawMatrix == null && this.padding.top == 0 && this.padding.left == 0) {
            this.mDrawable.draw(canvas);
        } else {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            canvas.translate((float)this.padding.left, (float)this.padding.top);
            if (this.mDrawMatrix != null) {
                canvas.concat(this.mDrawMatrix);
            }
            this.mDrawable.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ScaleType st) {
        return sS2FArray[st.nativeInt - 1];
    }

    public static enum ScaleType {
        MATRIX(0),
        FIT_XY(1),
        FIT_START(2),
        FIT_CENTER(3),
        FIT_END(4),
        CENTER(5),
        CENTER_CROP(6),
        CENTER_INSIDE(7);

        final int nativeInt;

        private ScaleType(int ni) {
            this.nativeInt = ni;
        }
    }
}

