/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.compiler;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import xfy.fakeview.library.text.compiler.SpecialCompiler;
import xfy.fakeview.library.text.param.SpecialStyleParams;

public class SpecialTextHelper {
    private static Context context;
    private static ColorAdapter colorAdapter;
    private static WeightAdapter weightAdapter;
    private static SizeAdapter sizeAdapter;
    private static BackgroundColorAdapter backgroundColorAdapter;

    public static void init(Context c) {
        context = c.getApplicationContext();
    }

    public static SpecialCompiler getSpecialCompiler(Context context) {
        SpecialCompiler compiler = SpecialCompiler.getCompiler();
        SpecialTextHelper.initSpecialCompiler(context, compiler);
        return compiler;
    }

    public static void initSpecialCompiler(@NonNull Context context, @NonNull SpecialCompiler compiler) {
        if (SpecialTextHelper.context == null) {
            SpecialTextHelper.init(context);
        }
        if (colorAdapter == null || weightAdapter == null || sizeAdapter == null || backgroundColorAdapter == null) {
            colorAdapter = new ColorAdapter();
            weightAdapter = new WeightAdapter();
            sizeAdapter = new SizeAdapter();
            backgroundColorAdapter = new BackgroundColorAdapter();
            compiler.register("color", colorAdapter);
            compiler.register("weight", weightAdapter);
            compiler.register("size", sizeAdapter);
            compiler.register("background", backgroundColorAdapter);
        }
    }

    private static class BackgroundColorAdapter
    implements SpecialCompiler.SpecialStyleAdapter {
        private BackgroundColorAdapter() {
        }

        @Override
        public void setStyle(SpecialStyleParams params, String value) {
            params.withBackgroundColor(Color.parseColor((String)value));
        }
    }

    private static class SizeAdapter
    implements SpecialCompiler.SpecialStyleAdapter {
        private SizeAdapter() {
        }

        @Override
        public void setStyle(SpecialStyleParams params, String value) {
            int unit = 0;
            int index = value.indexOf("px");
            if (index > 0) {
                value = value.substring(0, index);
            } else {
                index = value.indexOf("dp");
                if (index > 0) {
                    value = value.substring(0, index);
                    unit = 1;
                } else {
                    index = value.indexOf("sp");
                    if (index > 0) {
                        value = value.substring(0, index);
                        unit = 2;
                    }
                }
            }
            try {
                int v = Integer.parseInt(value);
                params.withTextSize(TypedValue.applyDimension((int)unit, (float)v, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class WeightAdapter
    implements SpecialCompiler.SpecialStyleAdapter {
        private WeightAdapter() {
        }

        @Override
        public void setStyle(SpecialStyleParams params, String value) {
            if (Integer.parseInt(value) > 700) {
                params.boldText();
            }
        }
    }

    private static class ColorAdapter
    implements SpecialCompiler.SpecialStyleAdapter {
        private ColorAdapter() {
        }

        @Override
        public void setStyle(SpecialStyleParams params, String value) {
            params.withForegroundColor(Color.parseColor((String)value));
        }
    }
}

