/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.drawer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import xfy.fakeview.library.text.block.BlockMeasureParams;
import xfy.fakeview.library.text.block.IDrawableBlockList;
import xfy.fakeview.library.text.param.ImmutableParams;
import xfy.fakeview.library.text.param.SpecialStyleParams;
import xfy.fakeview.library.text.param.VariableParams;
import xfy.fakeview.library.text.utils.LineUtils;
import xfy.fakeview.library.text.utils.MeasureTextUtils;

public class TextDrawer {
    private static final String TAG = "Fake--TextDrawer";
    private static Paint.FontMetricsInt fontMetricsInt;
    private static boolean DEBUG;
    private static Paint debugPaint;
    private static final String ELLIPSIZE_TEXT = "...";

    public static void setDebug(boolean debug) {
        DEBUG = debug;
        if (debug) {
            if (debugPaint == null) {
                debugPaint = new Paint(1);
                debugPaint.setColor(-16711936);
            }
        } else {
            debugPaint = null;
        }
    }

    private static void drawLine(Canvas canvas, float x0, float y0, float x1, float y1) {
        if (!DEBUG) {
            return;
        }
        canvas.drawLine(x0, y0, x1, y1, debugPaint);
    }

    private static Paint.FontMetricsInt getFontMetricsInt() {
        if (fontMetricsInt == null) {
            fontMetricsInt = new Paint.FontMetricsInt();
        }
        return fontMetricsInt;
    }

    public static void drawText(Canvas canvas, CharSequence text, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams, @Nullable SpecialStyleParams styleParams) {
        TextPaint textPaint = immutableParams.paint;
        int oldFColor = textPaint.getColor();
        boolean oldUnderline = textPaint.isUnderlineText();
        Typeface oldType = textPaint.getTypeface();
        boolean oldFakeBold = textPaint.isFakeBoldText();
        float textSkewX = textPaint.getTextSkewX();
        float oldTextSize = textPaint.getTextSize();
        TextPaint backPaint = null;
        if (styleParams != null) {
            TextDrawer.setPaintByStyleParams(textPaint, styleParams);
            if (styleParams.hasBColor) {
                backPaint = textPaint;
                backPaint.bgColor = styleParams.backgroundColor;
            }
        }
        int textWidth = (int)Math.ceil(textPaint.measureText(text, 0, text.length()));
        int right = immutableParams.right;
        TextUtils.TruncateAt ellipsize = immutableParams.truncateAt;
        while (textWidth + variableParams.currentLeft > right) {
            int maxWidth = TextDrawer.getDrawMaxWidthFronNow(variableParams, immutableParams);
            int rmw = maxWidth < 0 ? -maxWidth : maxWidth;
            int breakPoint = textPaint.breakText(text, 0, text.length(), true, (float)rmw, null);
            if (backPaint != null) {
                TextDrawer.drawBack(canvas, backPaint, rmw, variableParams, immutableParams);
            }
            canvas.drawText(text, 0, breakPoint, (float)variableParams.currentLeft, (float)variableParams.currentBaseline, (Paint)textPaint);
            if (maxWidth < 0 && ellipsize == TextUtils.TruncateAt.END) {
                variableParams.currentLeft += (int)Math.ceil(textPaint.measureText(text, 0, breakPoint));
                if (backPaint != null) {
                    TextDrawer.drawBack(canvas, backPaint, immutableParams.ellipsizeLength, variableParams, immutableParams);
                }
                TextDrawer.drawEllipsize(canvas, variableParams, immutableParams);
                if (styleParams != null) {
                    TextDrawer.restorePaint(textPaint, oldFColor, oldUnderline, oldFakeBold, textSkewX, oldTextSize, oldType);
                }
                return;
            }
            TextDrawer.toNewDrawLine(variableParams, immutableParams);
            text = text.subSequence(breakPoint, text.length());
            textWidth = (int)Math.ceil(textPaint.measureText(text, 0, text.length()));
        }
        if (backPaint != null) {
            TextDrawer.drawBack(canvas, backPaint, textWidth, variableParams, immutableParams);
        }
        canvas.drawText(text, 0, text.length(), (float)variableParams.currentLeft, (float)variableParams.currentBaseline, (Paint)textPaint);
        variableParams.currentLeft += textWidth;
        if (styleParams != null) {
            TextDrawer.restorePaint(textPaint, oldFColor, oldUnderline, oldFakeBold, textSkewX, oldTextSize, oldType);
        }
    }

    private static void drawBack(@NonNull Canvas canvas, @NonNull TextPaint backPaint, int width, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        int[] linesHeight = immutableParams.lineInfos;
        int lh = 0;
        if (linesHeight != null) {
            lh = LineUtils.getLineHeight(linesHeight, variableParams.currentDrawLine);
        }
        lh = lh < 0 ? 0 : lh;
        int oldColor = backPaint.getColor();
        backPaint.setColor(backPaint.bgColor);
        canvas.drawRect((float)variableParams.currentLeft, (float)variableParams.currentTop, (float)(variableParams.currentLeft + width), (float)(variableParams.currentTop + lh), (Paint)backPaint);
        backPaint.setColor(oldColor);
    }

    private static void setPaintByStyleParams(@NonNull TextPaint paint, @NonNull SpecialStyleParams params) {
        if (params.hasFColor) {
            paint.setColor(params.foregroundColor);
        }
        if (params.hasTextSize) {
            paint.setTextSize(params.textSize);
        }
        paint.setUnderlineText(params.underline);
        int type = 0;
        if (params.bold) {
            type = params.italic ? 3 : 1;
        } else if (params.italic) {
            type = 2;
        }
        TextDrawer.apply((Paint)paint, type);
    }

    public static void apply(Paint paint, int style) {
        Typeface tf;
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int want = oldStyle | style;
        int fake = want & ~(tf = old == null ? Typeface.defaultFromStyle((int)want) : Typeface.create((Typeface)old, (int)want)).getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(tf);
    }

    public static void clear(Paint paint, int style) {
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int want = oldStyle & ~style;
        Typeface tf = old == null ? Typeface.defaultFromStyle((int)want) : Typeface.create((Typeface)old, (int)want);
        if ((style & 1) != 0) {
            paint.setFakeBoldText(false);
        }
        if ((style & 2) != 0) {
            paint.setTextSkewX(0.0f);
        }
        paint.setTypeface(tf);
    }

    private static void restorePaint(@NonNull TextPaint paint, int oldFColor, boolean oldUnderline, boolean oldFakeBold, float textSkewX, float textSize, Typeface oldType) {
        paint.setColor(oldFColor);
        paint.setUnderlineText(oldUnderline);
        paint.setTypeface(oldType);
        paint.setFakeBoldText(oldFakeBold);
        paint.setTextSkewX(textSkewX);
        paint.setTextSize(textSize);
        paint.bgColor = 0;
    }

    public static void drawNextLine(Canvas canvas, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        int needDrawLines = immutableParams.needDrawLine;
        if (variableParams.currentDrawLine + 1 == needDrawLines) {
            TextDrawer.drawEllipsize(canvas, variableParams, immutableParams);
        } else {
            TextDrawer.toNewDrawLine(variableParams, immutableParams);
        }
    }

    public static int getDrawMaxWidthFronNow(@NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        int right = immutableParams.right;
        int needDrawLines = immutableParams.needDrawLine;
        TextUtils.TruncateAt ellipsize = immutableParams.truncateAt;
        int ellipsizeLength = immutableParams.ellipsizeLength;
        int maxWidth = right - variableParams.currentLeft;
        if (ellipsize != null && variableParams.currentDrawLine + 1 == needDrawLines) {
            maxWidth -= ellipsizeLength;
            maxWidth = -maxWidth;
        }
        return maxWidth;
    }

    public static void drawEllipsize(Canvas canvas, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        TextPaint textPaint = immutableParams.paint;
        canvas.drawText(ELLIPSIZE_TEXT, (float)variableParams.currentLeft, (float)variableParams.currentBaseline, (Paint)textPaint);
        variableParams.currentLeft += immutableParams.ellipsizeLength;
        variableParams.isDrawEndEllipsize = true;
    }

    private static void toNewDrawLine(@NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        ++variableParams.currentDrawLine;
        TextUtils.TruncateAt ellipsize = immutableParams.truncateAt;
        int[] lineInfos = immutableParams.lineInfos;
        int lh = 0;
        if (lineInfos != null) {
            int lastBaseLine = LineUtils.getBaseLine(lineInfos, variableParams.currentDrawLine - 1);
            int nextBaseLine = LineUtils.getBaseLine(lineInfos, variableParams.currentDrawLine);
            nextBaseLine = nextBaseLine < 0 ? 0 : nextBaseLine;
            int lastHeight = LineUtils.getLineHeight(lineInfos, variableParams.currentDrawLine - 1);
            lastHeight = lastHeight < 0 ? 0 : lastHeight;
            lh = lastHeight + nextBaseLine - lastBaseLine;
        }
        int addOn = immutableParams.lineSpace;
        variableParams.currentBaseline = ellipsize != null ? (variableParams.currentBaseline += lh + addOn) : (variableParams.currentBaseline += lh + addOn);
        variableParams.currentLeft = immutableParams.left;
        variableParams.currentTop += lh + addOn;
    }

    public static long measureText(TextPaint textPaint, CharSequence text, int currentLeft, int left, int right, long timeout) {
        long flag = MeasureTextUtils.setLines(MeasureTextUtils.setCurrentLeft(0L, currentLeft), 1);
        float[] widths = new float[text.length()];
        textPaint.getTextWidths(text.toString(), widths);
        flag = timeout > 0L ? MeasureTextUtils.measureText(flag, left, right, widths, timeout) : MeasureTextUtils.measureTextByNative(flag, left, right, widths);
        return flag;
    }

    public static long measureFixWidth(int width, int currentLeft, int left, int right) {
        long flag = MeasureTextUtils.setLines(MeasureTextUtils.setCurrentLeft(0L, currentLeft), 1);
        if (currentLeft + width > right) {
            flag = MeasureTextUtils.gotoCalNextLine(flag, left);
        }
        return MeasureTextUtils.calContentMaxWidth(MeasureTextUtils.setCurrentLeft(flag, MeasureTextUtils.getCurrentLeft(flag) + width), left);
    }

    public static long measureText(@NonNull ImmutableParams immutableParams, IDrawableBlockList list, int drawableSize, int currentLeft, int left, int right, boolean includePad) {
        BlockMeasureParams params = BlockMeasureParams.obtain().setLineInfo(TextDrawer.getLineInfo(immutableParams.paint, drawableSize, includePad)).setDrawableSize(drawableSize).setCurrentLeft(currentLeft).setCurrentTop(0).setLeft(left).setRight(right).setIncludePad(includePad);
        return list.measure(params, immutableParams);
    }

    public static int getLineInfo(TextPaint paint, int drawableSize, boolean includePad) {
        Paint.FontMetricsInt fontMetricsInt = TextDrawer.getFontMetricsInt();
        paint.getFontMetricsInt(fontMetricsInt);
        int top = TextDrawer.getFontHeightCalTop(fontMetricsInt, includePad);
        int bot = TextDrawer.getFontHeightCalBottom(fontMetricsInt, includePad);
        int fh = bot - top;
        int baseLine = -top;
        if (fh < drawableSize) {
            baseLine += drawableSize - fh >> 1;
            fh = drawableSize;
        }
        return LineUtils.combime(fh, baseLine);
    }

    public static int getFontHeight(TextPaint paint, boolean includePad) {
        Paint.FontMetricsInt fontMetricsInt = TextDrawer.getFontMetricsInt();
        paint.getFontMetricsInt(fontMetricsInt);
        return TextDrawer.getFontHeight(fontMetricsInt, includePad);
    }

    public static int getFontHeight(Paint.FontMetricsInt fontMetricsInt, boolean includePad) {
        return TextDrawer.getFontHeightCalBottom(fontMetricsInt, includePad) - TextDrawer.getFontHeightCalTop(fontMetricsInt, includePad);
    }

    public static int getFontHeightCalTop(Paint.FontMetricsInt fontMetricsInt, boolean includePad) {
        return includePad ? fontMetricsInt.top : fontMetricsInt.ascent;
    }

    public static int getFontHeightCalBottom(Paint.FontMetricsInt fontMetricsInt, boolean includePad) {
        return includePad ? fontMetricsInt.bottom : fontMetricsInt.descent;
    }

    public static int getEllipsizeLength(TextPaint paint) {
        return (int)Math.ceil(paint.measureText(ELLIPSIZE_TEXT));
    }

    private static long nano() {
        return System.nanoTime();
    }

    private static long logCast(String pre, long start) {
        long nano = TextDrawer.nano();
        Log.d((String)TAG, (String)(pre + (nano - start)));
        return nano;
    }

    static {
        DEBUG = false;
    }
}

