/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.drawer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import xfy.fakeview.library.text.drawer.TextDrawer;
import xfy.fakeview.library.text.param.ImmutableParams;
import xfy.fakeview.library.text.param.VariableParams;
import xfy.fakeview.library.text.utils.IllegalDrawableException;

public class TextDrawableDrawer {
    private static volatile TextDrawableDrawer drawableDrawer;
    private static Context context;

    public static void init(Context c) {
        context = c.getApplicationContext();
    }

    protected TextDrawableDrawer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextDrawableDrawer getDrawableDrawer() {
        if (drawableDrawer != null) return drawableDrawer;
        Class<TextDrawableDrawer> clazz = TextDrawableDrawer.class;
        synchronized (TextDrawableDrawer.class) {
            if (drawableDrawer != null) return drawableDrawer;
            drawableDrawer = new TextDrawableDrawer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return drawableDrawer;
        }
    }

    public Drawable drawResource(@NonNull Canvas canvas, @DrawableRes int res, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        Drawable drawable = this.getSpecialDrawable(res, immutableParams.drawableHeight);
        return this.drawDrawable(canvas, drawable, false, variableParams, immutableParams);
    }

    public Drawable drawDrawable(Canvas canvas, Drawable drawable, boolean forceNewDrawable, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        drawable = this.getSpecialDrawable(drawable, immutableParams.drawableHeight, forceNewDrawable);
        this.drawSpecialDrawable(canvas, drawable, variableParams, immutableParams);
        return drawable;
    }

    public Drawable getSpecialDrawable(@DrawableRes int res, int drawableHeight) {
        return this.getSpecialDrawable(this.getResources().getDrawable(res), drawableHeight, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getSpecialDrawable(Drawable drawable, int drawableHeight, boolean forceNewDrawable) {
        if (forceNewDrawable) {
            Drawable.ConstantState state = drawable.getConstantState();
            if (state == null) throw new IllegalDrawableException("drawable " + drawable.getClass().getName() + " return null constant state");
            Drawable newDrawable = state.newDrawable();
            if (newDrawable == null || newDrawable == drawable) throw new IllegalDrawableException("drawable " + drawable.getClass().getName() + " state return a null or a same drawable.");
            drawable = newDrawable;
        }
        TextDrawableDrawer.initDrawableBounds(drawable, drawableHeight);
        return drawable;
    }

    public void drawSpecialDrawable(Canvas canvas, Drawable drawable, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        int dh = immutableParams.drawableHeight;
        TextDrawableDrawer.initDrawableBounds(drawable, dh);
        int dw = TextDrawableDrawer.measureDrawableWidth(drawable, dh);
        int maxWidth = TextDrawer.getDrawMaxWidthFronNow(variableParams, immutableParams);
        if (maxWidth < 0 && -maxWidth < dw) {
            TextDrawer.drawEllipsize(canvas, variableParams, immutableParams);
            return;
        }
        canvas.save();
        float scale = TextDrawableDrawer.measureDrawableScale(drawable, dh);
        canvas.translate((float)variableParams.currentLeft, (float)variableParams.currentTop);
        canvas.scale(scale, scale);
        drawable.draw(canvas);
        canvas.restore();
        variableParams.currentLeft += dw;
    }

    private static void initDrawableBounds(Drawable d, int dh) {
        Rect bounds = d.getBounds();
        int bw = bounds.width();
        int bh = bounds.height();
        int iw = d.getIntrinsicWidth();
        int ih = d.getIntrinsicHeight();
        if (bw == 0 || bh == 0 || bw * ih != bh * iw) {
            if (iw == 0 || ih == 0) {
                d.setBounds(0, 0, dh, dh);
            } else {
                d.setBounds(0, 0, iw, ih);
            }
        }
    }

    protected Resources getResources() {
        return context.getResources();
    }

    public static int measureDrawableWidth(Drawable d, int drawableSize) {
        int iw = d.getIntrinsicWidth();
        int ih = d.getIntrinsicHeight();
        if (ih == 0) {
            return drawableSize;
        }
        return drawableSize * iw / ih;
    }

    private static float measureDrawableScale(Drawable d, int dh) {
        Rect bounds = d.getBounds();
        float bh = bounds.height();
        return (float)dh / bh;
    }
}

