/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.compiler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Spanned;
import xfy.fakeview.library.text.block.DefaultDrawableBlock;
import xfy.fakeview.library.text.block.DefaultDrawableBlockList;
import xfy.fakeview.library.text.compiler.DefaultTextCompiler;
import xfy.fakeview.library.text.compiler.ITextCompiler;
import xfy.fakeview.library.text.param.SpecialStyleParams;
import xfy.fakeview.library.text.utils.FClickableSpan;

public class ClickSpanTextCompiler
extends DefaultTextCompiler {
    private static volatile ClickSpanTextCompiler compiler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClickSpanTextCompiler getCompiler() {
        if (compiler != null) return compiler;
        Class<ClickSpanTextCompiler> clazz = ClickSpanTextCompiler.class;
        synchronized (ClickSpanTextCompiler.class) {
            if (compiler != null) return compiler;
            compiler = new ClickSpanTextCompiler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return compiler;
        }
    }

    protected ClickSpanTextCompiler() {
    }

    public ClickSpanTextCompiler(ITextCompiler<DefaultDrawableBlockList> innerCompiler) {
        super(innerCompiler);
    }

    @Override
    public void compileInternal(@NonNull DefaultDrawableBlockList list, @NonNull CharSequence text, int start, int end, @Nullable SpecialStyleParams specialStyleParams) {
        if (text instanceof Spanned) {
            int len;
            Spanned spanned = (Spanned)text;
            FClickableSpan[] spans = (FClickableSpan[])spanned.getSpans(start, end, FClickableSpan.class);
            int n = len = spans == null ? 0 : spans.length;
            if (len > 0) {
                FClickableSpan span = null;
                int spanStart = 0;
                int lastSpanEnd = start;
                for (int i = 0; i < len; ++i) {
                    span = spans[i];
                    spanStart = spanned.getSpanStart((Object)span);
                    if (lastSpanEnd < spanStart) {
                        super.compileInternal(list, text, lastSpanEnd, spanStart, specialStyleParams);
                    }
                    lastSpanEnd = spanned.getSpanEnd((Object)span);
                    this.compileSpan(list, span, text, spanStart, lastSpanEnd, specialStyleParams);
                }
                if (lastSpanEnd < end) {
                    super.compileInternal(list, text, lastSpanEnd, end, specialStyleParams);
                }
                return;
            }
        }
        super.compileInternal(list, text, start, end, specialStyleParams);
    }

    private void compileSpan(DefaultDrawableBlockList list, FClickableSpan span, CharSequence text, int start, int end, @Nullable SpecialStyleParams specialStyleParams) {
        DefaultDrawableBlockList children = DefaultDrawableBlockList.obtain(start, end);
        super.compileInternal(children, text, start, end, specialStyleParams);
        list.add(DefaultDrawableBlock.createSpanBlock(text.subSequence(start, end), span, children));
    }
}

