/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.drawer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import xfy.fakeview.library.text.drawer.TextDrawer;
import xfy.fakeview.library.text.param.ImmutableParams;
import xfy.fakeview.library.text.param.VariableParams;

public class TextDrawableDrawer {
    private static volatile TextDrawableDrawer drawableDrawer;
    private static Context context;

    public static void init(Context c) {
        context = c.getApplicationContext();
    }

    protected TextDrawableDrawer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextDrawableDrawer getDrawableDrawer() {
        if (drawableDrawer != null) return drawableDrawer;
        Class<TextDrawableDrawer> clazz = TextDrawableDrawer.class;
        synchronized (TextDrawableDrawer.class) {
            if (drawableDrawer != null) return drawableDrawer;
            drawableDrawer = new TextDrawableDrawer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return drawableDrawer;
        }
    }

    public Drawable drawResource(@NonNull Canvas canvas, @DrawableRes int res, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        Drawable drawable = this.getSpecialDrawable(res, immutableParams.drawableHeight);
        return this.drawDrawable(canvas, drawable, variableParams, immutableParams);
    }

    public Drawable drawDrawable(Canvas canvas, Drawable drawable, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        drawable = this.getSpecialDrawable(drawable, immutableParams.drawableHeight);
        this.drawSpecialDrawable(canvas, drawable, variableParams, immutableParams);
        return drawable;
    }

    public Drawable getSpecialDrawable(@DrawableRes int res, int drawableHeight) {
        return this.getSpecialDrawable(this.getResources().getDrawable(res), drawableHeight);
    }

    public Drawable getSpecialDrawable(Drawable drawable, int drawableHeight) {
        Rect bounds = drawable.getBounds();
        if (bounds.height() != drawableHeight) {
            int diw = drawable.getIntrinsicWidth();
            float dih = drawable.getIntrinsicHeight();
            int dw = dih != 0.0f ? (int)((float)(diw * drawableHeight) / dih) : drawableHeight;
            drawable.setBounds(0, 0, dw, drawableHeight);
        }
        return drawable;
    }

    public void drawSpecialDrawable(Canvas canvas, Drawable drawable, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        int maxWidth;
        int dh = immutableParams.drawableHeight;
        Rect bounds = drawable.getBounds();
        int dw = bounds.width();
        if (bounds.height() != dh) {
            int diw = drawable.getIntrinsicWidth();
            float dih = drawable.getIntrinsicHeight();
            dw = dih != 0.0f ? (int)((float)(diw * dh) / dih) : dh;
            drawable.setBounds(0, 0, dw, dh);
        }
        if ((maxWidth = TextDrawer.getDrawMaxWidthFronNow(variableParams, immutableParams)) < 0 && -maxWidth < dw) {
            TextDrawer.drawEllipsize(canvas, variableParams, immutableParams);
            return;
        }
        canvas.save();
        canvas.translate((float)variableParams.currentLeft, (float)variableParams.currentTop);
        drawable.draw(canvas);
        canvas.restore();
        variableParams.currentLeft += dw;
    }

    protected Resources getResources() {
        return context.getResources();
    }
}

