/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.compiler;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import xfy.fakeview.library.text.block.DefaultDrawableBlock;
import xfy.fakeview.library.text.block.DefaultDrawableBlockList;
import xfy.fakeview.library.text.compiler.DefaultTextCompiler;

public class DrawableTextCompiler
extends DefaultTextCompiler {
    private static volatile DrawableTextCompiler compiler;
    protected char D_START = (char)91;
    protected char D_END = (char)93;
    private ResourceAdapter adapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DrawableTextCompiler getCompiler() {
        if (compiler != null) return compiler;
        Class<DrawableTextCompiler> clazz = DrawableTextCompiler.class;
        synchronized (DrawableTextCompiler.class) {
            if (compiler != null) return compiler;
            compiler = new DrawableTextCompiler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return compiler;
        }
    }

    protected DrawableTextCompiler() {
    }

    public void setResourceAdapter(ResourceAdapter adapter) {
        this.adapter = adapter;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.adapter;
    }

    @Override
    protected DefaultDrawableBlockList realCompile(@NonNull CharSequence text, int start, int end) {
        if (this.adapter == null) {
            return super.realCompile(text, start, end);
        }
        DefaultDrawableBlockList list = DefaultDrawableBlockList.obtain(start, end);
        this.compileDrawbleText(list, text, start, end);
        return list;
    }

    protected void compileDrawbleText(DefaultDrawableBlockList list, @NonNull CharSequence text, int start, int end) {
        int index;
        boolean haveStart = false;
        int lastStartIndex = -1;
        int lastEndIndex = start;
        for (index = start; index < end; ++index) {
            char c = text.charAt(index);
            if (c == this.D_START) {
                lastStartIndex = index;
                haveStart = true;
                continue;
            }
            if (c != this.D_END) continue;
            if (haveStart) {
                CharSequence parseText;
                int res;
                if (lastEndIndex != lastStartIndex) {
                    this.compileNewLines(list, text.subSequence(lastEndIndex, lastStartIndex));
                }
                if ((res = this.adapter.parseRes(parseText = text.subSequence(lastStartIndex, index + 1))) <= 0) {
                    Drawable d = this.adapter.parseDrawable(parseText);
                    if (d == null) {
                        this.compileNewLines(list, parseText);
                    } else {
                        list.add(DefaultDrawableBlock.createSpecialDrawableBlock(parseText, d));
                    }
                } else {
                    list.add(DefaultDrawableBlock.createDrawableBlock(parseText, res));
                }
                lastEndIndex = index + 1;
            }
            haveStart = false;
        }
        if (lastEndIndex != index) {
            this.compileNewLines(list, text.subSequence(lastEndIndex, index));
        }
    }

    public static interface ResourceAdapter {
        public int parseRes(@NonNull CharSequence var1);

        public Drawable parseDrawable(@NonNull CharSequence var1);
    }
}

