/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview.normal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import xfy.fakeview.library.fview.FView;
import xfy.fakeview.library.fview.IFViewRoot;
import xfy.fakeview.library.fview.utils.FMeasureSpec;

public class FTextView
extends FView {
    private int mTextColor = -16777216;
    private CharSequence mText = "";
    protected final TextPaint mTextPaint;
    private Layout mLayout;
    private TextUtils.TruncateAt mEllipsize;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private boolean mIncludePad = true;
    private int mGravity = 0x800033;

    public FTextView(Context context, IFViewRoot viewRoot) {
        super(context, viewRoot);
        Resources res = this.getResources();
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int widthMode = FMeasureSpec.getMode(widthMeasureSpec);
        int heightMode = FMeasureSpec.getMode(heightMeasureSpec);
        int widthSize = FMeasureSpec.getSize(widthMeasureSpec);
        int heightSize = FMeasureSpec.getSize(heightMeasureSpec);
        int des = -1;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            if (this.mLayout != null && this.mEllipsize == null) {
                des = FTextView.desired(this.mLayout);
            }
            if (des < 0) {
                des = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)this.mText, (TextPaint)this.mTextPaint));
            }
            width = des;
            width += this.getPaddingLeft() + this.getPaddingRight();
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        int want = width - this.getPaddingLeft() - this.getPaddingRight();
        if (this.mLayout == null) {
            this.makeNewLayout(want, want);
        } else {
            boolean layoutChanged;
            boolean bl = layoutChanged = this.mLayout.getWidth() != want || this.mLayout.getEllipsizedWidth() != want;
            if (layoutChanged) {
                this.mLayout.increaseWidthTo(want);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            int desired;
            height = desired = this.getDesiredHeight(this.mLayout);
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(desired, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public void setBoldText(boolean bold) {
        if (this.mTextPaint.isFakeBoldText() != bold) {
            this.mTextPaint.setFakeBoldText(bold);
            if (this.mLayout != null) {
                this.mLayout = null;
                this.requestFViewTreeLayout();
                this.invalidate();
            }
        }
    }

    public void setTextColor(int color) {
        if (this.mTextColor != color) {
            this.mTextColor = color;
            this.invalidate();
        }
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setEllipsize(TextUtils.TruncateAt ellipsize) {
        if (this.mEllipsize != ellipsize) {
            this.mEllipsize = ellipsize;
            this.requestFViewTreeLayout();
            this.invalidate();
        }
    }

    public float getTextSize() {
        return this.mTextPaint.getTextSize();
    }

    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        Context c = this.getContext();
        Resources r = c == null ? Resources.getSystem() : c.getResources();
        float px = TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics());
        if (px != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(px);
            if (this.mLayout != null) {
                this.mLayout = null;
                this.requestFViewTreeLayout();
                this.invalidate();
            }
        }
    }

    public void setText(CharSequence text) {
        this.setTextInnternal(text);
    }

    private void setTextInnternal(CharSequence text) {
        this.mText = text = TextUtils.stringOrSpannedString((CharSequence)text);
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        this.mTextPaint.setColor(this.mTextColor);
        if (this.padding.left == 0 && this.padding.top == 0) {
            this.mLayout.draw(canvas);
        } else {
            canvas.save();
            canvas.translate((float)this.padding.left, (float)this.padding.top);
            this.mLayout.draw(canvas);
            canvas.restore();
        }
    }

    private void assumeLayout() {
        int width = this.bounds.right - this.bounds.left - this.padding.left - this.padding.right;
        if (width < 1) {
            width = 0;
        }
        this.makeNewLayout(width, width);
    }

    private Layout.Alignment getLayoutAlignment() {
        Layout.Alignment alignment;
        switch (this.mGravity & 0x800007) {
            case 0x800003: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 0x800005: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 5: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 1: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            default: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        return alignment;
    }

    private void checkForRelayout() {
        if (this.mFLayoutParams.width != -2 && this.bounds.right - this.bounds.left - this.padding.left - this.padding.right > 0) {
            int oldht = this.mLayout.getHeight();
            int want = this.mLayout.getWidth();
            this.makeNewLayout(want, this.bounds.right - this.bounds.left - this.padding.left - this.padding.right);
            if (this.mEllipsize != TextUtils.TruncateAt.MARQUEE) {
                if (this.mFLayoutParams.height != -2 && this.mFLayoutParams.height != -1) {
                    this.invalidate();
                    return;
                }
                if (this.mLayout.getHeight() == oldht) {
                    this.invalidate();
                    return;
                }
            }
            this.requestFViewTreeLayout();
            this.invalidate();
        } else {
            this.mLayout = null;
            this.requestFViewTreeLayout();
            this.invalidate();
        }
    }

    private void makeNewLayout(int wantWidth, int ellipsisWidth) {
        if (wantWidth < 0) {
            wantWidth = 0;
        }
        Layout.Alignment alignment = this.getLayoutAlignment();
        boolean shouldEllipsize = this.mEllipsize != null;
        this.mLayout = this.makeSingleLayout(wantWidth, ellipsisWidth, alignment, shouldEllipsize, this.mEllipsize, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
    }

    private Layout makeSingleLayout(int wantWidth, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, float spacingMult, float spacingAdd, boolean includePad) {
        DynamicLayout result = null;
        if (this.mText instanceof Spannable) {
            result = new DynamicLayout(this.mText, this.mText, this.mTextPaint, wantWidth, alignment, spacingMult, spacingAdd, includePad, effectiveEllipsize, ellipsisWidth);
        }
        if (result == null) {
            result = shouldEllipsize ? new StaticLayout(this.mText, 0, this.mText.length(), this.mTextPaint, wantWidth, alignment, spacingMult, spacingAdd, includePad, effectiveEllipsize, ellipsisWidth) : new StaticLayout(this.mText, 0, this.mText.length(), this.mTextPaint, wantWidth, alignment, spacingMult, spacingAdd, includePad);
        }
        return result;
    }

    private static int desired(Layout layout) {
        int i;
        int n = layout.getLineCount();
        CharSequence text = layout.getText();
        float max = 0.0f;
        for (i = 0; i < n - 1; ++i) {
            if (text.charAt(layout.getLineEnd(i) - 1) == '\n') continue;
            return -1;
        }
        for (i = 0; i < n; ++i) {
            max = Math.max(max, layout.getLineWidth(i));
        }
        return (int)Math.ceil(max);
    }

    private int getDesiredHeight(Layout layout) {
        if (layout == null) {
            return 0;
        }
        int desired = layout.getHeight();
        int padding = this.getPaddingTop() + this.getPaddingBottom();
        desired += padding;
        desired = Math.max(desired, this.getSuggestedMinimumHeight());
        return desired;
    }
}

