/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.compiler;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.LruCache;
import xfy.fakeview.library.text.block.DefaultDrawableBlock;
import xfy.fakeview.library.text.block.DefaultDrawableBlockList;
import xfy.fakeview.library.text.compiler.ITextCompiler;
import xfy.fakeview.library.text.param.SpecialStyleParams;

public class DefaultTextCompiler
implements ITextCompiler<DefaultDrawableBlockList> {
    private static volatile DefaultTextCompiler compiler;
    private final LruCache<CharSequence, DefaultDrawableBlockList> cache = new LruCache<CharSequence, DefaultDrawableBlockList>(this.cacheSize()){

        protected void entryRemoved(boolean evicted, CharSequence key, DefaultDrawableBlockList oldValue, DefaultDrawableBlockList newValue) {
            if (oldValue != null) {
                oldValue.canRecycle();
            }
            if (newValue != null) {
                newValue.doNotRecycle();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultTextCompiler getCompiler() {
        if (compiler != null) return compiler;
        Class<DefaultTextCompiler> clazz = DefaultTextCompiler.class;
        synchronized (DefaultTextCompiler.class) {
            if (compiler != null) return compiler;
            compiler = new DefaultTextCompiler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return compiler;
        }
    }

    protected DefaultTextCompiler() {
    }

    protected int cacheSize() {
        return 30;
    }

    @Override
    public DefaultDrawableBlockList compile(@NonNull CharSequence charSequence) {
        return this.compile(charSequence, 0, charSequence.length());
    }

    @Override
    public DefaultDrawableBlockList compile(@NonNull CharSequence text, int start, int end) {
        DefaultDrawableBlockList result;
        if (start < 0 || start >= text.length()) {
            throw new IllegalArgumentException("start must >= 0 and < text.length");
        }
        if (end <= start) {
            throw new IllegalArgumentException("end must > start");
        }
        int size = text.length();
        if (end > size) {
            end = size;
        }
        if ((result = (DefaultDrawableBlockList)this.cache.get((Object)text)) != null && result.getStart() == start && result.getEnd() == end) {
            result.use();
            return result;
        }
        result = this.realCompile(text, start, end);
        result.use();
        result.doNotRecycle();
        DefaultDrawableBlockList pre = (DefaultDrawableBlockList)this.cache.put((Object)text, (Object)result);
        if (pre != null) {
            pre.canRecycle();
        }
        return result;
    }

    protected DefaultDrawableBlockList realCompile(@NonNull CharSequence text, int start, int end) {
        DefaultDrawableBlockList list = DefaultDrawableBlockList.obtain(start, end);
        this.compileNewLines(list, text.subSequence(start, end));
        return list;
    }

    protected void compileNewLines(DefaultDrawableBlockList list, CharSequence t) {
        this.compileNewLines(list, t, null);
    }

    protected void compileNewLines(DefaultDrawableBlockList list, CharSequence t, SpecialStyleParams specialStyleParams) {
        if (t.length() == 0) {
            return;
        }
        String text = t.toString();
        int len = text.length();
        int newLineIndex = text.indexOf(10);
        while (newLineIndex >= 0) {
            if (newLineIndex != 0) {
                list.add(DefaultDrawableBlock.createTextBlock(text.substring(0, newLineIndex), specialStyleParams));
            }
            list.add(DefaultDrawableBlock.createNextLineBlock());
            if (newLineIndex == len) {
                text = null;
                break;
            }
            text = text.substring(newLineIndex + 1);
            newLineIndex = text.indexOf(10);
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            list.add(DefaultDrawableBlock.createTextBlock(text, specialStyleParams));
        }
    }
}

