/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.compiler;

import android.support.annotation.NonNull;
import android.text.Spanned;
import xfy.fakeview.library.text.block.DefaultDrawableBlock;
import xfy.fakeview.library.text.block.DefaultDrawableBlockList;
import xfy.fakeview.library.text.compiler.DefaultTextCompiler;
import xfy.fakeview.library.text.utils.FClickableSpan;

public class ClickSpanTextCompiler
extends DefaultTextCompiler {
    private static volatile ClickSpanTextCompiler compiler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClickSpanTextCompiler getCompiler() {
        if (compiler != null) return compiler;
        Class<ClickSpanTextCompiler> clazz = ClickSpanTextCompiler.class;
        synchronized (ClickSpanTextCompiler.class) {
            if (compiler != null) return compiler;
            compiler = new ClickSpanTextCompiler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return compiler;
        }
    }

    protected ClickSpanTextCompiler() {
    }

    @Override
    protected DefaultDrawableBlockList realCompile(@NonNull CharSequence text, int start, int end) {
        if (text instanceof Spanned) {
            int len;
            Spanned spanned = (Spanned)text;
            FClickableSpan[] spans = (FClickableSpan[])spanned.getSpans(start, end, FClickableSpan.class);
            int n = len = spans == null ? 0 : spans.length;
            if (len > 0) {
                DefaultDrawableBlockList list = DefaultDrawableBlockList.obtain(start, end);
                FClickableSpan span = null;
                int spanStart = 0;
                int lastSpanEnd = start;
                for (int i = 0; i < len; ++i) {
                    span = spans[i];
                    spanStart = spanned.getSpanStart((Object)span);
                    if (lastSpanEnd < spanStart) {
                        this.compileNewLines(list, text.subSequence(lastSpanEnd, spanStart));
                    }
                    lastSpanEnd = spanned.getSpanEnd((Object)span);
                    this.compileSpan(list, span, text, spanStart, lastSpanEnd);
                }
                if (lastSpanEnd < end) {
                    this.compileNewLines(list, text.subSequence(lastSpanEnd, end));
                }
                return list;
            }
        }
        return super.realCompile(text, start, end);
    }

    protected void compileSpan(DefaultDrawableBlockList list, FClickableSpan span, CharSequence text, int start, int end) {
        DefaultDrawableBlockList children = super.realCompile(text, start, end);
        list.add(DefaultDrawableBlock.createSpanBlock(text.subSequence(start, end), span, children));
    }
}

