/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.block;

import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import xfy.fakeview.library.text.block.DefaultDrawableBlock;
import xfy.fakeview.library.text.block.IDrawableBlock;
import xfy.fakeview.library.text.block.IDrawableBlockList;
import xfy.fakeview.library.text.param.ImmutableParams;
import xfy.fakeview.library.text.param.VariableParams;
import xfy.fakeview.library.text.utils.LineUtils;
import xfy.fakeview.library.text.utils.MeasureTextUtils;
import xfy.fakeview.library.text.utils.SimpleGravity;

public class DefaultDrawableBlockList
extends ArrayList<DefaultDrawableBlock>
implements IDrawableBlockList<DefaultDrawableBlock> {
    private static final String TAG = "Fake--BlockList";
    private int mStart;
    private int mEnd;
    private int mNewLineCount;
    private int mDrawableCount;
    private int mSpecialDrawableCount;
    private boolean hasSpan = false;
    private long lastFlag = 0L;
    private int lastDrawableSize = 0;
    private int lastCLeft = 0;
    private int lastLeft = 0;
    private int lastRight = 0;
    private static final int DEFAULT_EXPAND_SIZE = 10;
    private int[] lineFlags;
    private int lines = 0;
    private volatile int useCount = 0;
    private static final int DEFAULT_SIZE = 10;
    private static final List<DefaultDrawableBlockList> cache = new ArrayList<DefaultDrawableBlockList>(10);
    private static final int NOT_RECYCLE_COUNT = -1;

    public static synchronized DefaultDrawableBlockList obtain(int start, int end) {
        if (cache.isEmpty()) {
            return new DefaultDrawableBlockList(start, end);
        }
        DefaultDrawableBlockList list = cache.remove(0);
        list.mStart = start;
        list.mEnd = end;
        return list;
    }

    private static synchronized void putToCache(DefaultDrawableBlockList list) {
        cache.add(list);
    }

    private void recycle() {
        this.lineFlags = null;
        this.hasSpan = false;
        this.mNewLineCount = 0;
        this.mDrawableCount = 0;
        this.mSpecialDrawableCount = 0;
        this.lastFlag = 0L;
        this.lastDrawableSize = 0;
        this.lastCLeft = 0;
        this.lastLeft = 0;
        this.lastRight = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            DefaultDrawableBlock block = (DefaultDrawableBlock)this.get(i);
            if (block == null) continue;
            block.recycle();
        }
        this.clear();
        DefaultDrawableBlockList.putToCache(this);
    }

    @Override
    public synchronized void notUse() {
        this.useCount = this.useCount < 0 ? ++this.useCount : --this.useCount;
        if (this.useCount == 0) {
            this.recycle();
        }
    }

    @Override
    public synchronized void doNotRecycle() {
        if (this.useCount >= 0) {
            this.useCount = -1 - this.useCount;
        }
    }

    @Override
    public synchronized void canRecycle() {
        if (this.useCount <= -1) {
            this.useCount = -1 - this.useCount;
        }
        if (this.useCount == 0) {
            this.recycle();
        }
    }

    @Override
    public boolean onTouchEvent(@NonNull View v, MotionEvent event, @NonNull ImmutableParams immutableParams) {
        if (!this.hasSpan()) {
            return false;
        }
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            IDrawableBlock block = (IDrawableBlock)this.get(i);
            if (block == null || block.getType() != 3 || !block.onTouchEvent(v, event, immutableParams)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void draw(Canvas canvas, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        canvas.save();
        this.traslateCanvas(canvas, immutableParams);
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            ((DefaultDrawableBlock)this.get(i)).draw(canvas, variableParams, immutableParams);
        }
        canvas.restore();
    }

    private void traslateCanvas(Canvas canvas, ImmutableParams params) {
        int textWidth = MeasureTextUtils.getMaxWidth(this.lastFlag);
        int textHeight = this.getAllLineHeight(params);
        int gravity = params.gravity;
        long flag = SimpleGravity.apply(gravity, params.left, params.top, params.right, params.bottom, textWidth, textHeight);
        int tx = SimpleGravity.getLeft(flag) - params.left;
        int ty = SimpleGravity.getTop(flag) - params.top;
        if (tx == 0 && ty == 0) {
            return;
        }
        canvas.translate((float)tx, (float)ty);
    }

    private int getAllLineHeight(ImmutableParams params) {
        int[] lineInfo = params.lineInfos;
        int needDrawLine = params.needDrawLine;
        int space = params.lineSpace;
        return LineUtils.getAllLineHeight(lineInfo, needDrawLine) + (needDrawLine - 1) * space;
    }

    @Override
    public synchronized void use() {
        this.useCount = this.useCount < 0 ? --this.useCount : ++this.useCount;
    }

    private DefaultDrawableBlockList(int start, int end) {
        this.mStart = start;
        this.mEnd = end;
    }

    private DefaultDrawableBlockList() {
    }

    @Override
    public long getFlag() {
        return this.lastFlag;
    }

    @Override
    public int getStart() {
        return this.mStart;
    }

    @Override
    public int getEnd() {
        return this.mEnd;
    }

    @Override
    public int getNewLineCount() {
        return this.mNewLineCount;
    }

    @Override
    public int getDrawableCount() {
        return this.mDrawableCount;
    }

    @Override
    public int getSpecialDrawableCount() {
        return this.mSpecialDrawableCount;
    }

    @Override
    public boolean hasSpan() {
        return this.hasSpan;
    }

    @Override
    public int[] getLinesHeight() {
        return this.lineFlags;
    }

    @Override
    public int getFlagSize() {
        return this.lines;
    }

    @Override
    public long measure(TextPaint textPaint, int lineInfo, int drawableSize, int currentLeft, int currentTop, int left, int right) {
        if (drawableSize == this.lastDrawableSize && this.lastCLeft == currentLeft && this.lastLeft == left && this.lastRight == right && this.lastFlag != 0L) {
            return this.lastFlag;
        }
        long flag = MeasureTextUtils.setLines(0L, 1);
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            int state;
            IDrawableBlock block = (IDrawableBlock)this.get(i);
            if (block == null) continue;
            long bf = block.measure(textPaint, lineInfo, drawableSize, currentLeft, currentTop, left, right);
            int n = state = bf == 0L ? 2 : MeasureTextUtils.getState(bf);
            if (state == 0) {
                int cl = MeasureTextUtils.getLines(flag);
                currentLeft = MeasureTextUtils.getCurrentLeft(bf);
                int blines = MeasureTextUtils.getLines(bf);
                boolean drawOnFirstLine = MeasureTextUtils.willDrawOnFirstLine(bf) || blines == 1;
                int lineHeight = MeasureTextUtils.getMaxHeight(bf);
                lineHeight = lineHeight == 0 ? LineUtils.getLineHeight(lineInfo) : lineHeight;
                int lineStart = cl;
                int lh = this.getLastLineHeight();
                if (drawOnFirstLine) {
                    if (lineHeight > lh) {
                        this.saveLineHeight(lineHeight, block.getBaseLine(), --lineStart, lineStart + blines - 1);
                    }
                } else if (blines > 1) {
                    this.saveLineHeight(lineHeight, block.getBaseLine(), lineStart, lineStart + blines - 2);
                }
                if (blines > 1) {
                    currentTop += (blines - 1) * lh;
                }
                flag = MeasureTextUtils.setLines(flag, cl + blines - 1);
                flag = MeasureTextUtils.setMaxWidth(flag, Math.max(MeasureTextUtils.getMaxWidth(flag), MeasureTextUtils.getMaxWidth(bf)));
                flag = MeasureTextUtils.setCurrentLeft(flag, currentLeft);
                flag = MeasureTextUtils.setMaxHeight(flag, Math.max(MeasureTextUtils.getMaxHeight(flag), lineHeight));
                continue;
            }
            MeasureTextUtils.setState(flag, state);
        }
        this.lastFlag = flag;
        this.lastDrawableSize = drawableSize;
        this.lastCLeft = currentLeft;
        this.lastLeft = left;
        this.lastRight = right;
        return flag;
    }

    private int getLastLineHeight() {
        int len;
        int n = len = this.lineFlags != null ? this.lines : 0;
        if (len == 0 || this.lines >= this.lineFlags.length) {
            return 0;
        }
        return LineUtils.getLineHeight(this.lineFlags[len - 1]);
    }

    private void saveLineHeight(int height, int baseLine, int start, int end) {
        this.initLineHeight(end);
        for (int i = start; i <= end; ++i) {
            this.lineFlags[i] = LineUtils.combime(height, baseLine);
        }
        this.lines = end + 1;
    }

    private void initLineHeight(int endIndex) {
        if (this.lines <= endIndex) {
            int needLen;
            for (needLen = this.lines + 10; needLen <= endIndex; needLen += 10) {
            }
            int[] temp = new int[needLen];
            if (this.lines > 0) {
                System.arraycopy(this.lineFlags, 0, temp, 0, this.lines);
            }
            this.lineFlags = temp;
        }
    }

    @Override
    public boolean add(DefaultDrawableBlock block) {
        if (!super.add(block)) {
            return false;
        }
        switch (block.getType()) {
            case 1: {
                ++this.mDrawableCount;
                break;
            }
            case 4: {
                ++this.mNewLineCount;
                break;
            }
            case 2: {
                ++this.mSpecialDrawableCount;
                break;
            }
            case 3: {
                this.hasSpan = true;
                this.mDrawableCount += block.getChildren().getNewLineCount();
                this.mNewLineCount += block.getChildren().getNewLineCount();
                this.mSpecialDrawableCount += block.getChildren().getSpecialDrawableCount();
            }
        }
        return true;
    }

    private long now() {
        return System.nanoTime();
    }

    private long logCast(String pre, long start) {
        long now = this.now();
        Log.d((String)TAG, (String)(pre + (now - start)));
        return now;
    }

    static {
        for (int i = 0; i < 10; ++i) {
            cache.add(new DefaultDrawableBlockList());
        }
    }
}

