/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.lang.ref.WeakReference;
import xfy.fakeview.library.text.StyleHelper;
import xfy.fakeview.library.text.block.IDrawableBlock;
import xfy.fakeview.library.text.block.IDrawableBlockList;
import xfy.fakeview.library.text.compiler.ITextCompiler;
import xfy.fakeview.library.text.drawer.TextDrawer;
import xfy.fakeview.library.text.param.ImmutableParams;
import xfy.fakeview.library.text.param.VariableParams;
import xfy.fakeview.library.text.utils.LineUtils;
import xfy.fakeview.library.text.utils.MeasureTextUtils;

public class FTextDrawable
extends Drawable {
    private static final String TAG = "Fake--TextDrawable";
    private int lineSpace = 10;
    private int maxWidth;
    private int maxHeight;
    private CharSequence mText;
    private int maxLines;
    private TextUtils.TruncateAt ellipsize = TextUtils.TruncateAt.END;
    private WeakReference<LayoutRequestListener> listenerRef;
    private boolean autoMeasure = true;
    protected int textWidth;
    protected int lines;
    protected int needDrawLines;
    protected boolean isNeedEllipsize;
    protected int ellipsizeLength;
    protected int drawableSize;
    protected final VariableParams variableParams;
    protected final ImmutableParams immutableParams;
    protected final TextPaint mTextPaint = new TextPaint(1);
    protected boolean needMeasureText = false;
    protected boolean needMeasureTextLines = true;
    protected IDrawableBlockList<IDrawableBlock> blockList;
    private ITextCompiler compiler;

    public FTextDrawable() {
        this.variableParams = new VariableParams();
        this.immutableParams = new ImmutableParams();
    }

    public FTextDrawable(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.variableParams = new VariableParams();
        this.immutableParams = new ImmutableParams();
        StyleHelper helper = new StyleHelper(context, attrs, defStyleAttr, defStyleRes);
        if (helper.textCompiler != null) {
            this.setTextCompiler(helper.textCompiler);
        }
        this.setAutoMeasure(helper.measureWhenSetText);
        if (helper.maxLines > 0) {
            this.setMaxLines(helper.maxLines);
        }
        if (helper.textSize > 0) {
            this.setTextSize(helper.textSize);
        }
        if (helper.lineSpace > 0) {
            this.setLineSpace(helper.lineSpace);
        }
        if (helper.textColor != 0) {
            this.setTextColor(helper.textColor);
        }
        if (helper.drawableScale != 1.0f) {
            this.setDrawableScale(helper.drawableScale);
        }
        if (helper.drawableSize > 0) {
            this.setDrawableSize(helper.drawableSize);
        }
        if (!TextUtils.isEmpty((CharSequence)helper.text)) {
            this.setText(helper.text);
        }
        this.setGravity(helper.gravity);
    }

    public void setAutoMeasure(boolean auto) {
        this.autoMeasure = auto;
    }

    public boolean isAutoMeasure() {
        return this.autoMeasure;
    }

    public void setTextCompiler(ITextCompiler compiler) {
        this.compiler = compiler;
    }

    public ITextCompiler getCompiler() {
        return this.compiler;
    }

    public void setGravity(int gravity) {
        if (this.immutableParams.gravity != gravity) {
            this.immutableParams.gravity = gravity;
            if (this.mText != null) {
                this.invalidateSelf();
            }
        }
    }

    public void setText(CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            text = null;
        }
        if (this.mText == null && text == null) {
            return;
        }
        if (this.mText != null && this.mText.equals(text)) {
            return;
        }
        this.mText = text;
        if (this.compiler != null) {
            if (this.blockList != null) {
                this.blockList.notUse();
            }
            this.blockList = text == null ? null : this.compiler.compile(text);
        } else {
            throw new NullPointerException("compiler is null, please set compiler before set text!");
        }
        this.needMeasureTextLines = true;
        if (this.autoMeasure) {
            this.measure();
        }
        this.requestLayout();
        this.invalidateSelf();
    }

    public void setLayoutRequestListener(LayoutRequestListener listener) {
        this.listenerRef = new WeakReference<LayoutRequestListener>(listener);
    }

    public void setUnderLineText(boolean underline) {
        this.mTextPaint.setUnderlineText(underline);
        this.needMeasureTextLines = true;
        if (this.autoMeasure) {
            this.measure();
        }
        this.requestLayout();
        this.invalidateSelf();
    }

    public void setBoldText(boolean bold) {
        if (bold) {
            TextDrawer.apply((Paint)this.mTextPaint, 1);
        } else {
            TextDrawer.clear((Paint)this.mTextPaint, 1);
        }
        this.needMeasureTextLines = true;
        if (this.autoMeasure) {
            this.measure();
        }
        this.requestLayout();
        this.invalidateSelf();
    }

    public void setItalicText(boolean italic) {
        if (italic) {
            TextDrawer.apply((Paint)this.mTextPaint, 2);
        } else {
            TextDrawer.clear((Paint)this.mTextPaint, 2);
        }
        this.needMeasureTextLines = true;
        if (this.autoMeasure) {
            this.measure();
        }
        this.requestLayout();
        this.invalidateSelf();
    }

    public void setDrawableSize(int drawableSize) {
        if (this.drawableSize != drawableSize) {
            this.drawableSize = drawableSize;
            this.needMeasureTextLines = true;
            if (this.mText != null) {
                if (this.autoMeasure) {
                    this.measure();
                }
                this.requestLayout();
                this.invalidateSelf();
            }
        }
    }

    public void setDrawableScale(float scale) {
        int size = (int)(scale * this.mTextPaint.getTextSize());
        this.setDrawableSize(size);
    }

    public void setTextColor(int textColor) {
        if (this.mTextPaint.getColor() != textColor) {
            this.mTextPaint.setColor(textColor);
            if (this.mText != null) {
                this.invalidateSelf();
            }
        }
    }

    public void setLineSpace(int lineSpace) {
        if (this.lineSpace != lineSpace) {
            this.lineSpace = lineSpace;
            if (this.mText != null) {
                if (this.autoMeasure) {
                    this.measure();
                }
                this.requestLayout();
                this.invalidateSelf();
            }
        }
    }

    public void setMaxWidth(int maxWidth) {
        int n = maxWidth = maxWidth < 0 ? 0 : maxWidth;
        if (this.maxWidth != maxWidth) {
            this.maxWidth = maxWidth;
            if (this.mText != null) {
                if (this.autoMeasure) {
                    this.measure();
                }
                this.requestLayout();
                this.invalidateSelf();
            }
        }
    }

    public void setMaxHeight(int maxHeight) {
        int n = maxHeight = maxHeight < 0 ? 0 : maxHeight;
        if (this.maxHeight != maxHeight) {
            this.maxHeight = maxHeight;
            if (this.mText != null) {
                if (this.autoMeasure) {
                    this.measure();
                }
                this.requestLayout();
                this.invalidateSelf();
            }
        }
    }

    public void setTextSize(float textSize) {
        if (this.mTextPaint.getTextSize() != textSize) {
            this.mTextPaint.setTextSize(textSize);
            this.needMeasureTextLines = true;
            if (this.drawableSize == 0) {
                this.drawableSize = (int)textSize;
            }
            this.ellipsizeLength = TextDrawer.getEllipsizeLength(this.mTextPaint);
            if (this.mText != null) {
                if (this.autoMeasure) {
                    this.measure();
                }
                this.requestLayout();
                this.invalidateSelf();
            }
        }
    }

    public void setMaxLines(int maxLines) {
        int n = maxLines = maxLines < 1 ? 1 : maxLines;
        if (this.maxLines != maxLines) {
            this.maxLines = maxLines;
            if (this.mText != null) {
                if (this.autoMeasure) {
                    this.measure();
                }
                this.requestLayout();
                this.invalidateSelf();
            }
        }
    }

    public boolean onTouchEvent(@NonNull View v, MotionEvent event) {
        if (this.blockList != null) {
            return this.blockList.onTouchEvent(v, event, this.immutableParams);
        }
        return false;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.needMeasureText) {
            this.requestLayout();
            this.invalidateSelf();
            return;
        }
        if (this.mText == null || this.lines == 0) {
            return;
        }
        Rect bounds = this.getBounds();
        int left = bounds.left;
        int right = bounds.right;
        if (left == right || bounds.height() == 0) {
            return;
        }
        this.initParamsBeforeDraw();
        if (this.needDrawLines <= 0) {
            return;
        }
        this.blockList.draw(canvas, this.variableParams, this.immutableParams);
    }

    public void setAlpha(int alpha) {
        this.mTextPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mTextPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return 0;
    }

    public int getIntrinsicWidth() {
        return this.textWidth;
    }

    public int getIntrinsicHeight() {
        int[] flags = this.blockList != null ? this.blockList.getLinesHeight() : null;
        return flags != null ? LineUtils.getAllLineHeight(flags, this.needDrawLines) : 0;
    }

    private void initParamsBeforeDraw() {
        int[] flags;
        Rect bounds = this.getBounds();
        int left = bounds.left;
        int right = bounds.right;
        int top = bounds.top;
        int[] nArray = flags = this.blockList != null ? this.blockList.getLinesHeight() : null;
        if (flags != null) {
            this.variableParams.currentBaseline = LineUtils.getBaseLine(flags, 0) + bounds.top;
        }
        this.variableParams.currentLeft = left;
        this.variableParams.currentTop = top;
        this.variableParams.currentDrawLine = 0;
        this.variableParams.isDrawEndEllipsize = false;
        this.immutableParams.top = top;
        this.immutableParams.bottom = bounds.bottom;
        this.immutableParams.left = left;
        this.immutableParams.right = right;
        this.immutableParams.drawableHeight = this.drawableSize;
        this.immutableParams.lineSpace = this.lineSpace;
        this.immutableParams.lines = this.lines;
        this.immutableParams.needDrawLine = this.needDrawLines;
        this.immutableParams.truncateAt = this.isNeedEllipsize ? this.ellipsize : null;
        this.immutableParams.ellipsizeLength = this.ellipsizeLength;
        this.immutableParams.paint = this.mTextPaint;
        this.immutableParams.lineInfos = flags;
    }

    public void measure() {
        if (this.maxWidth == 0 || this.maxHeight == 0) {
            this.needMeasureText = true;
            return;
        }
        this.calTextLinesAndContentWidth();
        this.calNeedDrawLines();
    }

    private void calTextLinesAndContentWidth() {
        long flag;
        if (TextUtils.isEmpty((CharSequence)this.mText) || this.blockList == null) {
            this.textWidth = 0;
            return;
        }
        if (!this.needMeasureTextLines) {
            return;
        }
        this.needMeasureTextLines = false;
        Rect bounds = this.getBounds();
        int left = bounds.left;
        int maxWidth = this.maxWidth;
        if (maxWidth == 0) {
            maxWidth = bounds.width();
        }
        if (MeasureTextUtils.getState(flag = TextDrawer.measureText(this.mTextPaint, this.blockList, this.drawableSize, left, left, left + maxWidth, true)) == 0) {
            this.textWidth = MeasureTextUtils.getMaxWidth(flag);
            this.lines = MeasureTextUtils.getLines(flag);
            this.needMeasureText = false;
        } else {
            this.needMeasureText = true;
        }
    }

    private void calNeedDrawLines() {
        this.needDrawLines = this.lines;
        if (this.maxLines < this.lines && this.maxLines > 0) {
            this.needDrawLines = this.maxLines;
        }
        this.isNeedEllipsize = this.lines > this.needDrawLines;
    }

    private void requestLayout() {
        LayoutRequestListener listener;
        LayoutRequestListener layoutRequestListener = listener = this.listenerRef != null ? (LayoutRequestListener)this.listenerRef.get() : null;
        if (listener != null) {
            listener.needRequest(this);
        }
    }

    private long now() {
        return System.nanoTime();
    }

    private long logCast(String pre, long start) {
        long now = this.now();
        Log.d((String)TAG, (String)(pre + (now - start)));
        return now;
    }

    public static interface LayoutRequestListener {
        public void needRequest(FTextDrawable var1);
    }
}

