/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.shallowlayer;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import xfy.fakeview.library.shallowlayer.OnShallowViewListener;
import xfy.fakeview.library.translator.EventExtractor;

public class ShallowLayerManager {
    private static final List<Class<? extends ViewGroup>> notShallowClass = new ArrayList<Class<? extends ViewGroup>>();
    private ViewGroup rootView;
    private OnShallowViewListener onShallowViewListener;

    public static void registerNotShallowClass(Class<? extends ViewGroup> clz) {
        if (clz != null) {
            notShallowClass.add(clz);
        }
    }

    public ShallowLayerManager(ViewGroup root) {
        this(root, null);
    }

    public ShallowLayerManager(ViewGroup root, OnShallowViewListener listener) {
        this.rootView = root;
        this.setOnShallowViewListener(listener);
    }

    public void setOnShallowViewListener(OnShallowViewListener listener) {
        this.onShallowViewListener = listener;
    }

    public void start() {
        if (this.rootView == null) {
            return;
        }
        this.shallow(this.rootView);
    }

    private void shallow(ViewGroup parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            ViewGroup vg = null;
            if (!(child instanceof ViewGroup)) continue;
            vg = (ViewGroup)child;
            this.shallow(vg);
            if (childCount != 1 || !child.getClass().equals(parent.getClass()) || this.isNotShallowClass(vg) || !this.isSameSize((View)parent, (View)vg) || this.containEvent((View)vg) || this.containBackground((View)vg) || this.checkListener((View)vg)) continue;
            this.removeView(parent, vg);
        }
    }

    private void removeView(ViewGroup parent, ViewGroup needRemoved) {
        parent.removeView((View)needRemoved);
        int l = needRemoved.getChildCount();
        for (int i = 0; i < l; ++i) {
            View c = needRemoved.getChildAt(0);
            needRemoved.removeView(c);
            parent.addView(c);
        }
    }

    private boolean isNotShallowClass(@NonNull ViewGroup view) {
        for (Class<? extends ViewGroup> c : notShallowClass) {
            if (!c.isInstance(view)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameSize(@NonNull View parent, @NonNull View child) {
        int pw = parent.getMeasuredWidth();
        int ph = parent.getMeasuredHeight();
        int cw = child.getMeasuredWidth();
        int ch = child.getMeasuredHeight();
        if (pw > 0 && ph > 0 && cw > 0 && ch > 0 && pw == cw && ph == ch) {
            return true;
        }
        ViewGroup.LayoutParams params = parent.getLayoutParams();
        if (params != null) {
            pw = params.width;
            ph = params.height;
        } else {
            pw = -3;
            ph = -3;
        }
        params = child.getLayoutParams();
        if (params != null) {
            cw = params.width;
            ch = params.height;
        } else {
            cw = -4;
            ch = -4;
        }
        return pw == cw && ph == ch;
    }

    private boolean containEvent(@NonNull View view) {
        if (EventExtractor.getViewOnClickListener(view) != null) {
            return true;
        }
        return EventExtractor.getViewOnLongClickListener(view) != null;
    }

    private boolean containBackground(@NonNull View view) {
        return view.getBackground() != null;
    }

    private boolean checkListener(@NonNull View view) {
        if (this.onShallowViewListener != null) {
            return this.onShallowViewListener.onShallowView(view);
        }
        return false;
    }
}

