/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.block;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import xfy.fakeview.library.text.block.DefaultDrawableBlockList;
import xfy.fakeview.library.text.block.IDrawableBlock;
import xfy.fakeview.library.text.drawer.TextDrawableDrawer;
import xfy.fakeview.library.text.drawer.TextDrawer;
import xfy.fakeview.library.text.param.ImmutableParams;
import xfy.fakeview.library.text.param.SpecialStyleParams;
import xfy.fakeview.library.text.param.VariableParams;
import xfy.fakeview.library.text.utils.BaseSpan;
import xfy.fakeview.library.text.utils.FClickableSpan;
import xfy.fakeview.library.text.utils.LineUtils;
import xfy.fakeview.library.text.utils.MeasureTextUtils;

public class DefaultDrawableBlock
implements IDrawableBlock<DefaultDrawableBlockList> {
    private int type;
    private CharSequence mText;
    private SpecialStyleParams textStyleParams;
    private int drawableRes;
    private Drawable specialDrawable;
    private DefaultDrawableBlockList children;
    private BaseSpan span;
    private long flag;
    private int baseLine;
    private int left;
    private int top;
    private static final int DEFAULT_SIZE = 20;
    private static final List<DefaultDrawableBlock> cache = new ArrayList<DefaultDrawableBlock>(20);
    private boolean handleEvent = false;

    private DefaultDrawableBlock() {
    }

    private static synchronized DefaultDrawableBlock obtain() {
        if (cache.isEmpty()) {
            return new DefaultDrawableBlock();
        }
        return cache.remove(0);
    }

    private static synchronized void putToCache(DefaultDrawableBlock block) {
        cache.add(block);
    }

    public void recycle() {
        this.span = null;
        this.flag = 0L;
        this.type = 0;
        this.baseLine = 0;
        this.mText = null;
        if (this.textStyleParams != null) {
            this.textStyleParams.recycle();
        }
        this.textStyleParams = null;
        this.drawableRes = 0;
        this.specialDrawable = null;
        if (this.children != null) {
            this.children.notUse();
        }
        this.children = null;
        DefaultDrawableBlock.putToCache(this);
    }

    @Override
    public long getFlag() {
        return this.flag;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getBaseLine() {
        return this.baseLine;
    }

    @Override
    public CharSequence getText() {
        return this.mText;
    }

    @Override
    public int getDrawableRes() {
        return this.drawableRes;
    }

    @Override
    public Drawable getSpecialDrawable() {
        return this.specialDrawable;
    }

    @Override
    public DefaultDrawableBlockList getChildren() {
        return this.children;
    }

    @Override
    public long measure(TextPaint textPaint, int lineInfo, int drawableSize, int currentLeft, int currentTop, int left, int right) {
        int fontHeight = LineUtils.getLineHeight(lineInfo);
        this.baseLine = LineUtils.getBaseLine(lineInfo);
        this.left = currentLeft;
        this.top = currentTop;
        switch (this.type) {
            case 0: {
                float oldTextSize = textPaint.getTextSize();
                if (this.textStyleParams != null && this.textStyleParams.hasTextSize) {
                    textPaint.setTextSize(this.textStyleParams.textSize);
                    if (this.textStyleParams.textSize > oldTextSize) {
                        int flag = TextDrawer.getLineInfo(textPaint, drawableSize, true);
                        fontHeight = LineUtils.getLineHeight(flag);
                        this.baseLine = LineUtils.getBaseLine(flag);
                    }
                }
                this.flag = TextDrawer.measureText(textPaint, this.mText, currentLeft, left, right, 0L);
                this.flag = MeasureTextUtils.setMaxHeight(this.flag, fontHeight);
                textPaint.setTextSize(oldTextSize);
                break;
            }
            case 4: {
                this.flag = MeasureTextUtils.setLines(0L, 2);
                break;
            }
            case 1: {
                if (this.specialDrawable == null && this.drawableRes > 0) {
                    this.specialDrawable = TextDrawableDrawer.getDrawableDrawer().getSpecialDrawable(this.drawableRes, drawableSize);
                }
                if (this.specialDrawable == null) {
                    this.flag = TextDrawer.measureText(textPaint, this.mText, currentLeft, left, right, 0L);
                }
                this.flag = TextDrawer.measureFixWidth(this.specialDrawable.getBounds().width(), currentLeft, left, right);
                break;
            }
            case 2: {
                if (this.specialDrawable == null) {
                    this.flag = TextDrawer.measureText(textPaint, this.mText, currentLeft, left, right, 0L);
                }
                this.flag = TextDrawer.measureFixWidth(this.specialDrawable.getBounds().width(), currentLeft, left, right);
                break;
            }
            case 3: {
                DefaultDrawableBlockList children = this.getChildren();
                if (children == null) {
                    this.flag = 0L;
                }
                this.flag = children.measure(textPaint, lineInfo, drawableSize, currentLeft, currentTop, left, right);
            }
        }
        return this.flag;
    }

    @Override
    public boolean draw(Canvas canvas, @NonNull VariableParams variableParams, @NonNull ImmutableParams immutableParams) {
        if (variableParams.isDrawEndEllipsize) {
            return true;
        }
        variableParams.needDrawLines = MeasureTextUtils.getLines(this.flag);
        switch (this.type) {
            case 0: {
                TextDrawer.drawText(canvas, this.mText, variableParams, immutableParams, this.textStyleParams);
                break;
            }
            case 4: {
                TextDrawer.drawNextLine(canvas, variableParams, immutableParams);
                break;
            }
            case 1: {
                if (this.drawableRes <= 0) {
                    TextDrawer.drawText(canvas, this.mText, variableParams, immutableParams, this.textStyleParams);
                    break;
                }
                if (this.specialDrawable != null) {
                    TextDrawableDrawer.getDrawableDrawer().drawSpecialDrawable(canvas, this.specialDrawable, variableParams, immutableParams);
                    break;
                }
                this.specialDrawable = TextDrawableDrawer.getDrawableDrawer().drawResource(canvas, this.drawableRes, variableParams, immutableParams);
                break;
            }
            case 2: {
                if (this.specialDrawable == null) {
                    TextDrawer.drawText(canvas, this.mText, variableParams, immutableParams, this.textStyleParams);
                    break;
                }
                TextDrawableDrawer.getDrawableDrawer().drawSpecialDrawable(canvas, this.specialDrawable, variableParams, immutableParams);
                break;
            }
            case 3: {
                DefaultDrawableBlockList children = this.getChildren();
                if (children == null) {
                    return false;
                }
                boolean result = true;
                int l = children.size();
                for (int i = 0; i < l; ++i) {
                    if (((DefaultDrawableBlock)children.get(i)).draw(canvas, variableParams, immutableParams)) continue;
                    result = false;
                }
                return result;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onTouchEvent(@NonNull View v, MotionEvent event, @NonNull ImmutableParams immutableParams) {
        if (this.type != 3) {
            return false;
        }
        if (!(this.span instanceof FClickableSpan)) {
            return false;
        }
        int action = event.getAction();
        if (action == 1 || action == 0) {
            this.handleEvent = false;
            if (this.isPointInThisBlock(event.getX(), event.getY(), immutableParams)) {
                if (action == 1) {
                    ((FClickableSpan)this.span).onClick(v);
                    return true;
                }
                this.handleEvent = true;
            }
        }
        return this.handleEvent;
    }

    private boolean isPointInThisBlock(float x, float y, @NonNull ImmutableParams immutableParams) {
        int h = MeasureTextUtils.getMaxHeight(this.flag);
        if (h <= 0) {
            return false;
        }
        int cl = MeasureTextUtils.getCurrentLeft(this.flag);
        if (cl == 0) {
            return false;
        }
        int lines = MeasureTextUtils.getLines(this.flag);
        if (lines == 0) {
            return false;
        }
        y -= (float)immutableParams.top;
        if ((x -= (float)immutableParams.left) < 0.0f || y < 0.0f) {
            return false;
        }
        int b = h + this.top;
        if (lines == 1) {
            return x >= (float)this.left && x <= (float)cl && y >= (float)this.top && y <= (float)b;
        }
        int vr = immutableParams.right;
        if (x > (float)vr || y > (float)b) {
            return false;
        }
        float lh = (float)h / (float)lines;
        if (this.left < cl) {
            if (this.isPointInRect(x, y, this.left, this.top, vr, b)) {
                return true;
            }
            if (this.isPointInRect(x, y, 0, (int)((float)this.top + lh), this.left, b)) {
                return true;
            }
            return this.isPointInRect(x, y, cl, this.top, vr, (int)((float)b - lh));
        }
        if (this.isPointInRect(x, y, 0, (int)((float)this.top + lh), cl, b)) {
            return true;
        }
        if (this.isPointInRect(x, y, cl, this.top, this.left, (int)((float)b - lh))) {
            return true;
        }
        return this.isPointInRect(x, y, this.left, this.top, vr, (int)((float)b - lh));
    }

    private boolean isPointInRect(float x, float y, int l, int t, int r, int b) {
        return x >= (float)l && x <= (float)r && y >= (float)t && y <= (float)b;
    }

    public static DefaultDrawableBlock createTextBlock(CharSequence text, @Nullable SpecialStyleParams params) {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 0;
        block.textStyleParams = params;
        return block;
    }

    public static DefaultDrawableBlock createDrawableBlock(CharSequence text, int res) {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 1;
        block.drawableRes = res;
        return block;
    }

    public static DefaultDrawableBlock createSpecialDrawableBlock(CharSequence text, Drawable d) {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 2;
        block.specialDrawable = d;
        return block;
    }

    public static DefaultDrawableBlock createSpanBlock(CharSequence text, BaseSpan span, DefaultDrawableBlockList children) {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = text;
        block.type = 3;
        block.children = children;
        block.span = span;
        block.textStyleParams = SpecialStyleParams.obtain(span);
        int l = children.size();
        for (int i = 0; i < l; ++i) {
            DefaultDrawableBlock b = (DefaultDrawableBlock)children.get(i);
            if (b == null || b.textStyleParams != null) continue;
            b.textStyleParams = block.textStyleParams;
        }
        return block;
    }

    public static DefaultDrawableBlock createNextLineBlock() {
        DefaultDrawableBlock block = DefaultDrawableBlock.obtain();
        block.mText = "\n";
        block.type = 4;
        return block;
    }

    static {
        for (int i = 0; i < 20; ++i) {
            cache.add(new DefaultDrawableBlock());
        }
    }
}

