/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.layermerge;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.Arrays;
import xfy.fakeview.library.DebugInfo;
import xfy.fakeview.library.layermerge.ChildViewGroupBackgroundExtractor;
import xfy.fakeview.library.layermerge.DefaultViewReadyChecker;
import xfy.fakeview.library.layermerge.OnExtractViewGroupListener;
import xfy.fakeview.library.layermerge.ViewReadyChecker;
import xfy.fakeview.library.translator.EventExtractor;

public class LayersMergeManager {
    public static final int EXTRACT_NONE = 0;
    public static final int EXTRACT_BACKGROUND = 1;
    public static final int EXTRACT_CLICK_EVENT = 16;
    public static final int EXTRACT_LONG_CLICK_EVENT = 256;
    public static final int EXTRACT_ALL_EVENT = 272;
    public static final int EXTRACT_ALL = 273;
    private static ChildViewGroupBackgroundExtractor childViewGroupBackgroundExtractor;
    private static ViewReadyChecker mViewReadyChecker;
    private FrameLayout rootLayout;
    private Loc rootLoc;
    private int rootWidth;
    private int rootHeight;
    private ArrayList<View> childrens;
    private ArrayList<Loc> childrenLoc;
    private int extractFlag = 0;
    private OnExtractViewGroupListener onExtractViewGroupListener;
    private int zeroLocCount = 0;
    private int maxZeroLocCount = 3;

    public static void setChildViewGroupBackgroundExtractor(ChildViewGroupBackgroundExtractor childViewGroupBackgroundExtractor) {
        LayersMergeManager.childViewGroupBackgroundExtractor = childViewGroupBackgroundExtractor;
    }

    public static void setViewReadyChecker(ViewReadyChecker viewReadyChecker) {
        if (viewReadyChecker == null) {
            throw new NullPointerException("viewReadyChecker is null!");
        }
        mViewReadyChecker = viewReadyChecker;
    }

    public static boolean needMerge(ViewGroup parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(parent.getChildAt(i) instanceof ViewGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadyToMerge(ViewGroup src) {
        return LayersMergeManager.isReadyToMerge(src, 0, 3);
    }

    public static boolean isReadyToMerge(ViewGroup src, int zeroViewCount, int notReadyCount) {
        int childCount = src.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = src.getChildAt(i);
            if (!mViewReadyChecker.check(child)) {
                ++zeroViewCount;
            }
            if (zeroViewCount >= notReadyCount && notReadyCount > 0) {
                return false;
            }
            if (DebugInfo.DEBUG) {
                Log.d((String)LayersMergeManager.class.getSimpleName(), (String)String.format("isReadyToMerge(%s, %d, %d) child: %s", src.getClass().getSimpleName(), zeroViewCount, notReadyCount, child.getClass().getSimpleName()));
            }
            if (!(child instanceof ViewGroup) || LayersMergeManager.isReadyToMerge((ViewGroup)child, zeroViewCount, notReadyCount)) continue;
            return false;
        }
        return true;
    }

    public LayersMergeManager(FrameLayout parent) {
        this(parent, 0);
    }

    public LayersMergeManager(FrameLayout parent, int flag) {
        this(parent, flag, null);
    }

    public LayersMergeManager(FrameLayout parent, int flag, OnExtractViewGroupListener listener) {
        this(parent, flag, 3, listener);
    }

    public LayersMergeManager(FrameLayout parent, int flag, int maxZeroLocCount, OnExtractViewGroupListener listener) {
        this.extractFlag = flag;
        this.rootLayout = parent;
        this.rootLoc = new Loc(LayersMergeManager.getViewLocation((View)parent));
        this.rootWidth = parent.getWidth();
        this.rootHeight = parent.getHeight();
        this.childrens = new ArrayList();
        this.childrenLoc = new ArrayList();
        this.maxZeroLocCount = maxZeroLocCount;
        this.onExtractViewGroupListener = listener;
    }

    public boolean mergeChildrenLayers() {
        boolean result = this.extractViewFromParent((ViewGroup)this.rootLayout);
        this.addChildrenByLoc(result);
        this.rootLayout = null;
        this.rootLoc = null;
        return result;
    }

    private void addChildrenByLoc(boolean extractStatus) {
        int childCount = this.childrens.size();
        int pl = this.rootLayout.getPaddingLeft();
        int pt = this.rootLayout.getPaddingTop();
        for (int i = 0; i < childCount; ++i) {
            Object tag;
            View child = this.childrens.get(i);
            if (child.getParent() != null || !extractStatus && (tag = child.getTag()) != null && tag instanceof Integer && (Integer)tag > 0) continue;
            Loc childLoc = this.childrenLoc.get(i);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(child.getLayoutParams());
            params.setMargins(childLoc.left - this.rootLoc.left - pl, childLoc.top - this.rootLoc.top - pt, 0, 0);
            this.rootLayout.addView(child, (ViewGroup.LayoutParams)params);
        }
        ViewGroup.LayoutParams params = this.rootLayout.getLayoutParams();
        params.width = this.rootWidth;
        params.height = this.rootHeight;
        this.rootLayout.setLayoutParams(params);
        this.childrens.clear();
        this.childrenLoc.clear();
    }

    private boolean extractViewFromParent(ViewGroup parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int[] loc;
            View c = parent.getChildAt(i);
            if (c instanceof ViewGroup) {
                View backgroundHolder;
                OnExtractViewGroupListener.Result result;
                if (this.onExtractViewGroupListener != null && (result = this.onExtractViewGroupListener.onExtract((ViewGroup)c)) != null) {
                    if (!result.valid()) {
                        throw new IllegalArgumentException("invalid result: " + result);
                    }
                    View[] views = result.views;
                    Loc[] locs = result.locs;
                    int vl = views.length;
                    for (int j = 0; j < vl; ++j) {
                        this.childrens.add(views[j]);
                        this.childrenLoc.add(locs[j]);
                    }
                    if (result.handle) continue;
                }
                if (!mViewReadyChecker.check(c)) {
                    ++this.zeroLocCount;
                }
                if (DebugInfo.DEBUG) {
                    Log.d((String)LayersMergeManager.class.getSimpleName(), (String)String.format("zero loc count: %d, max: %d", this.zeroLocCount, this.maxZeroLocCount));
                }
                if (this.zeroLocCount >= this.maxZeroLocCount && this.maxZeroLocCount > 0) {
                    return false;
                }
                loc = LayersMergeManager.getViewLocation(c);
                if (DebugInfo.DEBUG) {
                    this.logViewAndLoc(c, loc);
                }
                if ((backgroundHolder = this.createViewByExtractingFlag((ViewGroup)c)) != null) {
                    this.childrens.add(backgroundHolder);
                    this.childrenLoc.add(new Loc(loc));
                }
                if (this.extractViewFromParent((ViewGroup)c)) continue;
                return false;
            }
            if (!mViewReadyChecker.check(c)) {
                ++this.zeroLocCount;
            }
            if (DebugInfo.DEBUG) {
                Log.d((String)LayersMergeManager.class.getSimpleName(), (String)String.format("zero loc count: %d, max: %d", this.zeroLocCount, this.maxZeroLocCount));
            }
            if (this.zeroLocCount >= this.maxZeroLocCount && this.maxZeroLocCount > 0) {
                return false;
            }
            loc = LayersMergeManager.getViewLocation(c);
            if (DebugInfo.DEBUG) {
                this.logViewAndLoc(c, loc);
            }
            this.childrens.add(c);
            this.childrenLoc.add(new Loc(loc));
        }
        parent.removeAllViews();
        return true;
    }

    private void logViewAndLoc(View v, int[] loc) {
        Log.d((String)LayersMergeManager.class.getSimpleName(), (String)String.format("view loc: %s, view: %s", Arrays.toString(loc), v.toString()));
    }

    private View createViewByExtractingFlag(ViewGroup src) {
        View.OnLongClickListener longClickListener;
        View.OnClickListener clickListener;
        int flag = this.extractFlag;
        if (flag == 0) {
            return null;
        }
        View result = null;
        int tag = 0;
        if ((flag & 1) == 1) {
            Drawable background = null;
            background = childViewGroupBackgroundExtractor != null ? childViewGroupBackgroundExtractor.extractFrom(src) : src.getBackground();
            if (background != null) {
                tag |= 1;
                result = this.createHolderViewForViewGroup(src);
                if (Build.VERSION.SDK_INT >= 16) {
                    result.setBackground(background);
                } else {
                    result.setBackgroundDrawable(background);
                }
            }
        }
        if ((flag & 0x10) == 16 && (clickListener = EventExtractor.getViewOnClickListener((View)src)) != null) {
            tag |= 0x10;
            result = result == null ? this.createHolderViewForViewGroup(src) : result;
            result.setOnClickListener(clickListener);
        }
        if ((flag & 0x100) == 256 && (longClickListener = EventExtractor.getViewOnLongClickListener((View)src)) != null) {
            tag |= 0x100;
            result = result == null ? this.createHolderViewForViewGroup(src) : result;
            result.setOnLongClickListener(longClickListener);
        }
        if (result != null) {
            result.setTag((Object)tag);
        }
        return result;
    }

    private View createHolderViewForViewGroup(ViewGroup src) {
        View holder = new View(src.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(src.getWidth(), src.getHeight());
        holder.setLayoutParams(params);
        holder.setId(src.getId());
        return holder;
    }

    private static int[] getViewLocation(View view) {
        int[] loc = new int[2];
        view.getLocationInWindow(loc);
        return loc;
    }

    static {
        mViewReadyChecker = new DefaultViewReadyChecker();
    }

    public static class Loc {
        int left;
        int top;

        public Loc(int[] loc) {
            this.left = loc[0];
            this.top = loc[1];
        }
    }
}

