/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.translator;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.lang.reflect.Constructor;
import xfy.fakeview.library.DebugInfo;
import xfy.fakeview.library.fview.FView;
import xfy.fakeview.library.fview.FViewParent;
import xfy.fakeview.library.fview.FViewRootImpl;
import xfy.fakeview.library.fview.IFView;
import xfy.fakeview.library.fview.IFViewGroup;
import xfy.fakeview.library.fview.IFViewRoot;
import xfy.fakeview.library.translator.EventExtractor;
import xfy.fakeview.library.translator.FLayoutParamsTranslator;
import xfy.fakeview.library.translator.FViewTranslator;
import xfy.fakeview.library.translator.data.DataTranslatorManager;
import xfy.fakeview.library.translator.event.OnClickListener;
import xfy.fakeview.library.translator.event.OnLongClickListener;

public class TranslatorManager {
    private static final String TAG = "TranslatorManager";
    private Context mContext;
    private FViewRootImpl viewRoot;

    public TranslatorManager(Context context) {
        this.mContext = context;
    }

    public IFViewRoot translateView(ViewGroup target) {
        if (target == null) {
            throw new NullPointerException("targe cannot be null");
        }
        ViewParent parent = target.getParent();
        if (parent == null || !(parent instanceof ViewGroup)) {
            throw new IllegalArgumentException("view must be added to view tree");
        }
        if (!FViewTranslator.canBeTranslated(target.getClass())) {
            if (DebugInfo.DEBUG) {
                throw new IllegalArgumentException("view " + target.getClass().getName() + " cannot be translated. please register by invoke FViewTranslator.registerTranslator()");
            }
            return null;
        }
        this.viewRoot = new FViewRootImpl(this.mContext);
        this.viewRoot.setLayoutParams(target.getLayoutParams());
        this.translateViewTree((View)target, this.viewRoot);
        ViewGroup p = (ViewGroup)parent;
        int index = -1;
        int childCount = p.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View v = p.getChildAt(i);
            if (v != target) continue;
            index = i;
            break;
        }
        p.removeView((View)target);
        p.addView((View)this.viewRoot, index);
        return this.viewRoot;
    }

    private void translateViewTree(View target, FViewParent parent) {
        Class<? extends FView> tran = FViewTranslator.getTranslateClass(target.getClass());
        if (tran == null) {
            if (DebugInfo.DEBUG) {
                throw new IllegalArgumentException("view " + target.getClass().getName() + " cannot be translated. please register by invoke FViewTranslator.registerTranslator()");
            }
            return;
        }
        FView fView = this.newFView(tran);
        if (fView == null) {
            if (DebugInfo.DEBUG) {
                throw new IllegalArgumentException("class " + tran.getName() + " does not have the public constructor with 2 params (Context, IFViewRoot).");
            }
            return;
        }
        if (parent instanceof IFViewRoot) {
            ((IFViewRoot)parent).setTargetChild(fView);
            fView.setFLayoutParams(this.newMatchParentParams());
        } else {
            IFViewGroup p = (IFViewGroup)parent;
            fView.setFLayoutParams(this.translateLayoutParams(target.getLayoutParams()));
            p.addView(fView);
        }
        fView.setId(target.getId());
        fView.setPadding(target.getPaddingLeft(), target.getPaddingTop(), target.getPaddingRight(), target.getPaddingBottom());
        fView.setBackground(target.getBackground());
        this.translateEvent(fView, target);
        if (target instanceof ViewGroup) {
            DataTranslatorManager.translateData(fView, target);
            ViewGroup layout = (ViewGroup)target;
            int childCount = layout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.translateViewTree(layout.getChildAt(i), (FViewParent)((Object)fView));
            }
        } else if (!DataTranslatorManager.translateData(fView, target)) {
            if (DebugInfo.DEBUG) {
                throw new IllegalArgumentException("view " + target.getClass().getName() + " cannot be translated to " + tran.getName());
            }
            return;
        }
    }

    private void translateEvent(FView fView, View src) {
        fView.setOnClickListener(FViewOnClickListener.craete(EventExtractor.getViewOnClickListener(src)));
        fView.setOnLongClickListener(FViewOnLongClickListener.create(EventExtractor.getViewOnLongClickListener(src)));
    }

    private <T extends FView> T newFView(@NonNull Class<T> clz) {
        try {
            Constructor<T> constructor = clz.getConstructor(Context.class, IFViewRoot.class);
            FView root = (FView)constructor.newInstance(this.mContext, this.viewRoot);
            return (T)root;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private IFViewGroup.FLayoutParams newMatchParentParams() {
        return new IFViewGroup.FLayoutParams(-1, -1);
    }

    private IFViewGroup.FLayoutParams translateLayoutParams(ViewGroup.LayoutParams params) {
        if (params == null) {
            return null;
        }
        Class<? extends IFViewGroup.FLayoutParams> tran = FLayoutParamsTranslator.getTranslateClass(params.getClass());
        IFViewGroup.FLayoutParams result = null;
        if (tran != null) {
            result = this.newLayoutParams(tran, params);
        }
        if (result == null) {
            if (params instanceof ViewGroup.MarginLayoutParams) {
                return new IFViewGroup.FLayoutParams((ViewGroup.MarginLayoutParams)params);
            }
            return new IFViewGroup.FLayoutParams(params);
        }
        return result;
    }

    private <T extends IFViewGroup.FLayoutParams> T newLayoutParams(@NonNull Class<T> tClass, ViewGroup.LayoutParams source) {
        try {
            Constructor<T> constructor = tClass.getConstructor(source.getClass());
            return (T)((IFViewGroup.FLayoutParams)constructor.newInstance(source));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void d(String msg) {
        if (DebugInfo.DEBUG) {
            Log.d((String)TAG, (String)msg);
        }
    }

    private static class FViewOnLongClickListener
    implements IFView.OnLongClickListener {
        View.OnLongClickListener listener;

        private FViewOnLongClickListener() {
        }

        static FViewOnLongClickListener create(View.OnLongClickListener l) {
            if (l == null) {
                if (DebugInfo.DEBUG) {
                    Log.d((String)TranslatorManager.TAG, (String)"OnLongClickListener is null!");
                }
                return null;
            }
            FViewOnLongClickListener listener = new FViewOnLongClickListener();
            listener.listener = l;
            return listener;
        }

        @Override
        public boolean onLongClick(IFView view) {
            OnLongClickListener.Trans trans;
            if (this.listener instanceof OnLongClickListener && (trans = ((OnLongClickListener)this.listener).getTrans()) != null) {
                return trans.onLongClick(view);
            }
            return this.listener.onLongClick(null);
        }
    }

    private static class FViewOnClickListener
    implements IFView.OnClickListener {
        View.OnClickListener listener;

        private FViewOnClickListener() {
        }

        static FViewOnClickListener craete(View.OnClickListener l) {
            if (l == null) {
                if (DebugInfo.DEBUG) {
                    Log.d((String)TranslatorManager.TAG, (String)"onclicklistener is null!");
                }
                return null;
            }
            FViewOnClickListener listener = new FViewOnClickListener();
            listener.listener = l;
            return listener;
        }

        @Override
        public void onClick(IFView view) {
            OnClickListener.Trans trans;
            if (this.listener instanceof OnClickListener && (trans = ((OnClickListener)this.listener).getTrans()) != null) {
                trans.onClick(view);
                return;
            }
            this.listener.onClick(null);
        }
    }
}

