/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.layermerge;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import xfy.fakeview.library.DebugInfo;
import xfy.fakeview.library.layermerge.LayersMergeManager;
import xfy.fakeview.library.layermerge.OnExtractViewGroupListener;
import xfy.fakeview.library.layermerge.OnMergeFailedListener;

public class LayersMergeEngine
implements OnExtractViewGroupListener,
OnMergeFailedListener {
    private static final String TAG = "LayersMergeEngine";
    private static volatile LayersMergeEngine engine;
    private static final int DELAY = 16;
    private final Handler mainHandler;
    private final Scheduler mScheduler = new Scheduler("LayersMergeEngineScheduler");
    private final HashMap<Object, ArrayList<LayoutData>> mergeActions;
    private boolean mPause = false;
    private int mergingLayoutHashcode = -1;
    private boolean merging = false;
    private final ArrayList<Object> removeTags;
    private ArrayList<OnExtractViewGroupListener> onExtractViewGroupListeners;
    private ArrayList<OnMergeFailedListener> onMergeFailedListeners;

    private LayersMergeEngine() {
        this.mScheduler.start();
        this.mergeActions = new HashMap();
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.removeTags = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LayersMergeEngine getEngine() {
        if (engine != null) return engine;
        Class<LayersMergeEngine> clazz = LayersMergeEngine.class;
        synchronized (LayersMergeEngine.class) {
            if (engine != null) return engine;
            engine = new LayersMergeEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return engine;
        }
    }

    public synchronized void pause() {
        this.mPause = true;
    }

    public synchronized void resume() {
        this.mPause = false;
        if (!this.merging) {
            this.mScheduler.post(new NextAction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void release() {
        if (engine != null) {
            LayersMergeEngine layersMergeEngine = engine;
            synchronized (layersMergeEngine) {
                engine.pause();
                engine.removeAllAction();
                LayersMergeEngine.engine.mScheduler.quit();
                LayersMergeEngine.engine.mainHandler.removeCallbacksAndMessages(null);
            }
            engine = null;
        }
    }

    public boolean addMergeAction(Object tag, FrameLayout layout) {
        return this.addMergeAction(tag, layout, 0);
    }

    public boolean addMergeAction(Object tag, FrameLayout layout, int extractInfo) {
        return this.addMergeAction(new LayoutData(tag, layout, extractInfo));
    }

    public synchronized boolean addMergeAction(LayoutData layoutData) {
        FrameLayout layout = layoutData.layout;
        if (!LayersMergeManager.needMerge((ViewGroup)layout)) {
            return false;
        }
        Object tag = layoutData.tag;
        this.removeTags.remove(tag);
        ArrayList<LayoutData> list = this.mergeActions.get(tag);
        if (list == null) {
            list = new ArrayList();
            this.mergeActions.put(tag, list);
        }
        if (list.contains(layout) || layout.hashCode() == this.mergingLayoutHashcode) {
            return true;
        }
        list.add(layoutData);
        if (!this.merging) {
            this.mScheduler.post(new NextAction());
        }
        return true;
    }

    public synchronized void removeMergeActionByTag(Object tag) {
        ArrayList<LayoutData> list = this.mergeActions.remove(tag);
        if (list == null) {
            return;
        }
        list.clear();
        this.removeTags.add(tag);
    }

    public synchronized void removeAllAction() {
        for (Object k : this.mergeActions.keySet()) {
            ArrayList<LayoutData> list = this.mergeActions.get(k);
            if (list == null) continue;
            list.clear();
        }
        this.removeTags.addAll(this.mergeActions.keySet());
        this.mergeActions.clear();
    }

    public void addOnExtractViewGroupListener(OnExtractViewGroupListener listener) {
        if (this.onExtractViewGroupListeners == null) {
            this.onExtractViewGroupListeners = new ArrayList();
        }
        if (!this.onExtractViewGroupListeners.contains(listener)) {
            this.onExtractViewGroupListeners.add(listener);
        }
    }

    public void removeOnExtractViewGroupListener(OnExtractViewGroupListener listener) {
        if (this.onExtractViewGroupListeners != null) {
            this.onExtractViewGroupListeners.remove(listener);
        }
    }

    public void clearOnExtractViewGroupListener() {
        if (this.onExtractViewGroupListeners != null) {
            this.onExtractViewGroupListeners.clear();
        }
    }

    public void addOnMergeFailedListener(OnMergeFailedListener listener) {
        if (this.onMergeFailedListeners == null) {
            this.onMergeFailedListeners = new ArrayList();
        }
        if (!this.onMergeFailedListeners.contains(listener)) {
            this.onMergeFailedListeners.add(listener);
        }
    }

    public void removeOnMergeFailedListener(OnMergeFailedListener listener) {
        if (this.onMergeFailedListeners != null) {
            this.onMergeFailedListeners.remove(listener);
        }
    }

    public void clearOnMergeFailedListener() {
        if (this.onMergeFailedListeners != null) {
            this.onMergeFailedListeners.clear();
        }
    }

    private synchronized void scheduleNext() {
        if (this.mPause || this.merging || this.mergeActions.isEmpty()) {
            if (DebugInfo.DEBUG) {
                Log.d((String)TAG, (String)("merging: " + this.merging + " pause: " + this.mPause + " or empty"));
            }
            return;
        }
        Set<Object> keys = this.mergeActions.keySet();
        if (keys.isEmpty()) {
            if (DebugInfo.DEBUG) {
                Log.d((String)TAG, (String)"keys is empty");
            }
            return;
        }
        if (!this.removeTags.isEmpty()) {
            for (Object tag : this.removeTags) {
                this.mergeActions.remove(tag);
            }
            this.removeTags.clear();
        }
        Object layoutData = null;
        ArrayList<LayoutData> list = null;
        Object key = null;
        for (Object k : keys) {
            list = this.mergeActions.get(k);
            if (list == null || list.isEmpty()) continue;
            for (LayoutData l : list) {
                if (l == null) continue;
                layoutData = l;
                break;
            }
            if (layoutData == null) continue;
            key = k;
            break;
        }
        if (layoutData == null) {
            if (DebugInfo.DEBUG) {
                Log.d((String)TAG, (String)"no layout to merge");
            }
            return;
        }
        if (this.mPause) {
            return;
        }
        if (this.mScheduler.post(new Action((LayoutData)layoutData))) {
            list.remove(layoutData);
            if (list.isEmpty()) {
                this.mergeActions.remove(key);
            }
            this.mergingLayoutHashcode = layoutData.hashCode();
            this.merging = true;
        } else {
            if (DebugInfo.DEBUG) {
                Log.d((String)TAG, (String)"have not created handler yet");
            }
            this.mScheduler.post(new NextAction());
        }
    }

    @Override
    public OnExtractViewGroupListener.Result onExtract(ViewGroup src) {
        if (this.onExtractViewGroupListeners != null) {
            ArrayList<OnExtractViewGroupListener> temp = new ArrayList<OnExtractViewGroupListener>(this.onExtractViewGroupListeners);
            int l = temp.size();
            for (int i = 0; i < l; ++i) {
                OnExtractViewGroupListener listener = temp.get(i);
                OnExtractViewGroupListener.Result result = listener.onExtract(src);
                if (result == null || !result.valid()) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public void onMergeFailed(FrameLayout layout, Object tag, int extractInfo, int failTimes) {
        if (this.onMergeFailedListeners != null) {
            ArrayList<OnMergeFailedListener> temp = new ArrayList<OnMergeFailedListener>(this.onMergeFailedListeners);
            int l = temp.size();
            for (int i = 0; i < l; ++i) {
                temp.get(i).onMergeFailed(layout, tag, extractInfo, failTimes);
            }
        }
    }

    private class Scheduler
    extends HandlerThread {
        private Handler mHandler;
        private Looper myLooper;

        public Scheduler(String name) {
            super(name);
        }

        protected void onLooperPrepared() {
            this.mHandler = new Handler();
            this.myLooper = Looper.myLooper();
        }

        boolean post(Runnable action) {
            if (this.mHandler != null) {
                return this.mHandler.post(action);
            }
            return false;
        }

        boolean postDelay(Runnable action, long delay) {
            if (this.mHandler != null) {
                return this.mHandler.postDelayed(action, delay);
            }
            return false;
        }

        void clearActions() {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
        }

        boolean removeAction(Runnable action) {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks(action);
                return true;
            }
            return false;
        }

        boolean checkLooper() {
            return Looper.myLooper() == this.myLooper;
        }
    }

    public static class LayoutData {
        FrameLayout layout;
        int extractInfo = 0;
        Object tag;
        int maxFailTimes = 0;
        OnExtractViewGroupListener onExtractViewGroupListener;
        OnMergeFailedListener onMergeFailedListener;
        int failTimes = 0;

        public LayoutData(Object tag, FrameLayout layout, int extractInfo) {
            this(tag, layout, extractInfo, 3);
        }

        public LayoutData(Object tag, FrameLayout layout, int extractInfo, int maxFailTimes) {
            this(tag, layout, extractInfo, maxFailTimes, null);
        }

        public LayoutData(Object tag, FrameLayout layout, int extractInfo, int maxFailTimes, OnExtractViewGroupListener listener) {
            this.tag = tag;
            this.layout = layout;
            this.extractInfo = extractInfo;
            this.maxFailTimes = maxFailTimes;
            this.onExtractViewGroupListener = listener;
            this.checkValid();
        }

        public LayoutData withMergeFailedListener(OnMergeFailedListener listener) {
            this.onMergeFailedListener = listener;
            return this;
        }

        public LayoutData withExtractViewGroupListener(OnExtractViewGroupListener listener) {
            this.onExtractViewGroupListener = listener;
            return this;
        }

        public LayoutData checkValid() {
            if (this.layout == null) {
                throw new NullPointerException("layout must not be null!");
            }
            if (this.tag == null) {
                throw new NullPointerException("tag must not be null!");
            }
            if (this.extractInfo < 0) {
                throw new IllegalArgumentException("extract info is invalid!");
            }
            if (this.maxFailTimes < 0) {
                throw new IllegalArgumentException("maxFailTimes is invalid!");
            }
            return this;
        }

        public String toString() {
            return this.layout + " info: " + this.extractInfo + " " + this.tag;
        }
    }

    private class Action
    implements Runnable {
        Object lock;
        LayoutData layout;

        Action(LayoutData layout) {
            this.layout = layout;
            this.lock = new Object();
            if (layout.onExtractViewGroupListener == null) {
                layout.onExtractViewGroupListener = LayersMergeEngine.this;
            }
            if (layout.onMergeFailedListener == null) {
                layout.onMergeFailedListener = LayersMergeEngine.this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.layout == null || this.layout.layout == null) {
                this.postNext();
                return;
            }
            boolean canMerge = this.checkCanMerge();
            if (DebugInfo.DEBUG) {
                Log.d((String)LayersMergeEngine.TAG, (String)("run action: " + this.layout + " canMerge: " + canMerge));
            }
            if (!canMerge) {
                this.onCannotMerge(true);
                return;
            }
            final FrameLayout src = this.layout.layout;
            final Object tag = this.layout.tag;
            final int info = this.layout.extractInfo;
            final OnExtractViewGroupListener listener = this.layout.onExtractViewGroupListener;
            LayersMergeEngine.this.mainHandler.postDelayed(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!LayersMergeEngine.this.removeTags.contains(tag)) {
                        if (!Action.this.checkCanMerge()) {
                            Action.this.onCannotMerge(false);
                        } else {
                            LayersMergeManager manager = new LayersMergeManager(src, info, listener);
                            manager.mergeChildrenLayers();
                        }
                    }
                    Object object = Action.this.lock;
                    synchronized (object) {
                        Action.this.lock.notifyAll();
                    }
                }
            }, 16L);
            Object object = this.lock;
            synchronized (object) {
                block9: {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        if (!DebugInfo.DEBUG) break block9;
                        e.printStackTrace();
                    }
                }
            }
            if (DebugInfo.DEBUG) {
                Log.d((String)LayersMergeEngine.TAG, (String)("action done: " + this.layout));
            }
            this.postNext();
        }

        private void postNext() {
            LayersMergeEngine.this.mergingLayoutHashcode = -1;
            LayersMergeEngine.this.merging = false;
            LayersMergeEngine.this.mScheduler.postDelay(new NextAction(), 16L);
        }

        private void onCannotMerge(boolean postNext) {
            Object tag = this.layout.tag;
            if (!LayersMergeEngine.this.removeTags.contains(tag)) {
                if (this.layout.failTimes < this.layout.maxFailTimes) {
                    LayersMergeEngine.this.addMergeAction(this.layout);
                } else if (this.layout.onMergeFailedListener != null) {
                    this.layout.onMergeFailedListener.onMergeFailed(this.layout.layout, this.layout.tag, this.layout.extractInfo, this.layout.failTimes);
                }
            } else {
                LayersMergeEngine.this.removeTags.remove(tag);
            }
            if (postNext) {
                this.postNext();
            }
        }

        private boolean checkCanMerge() {
            boolean laidout = this.checkViewIsLaidOut();
            if (!laidout) {
                ++this.layout.failTimes;
            }
            return laidout;
        }

        private boolean checkViewIsLaidOut() {
            return LayersMergeManager.isReadyToMerge((ViewGroup)this.layout.layout);
        }
    }

    private class NextAction
    implements Runnable {
        private NextAction() {
        }

        @Override
        public void run() {
            LayersMergeEngine.this.mScheduler.clearActions();
            LayersMergeEngine.this.scheduleNext();
        }
    }
}

