/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview.normal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import xfy.fakeview.library.fview.FView;
import xfy.fakeview.library.fview.FViewGroup;
import xfy.fakeview.library.fview.IFViewGroup;
import xfy.fakeview.library.fview.IFViewRoot;
import xfy.fakeview.library.fview.utils.FMeasureSpec;

public class FLinearLayout
extends FViewGroup {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mOrientation;
    private final boolean mAllowInconsistentMeasurement;

    public FLinearLayout(Context context, IFViewRoot viewRoot) {
        super(context, viewRoot);
        int version = context.getApplicationInfo().targetSdkVersion;
        this.mAllowInconsistentMeasurement = version <= 23;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.requestFViewTreeLayout();
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOrientation == 1) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int mTotalLength = 0;
        int maxWidth = 0;
        int childState = 0;
        int alternativeMaxWidth = 0;
        int weightedMaxWidth = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getChildCount();
        int widthMode = FMeasureSpec.getMode(widthMeasureSpec);
        int heightMode = FMeasureSpec.getMode(heightMeasureSpec);
        boolean matchWidth = false;
        boolean skippedMeasure = false;
        int largestChildHeight = Integer.MIN_VALUE;
        int consumedExcessSpace = 0;
        for (int i = 0; i < count; ++i) {
            boolean useExcessSpace;
            FView child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getFLayoutParams();
            totalWeight += lp.weight;
            boolean bl = useExcessSpace = lp.height == 0 && lp.weight > 0.0f;
            if (heightMode == 0x40000000 && useExcessSpace) {
                int totalLength = mTotalLength;
                mTotalLength = Math.max(totalLength, totalLength + lp.topMargin + lp.bottomMargin);
                skippedMeasure = true;
            } else {
                if (useExcessSpace) {
                    lp.height = -2;
                }
                int usedHeight = totalWeight == 0.0f ? mTotalLength : 0;
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, 0, heightMeasureSpec, usedHeight);
                int childHeight = child.getMeasuredHeight();
                if (useExcessSpace) {
                    lp.height = 0;
                    consumedExcessSpace += childHeight;
                }
                int totalLength = mTotalLength;
                mTotalLength = Math.max(totalLength, totalLength + childHeight + lp.topMargin + lp.bottomMargin);
            }
            boolean matchWidthLocally = false;
            if (widthMode != 0x40000000 && lp.width == -1) {
                matchWidth = true;
                matchWidthLocally = true;
            }
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            childState = FLinearLayout.combineMeasuredStates(childState, child.getMeasuredState());
            boolean bl2 = allFillParent = allFillParent && lp.width == -1;
            if (lp.weight > 0.0f) {
                weightedMaxWidth = Math.max(weightedMaxWidth, matchWidthLocally ? margin : measuredWidth);
                continue;
            }
            alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
        }
        int heightSize = mTotalLength += this.padding.top + this.padding.bottom;
        heightSize = Math.max(heightSize, this.getSuggestedMinimumHeight());
        int heightSizeAndState = FMeasureSpec.resolveSizeAndState(heightSize, heightMeasureSpec, 0);
        heightSize = heightSizeAndState & 0xFFFFFF;
        int remainingExcess = heightSize - mTotalLength + (this.mAllowInconsistentMeasurement ? 0 : consumedExcessSpace);
        if (skippedMeasure || remainingExcess != 0 && totalWeight > 0.0f) {
            float remainingWeightSum = totalWeight;
            mTotalLength = 0;
            for (int i = 0; i < count; ++i) {
                FView child = this.getChildAt(i);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getFLayoutParams();
                float childWeight = lp.weight;
                if (childWeight > 0.0f) {
                    int share = (int)(childWeight * (float)remainingExcess / remainingWeightSum);
                    remainingExcess -= share;
                    remainingWeightSum -= childWeight;
                    int childHeight = lp.height == 0 && (!this.mAllowInconsistentMeasurement || heightMode == 0x40000000) ? share : child.getMeasuredHeight() + share;
                    int childHeightMeasureSpec = FMeasureSpec.makeMeasureSpec(Math.max(0, childHeight), 0x40000000);
                    int childWidthMeasureSpec = FMeasureSpec.getChildMeasureSpec(widthMeasureSpec, this.padding.left + this.padding.right + lp.leftMargin + lp.rightMargin, lp.width);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childState = FLinearLayout.combineMeasuredStates(childState, child.getMeasuredState() & 0xFFFFFF00);
                }
                int margin = lp.leftMargin + lp.rightMargin;
                int measuredWidth = child.getMeasuredWidth() + margin;
                maxWidth = Math.max(maxWidth, measuredWidth);
                boolean matchWidthLocally = widthMode != 0x40000000 && lp.width == -1;
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
                allFillParent = allFillParent && lp.width == -1;
                int totalLength = mTotalLength;
                mTotalLength = Math.max(totalLength, totalLength + child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            }
            mTotalLength += this.padding.top + this.padding.bottom;
        } else {
            alternativeMaxWidth = Math.max(alternativeMaxWidth, weightedMaxWidth);
        }
        if (!allFillParent && widthMode != 0x40000000) {
            maxWidth = alternativeMaxWidth;
        }
        maxWidth += this.padding.left + this.padding.right;
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(FMeasureSpec.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), heightSizeAndState);
        if (matchWidth) {
            this.forceUniformWidth(count, heightMeasureSpec);
        }
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int mTotalLength = 0;
        int maxHeight = 0;
        int childState = 0;
        int alternativeMaxHeight = 0;
        int weightedMaxHeight = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getChildCount();
        int widthMode = FMeasureSpec.getMode(widthMeasureSpec);
        int heightMode = FMeasureSpec.getMode(heightMeasureSpec);
        boolean matchHeight = false;
        boolean skippedMeasure = false;
        boolean isExactly = widthMode == 0x40000000;
        int largestChildWidth = Integer.MIN_VALUE;
        int usedExcessSpace = 0;
        for (int i = 0; i < count; ++i) {
            boolean useExcessSpace;
            FView child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getFLayoutParams();
            totalWeight += lp.weight;
            boolean bl = useExcessSpace = lp.width == 0 && lp.weight > 0.0f;
            if (widthMode == 0x40000000 && useExcessSpace) {
                if (isExactly) {
                    mTotalLength += lp.leftMargin + lp.rightMargin;
                } else {
                    int totalLength = mTotalLength;
                    mTotalLength = Math.max(totalLength, totalLength + lp.leftMargin + lp.rightMargin);
                }
                skippedMeasure = true;
            } else {
                if (useExcessSpace) {
                    lp.width = -2;
                }
                int usedWidth = totalWeight == 0.0f ? mTotalLength : 0;
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, usedWidth, heightMeasureSpec, 0);
                int childWidth = child.getMeasuredWidth();
                if (useExcessSpace) {
                    lp.width = 0;
                    usedExcessSpace += childWidth;
                }
                if (isExactly) {
                    mTotalLength += childWidth + lp.leftMargin + lp.rightMargin;
                } else {
                    int totalLength = mTotalLength;
                    mTotalLength = Math.max(totalLength, totalLength + childWidth + lp.leftMargin + lp.rightMargin);
                }
            }
            boolean matchHeightLocally = false;
            if (heightMode != 0x40000000 && lp.height == -1) {
                matchHeight = true;
                matchHeightLocally = true;
            }
            int margin = lp.topMargin + lp.bottomMargin;
            int childHeight = child.getMeasuredHeight() + margin;
            childState = FLinearLayout.combineMeasuredStates(childState, child.getMeasuredState());
            maxHeight = Math.max(maxHeight, childHeight);
            boolean bl2 = allFillParent = allFillParent && lp.height == -1;
            if (lp.weight > 0.0f) {
                weightedMaxHeight = Math.max(weightedMaxHeight, matchHeightLocally ? margin : childHeight);
                continue;
            }
            alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
        }
        int widthSize = mTotalLength += this.padding.left + this.padding.right;
        widthSize = Math.max(widthSize, this.getSuggestedMinimumWidth());
        int widthSizeAndState = FMeasureSpec.resolveSizeAndState(widthSize, widthMeasureSpec, 0);
        widthSize = widthSizeAndState & 0xFFFFFF;
        int remainingExcess = widthSize - mTotalLength + (this.mAllowInconsistentMeasurement ? 0 : usedExcessSpace);
        if (skippedMeasure || remainingExcess != 0 && totalWeight > 0.0f) {
            float remainingWeightSum = totalWeight;
            maxHeight = -1;
            mTotalLength = 0;
            for (int i = 0; i < count; ++i) {
                FView child = this.getChildAt(i);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getFLayoutParams();
                float childWeight = lp.weight;
                if (childWeight > 0.0f) {
                    int share = (int)(childWeight * (float)remainingExcess / remainingWeightSum);
                    remainingExcess -= share;
                    remainingWeightSum -= childWeight;
                    int childWidth = lp.width == 0 && (!this.mAllowInconsistentMeasurement || widthMode == 0x40000000) ? share : child.getMeasuredWidth() + share;
                    int childWidthMeasureSpec = FMeasureSpec.makeMeasureSpec(Math.max(0, childWidth), 0x40000000);
                    int childHeightMeasureSpec = FMeasureSpec.getChildMeasureSpec(heightMeasureSpec, this.padding.top + this.padding.bottom + lp.topMargin + lp.bottomMargin, lp.height);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childState = FLinearLayout.combineMeasuredStates(childState, child.getMeasuredState() & 0xFF000000);
                }
                if (isExactly) {
                    mTotalLength += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
                } else {
                    int totalLength = mTotalLength;
                    mTotalLength = Math.max(totalLength, totalLength + child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
                }
                boolean matchHeightLocally = heightMode != 0x40000000 && lp.height == -1;
                int margin = lp.topMargin + lp.bottomMargin;
                int childHeight = child.getMeasuredHeight() + margin;
                maxHeight = Math.max(maxHeight, childHeight);
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
                allFillParent = allFillParent && lp.height == -1;
            }
            mTotalLength += this.padding.left + this.padding.right;
        } else {
            alternativeMaxHeight = Math.max(alternativeMaxHeight, weightedMaxHeight);
        }
        if (!allFillParent && heightMode != 0x40000000) {
            maxHeight = alternativeMaxHeight;
        }
        maxHeight += this.padding.top + this.padding.bottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(widthSizeAndState | childState & 0xFF000000, FMeasureSpec.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        if (matchHeight) {
            this.forceUniformHeight(count, widthMeasureSpec);
        }
    }

    private void forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = FMeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            FView child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getFLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    private void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = FMeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            FView child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getFLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    void measureChildBeforeLayout(FView child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        this.measureChildWithMargins(child, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    @Override
    public void layoutChild(FView view) {
        if (this.mOrientation == 1) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
    }

    @Override
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mOrientation == 1) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
    }

    void layoutVertical() {
        int paddingLeft = this.padding.left;
        int childTop = 0;
        int childLeft = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            FView child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getFLayoutParams();
            childLeft = paddingLeft + lp.leftMargin;
            this.setChildFrame(child, childLeft, childTop += lp.topMargin, childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
    }

    private void setChildFrame(FView child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }

    void layoutHorizontal() {
        int paddingTop = this.padding.top;
        int childTop = 0;
        int childLeft = 0;
        int count = this.getChildCount();
        int start = 0;
        int dir = 1;
        for (int i = 0; i < count; ++i) {
            int childIndex = start + dir * i;
            FView child = this.getChildAt(childIndex);
            if (child == null || child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getFLayoutParams();
            childTop = paddingTop + lp.topMargin;
            this.setChildFrame(child, childLeft += lp.leftMargin, childTop, childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin;
        }
    }

    @Override
    public LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    protected boolean checkLayoutParams(IFViewGroup.FLayoutParams p) {
        return p instanceof LayoutParams;
    }

    @Override
    protected IFViewGroup.FLayoutParams generateLayoutParams(IFViewGroup.FLayoutParams lp) {
        if (lp instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    public static class LayoutParams
    extends IFViewGroup.FLayoutParams {
        public float weight = 0.0f;

        public LayoutParams(int width, int height) {
            this(width, height, 0.0f);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height);
            this.weight = weight;
        }

        public LayoutParams(IFViewGroup.FLayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull LayoutParams source) {
            super(source);
            this.weight = source.weight;
        }

        public LayoutParams(LinearLayout.LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.weight = source.weight;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

