/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.MotionEvent;
import java.util.ArrayList;
import xfy.fakeview.library.fview.FView;
import xfy.fakeview.library.fview.IFViewGroup;
import xfy.fakeview.library.fview.IFViewRoot;
import xfy.fakeview.library.fview.utils.FMeasureSpec;

public abstract class FViewGroup
extends FView
implements IFViewGroup {
    protected static final String TAG = "FViewGroup----";
    protected final ArrayList<FView> mChildren = new ArrayList(12);

    public FViewGroup(Context context, IFViewRoot viewRoot) {
        super(context, viewRoot);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        int l = this.mChildren.size();
        for (int i = 0; i < l; ++i) {
            FView child = this.mChildren.get(i);
            child.onAttachedToWindow();
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        int l = this.mChildren.size();
        for (int i = 0; i < l; ++i) {
            FView child = this.mChildren.get(i);
            child.onDetachedFromWindow();
        }
    }

    @Override
    public void measureChildWithMargins(FView child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        IFViewGroup.FLayoutParams lp = child.getFLayoutParams();
        int childWidthMeasureSpec = FMeasureSpec.getChildMeasureSpec(parentWidthMeasureSpec, this.padding.left + this.padding.right + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = FMeasureSpec.getChildMeasureSpec(parentHeightMeasureSpec, this.padding.top + this.padding.bottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    @Override
    public abstract void onLayout(boolean var1, int var2, int var3, int var4, int var5);

    @Override
    public void invalidateChild(FView child, Rect rect) {
        int l = rect.left + child.getLeft();
        int t = rect.top + child.getTop();
        Rect childBound = new Rect(l, t, l + rect.width(), t + rect.height());
        if (this.parent != null) {
            this.parent.invalidateChild(this, childBound);
        }
    }

    @Override
    public void addView(FView child) {
        this.addView(child, -1);
    }

    @Override
    public void addView(FView child, int index) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child view to a ViewGroup");
        }
        IFViewGroup.FLayoutParams params = child.getFLayoutParams();
        if (params == null && (params = this.generateDefaultLayoutParams()) == null) {
            throw new IllegalArgumentException("generateDefaultLayoutParams() cannot return null");
        }
        this.addView(child, index, params);
    }

    @Override
    public void addView(FView child, IFViewGroup.FLayoutParams params) {
        this.addView(child, -1, params);
    }

    @Override
    public void addView(FView child, int index, IFViewGroup.FLayoutParams params) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child view to a ViewGroup");
        }
        this.requestFViewTreeLayout();
        this.invalidate();
        this.addViewInner(child, index, params);
    }

    protected void addViewInner(FView child, int index, IFViewGroup.FLayoutParams params) {
        if (child.getFParent() != null) {
            throw new IllegalStateException("The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        child.setFLayoutParams(params);
        if (index < 0) {
            index = this.getChildCount();
        }
        this.mChildren.add(index, child);
        child.parent = this;
    }

    @Override
    public IFViewGroup.FLayoutParams generateDefaultLayoutParams() {
        return new IFViewGroup.FLayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(IFViewGroup.FLayoutParams p) {
        return p != null;
    }

    protected IFViewGroup.FLayoutParams generateLayoutParams(IFViewGroup.FLayoutParams p) {
        return p;
    }

    @Override
    public int getChildCount() {
        return this.mChildren.size();
    }

    @Override
    public FView getChildAt(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            return null;
        }
        return this.mChildren.get(index);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            FView view = this.mChildren.get(i);
            canvas.save();
            canvas.translate((float)view.bounds.left, (float)view.bounds.top);
            canvas.clipRect(0, 0, view.bounds.width(), view.bounds.height());
            view.draw(canvas);
            canvas.restore();
        }
    }

    @Override
    public FView findViewTraversal(int id) {
        if (id == this.mId) {
            return this;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            FView child = this.mChildren.get(i);
            if ((child = child.findFViewById(id)) == null) continue;
            return child;
        }
        return null;
    }

    @Override
    public boolean isTouchInView(float x, float y) {
        if (!this.isEnabled() || this.getVisibility() == 8) {
            return false;
        }
        return this.bounds.contains((int)x, (int)y);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        FView child;
        float y;
        float x = event.getX();
        if (!this.isTouchInView(x, y = event.getY())) {
            return false;
        }
        int childCount = this.getChildCount();
        boolean handle = false;
        for (int i = childCount - 1; i >= 0 && !(handle = (child = this.mChildren.get(i)).dispatchTouchEvent(event)); --i) {
        }
        if (!handle) {
            handle = this.onTouchEvent(event);
        }
        return handle;
    }

    @Override
    public void onSetLayoutParams(FView child, IFViewGroup.FLayoutParams params) {
    }

    @Override
    public int getOldWidthMeasureSpec() {
        return this.oldWidthMeasureSpec;
    }

    @Override
    public int getOldHeightMeasureSpec() {
        return this.oldHeightMeasureSpec;
    }
}

