/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.FrameLayout;

public class TraceFrameLayout
extends FrameLayout {
    public TraceFrameLayout(@NonNull Context context) {
        this(context, null);
    }

    public TraceFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TraceFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
    }

    @RequiresApi(api=21)
    public TraceFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setWillNotDraw(false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        long start = TraceFrameLayout.now();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        TraceFrameLayout.cast("onmeasure:", start);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        long start = TraceFrameLayout.now();
        super.onLayout(changed, left, top, right, bottom);
        TraceFrameLayout.cast("onlayout:", start);
    }

    public void draw(Canvas canvas) {
        long start = TraceFrameLayout.now();
        super.draw(canvas);
        TraceFrameLayout.cast("draw:", start);
    }

    private static void cast(String pre, long start) {
        Log.d((String)"TraceFrameLayout", (String)(pre + " " + (TraceFrameLayout.now() - start)));
    }

    private static long now() {
        return System.currentTimeMillis();
    }
}

