/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.translator.data;

import android.view.View;
import java.util.HashMap;
import xfy.fakeview.library.fview.FView;
import xfy.fakeview.library.fview.normal.FImageView;
import xfy.fakeview.library.fview.normal.FTextView;
import xfy.fakeview.library.translator.data.IDataTranslator;
import xfy.fakeview.library.translator.data.ImageDataTranslator;
import xfy.fakeview.library.translator.data.TextDataTranslator;
import xfy.fakeview.library.translator.data.ViewDataTranslator;

public class DataTranslatorManager {
    private static final HashMap<Class<? extends FView>, IDataTranslator> dataTranslatorMap = new HashMap();

    public static void registerTranslator(Class<? extends FView> clz, IDataTranslator translator) {
        dataTranslatorMap.put(clz, translator);
    }

    public static boolean translateData(FView fView, View src) {
        IDataTranslator translator = dataTranslatorMap.get(fView.getClass());
        if (translator == null) {
            return false;
        }
        if (!translator.checkSrc(src)) {
            return false;
        }
        return translator.translateData(fView, src);
    }

    static {
        dataTranslatorMap.put(FImageView.class, new ImageDataTranslator());
        dataTranslatorMap.put(FTextView.class, new TextDataTranslator());
        dataTranslatorMap.put(FView.class, new ViewDataTranslator());
    }
}

