/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview.utils;

import android.annotation.SuppressLint;
import android.support.annotation.IntRange;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FMeasureSpec {
    private static final int MODE_SHIFT = 30;
    private static final int MODE_MASK = -1073741824;
    public static final int UNSPECIFIED = 0;
    public static final int EXACTLY = 0x40000000;
    public static final int AT_MOST = Integer.MIN_VALUE;
    public static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    public static final int MEASURED_STATE_MASK = -16777216;

    public static int makeMeasureSpec(@IntRange(from=0L, to=0x3FFFFFFFL) int size, int mode) {
        return size & 0x3FFFFFFF | mode & 0xC0000000;
    }

    public static int makeSafeMeasureSpec(int size, int mode) {
        return FMeasureSpec.makeMeasureSpec(size, mode);
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getMode(int measureSpec) {
        return measureSpec & 0xC0000000;
    }

    public static int getSize(int measureSpec) {
        return measureSpec & 0x3FFFFFFF;
    }

    static int adjust(int measureSpec, int delta) {
        int mode = FMeasureSpec.getMode(measureSpec);
        int size = FMeasureSpec.getSize(measureSpec);
        if (mode == 0) {
            return FMeasureSpec.makeMeasureSpec(size, 0);
        }
        if ((size += delta) < 0) {
            size = 0;
        }
        return FMeasureSpec.makeMeasureSpec(size, mode);
    }

    public static String toString(int measureSpec) {
        int mode = FMeasureSpec.getMode(measureSpec);
        int size = FMeasureSpec.getSize(measureSpec);
        StringBuilder sb = new StringBuilder("FMeasureSpec: ");
        if (mode == 0) {
            sb.append("UNSPECIFIED ");
        } else if (mode == 0x40000000) {
            sb.append("EXACTLY ");
        } else if (mode == Integer.MIN_VALUE) {
            sb.append("AT_MOST ");
        } else {
            sb.append(mode).append(" ");
        }
        sb.append(size);
        return sb.toString();
    }

    public static int getDefaultSize(int size, int measureSpec) {
        int result = size;
        int specMode = FMeasureSpec.getMode(measureSpec);
        int specSize = FMeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: 
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    public static int getChildMeasureSpec(int spec, int padding, int childDimension) {
        int specMode = FMeasureSpec.getMode(spec);
        int specSize = FMeasureSpec.getSize(spec);
        int size = Math.max(0, specSize - padding);
        int resultSize = 0;
        int resultMode = 0;
        switch (specMode) {
            case 0x40000000: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case -2147483648: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = Integer.MIN_VALUE;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case 0: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = 0;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = 0;
            }
        }
        return FMeasureSpec.makeMeasureSpec(resultSize, resultMode);
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result;
        int specMode = FMeasureSpec.getMode(measureSpec);
        int specSize = FMeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
                break;
            }
            default: {
                result = size;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MeasureSpecMode {
    }
}

