/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.layermerge;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import xfy.fakeview.library.translator.EventExtractor;

public class LayersMergeManager {
    public static final int EXTRACT_NONE = 0;
    public static final int EXTRACT_BACKGROUND = 1;
    public static final int EXTRACT_CLICK_EVENT = 16;
    public static final int EXTRACT_LONG_CLICK_EVENT = 256;
    public static final int EXTRACT_ALL_EVENT = 272;
    public static final int EXTRACT_ALL = 273;
    private FrameLayout rootLayout;
    private Loc rootLoc;
    private int rootWidth;
    private int rootHeight;
    private ArrayList<View> childrens;
    private ArrayList<Loc> childrenLoc;
    private int extractFlag = 0;

    public static boolean needMerge(ViewGroup parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(parent.getChildAt(i) instanceof ViewGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadyToMerge(ViewGroup src) {
        int childCount = src.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = src.getChildAt(i);
            int[] loc = LayersMergeManager.getViewLocation(child);
            if (loc[0] != 0 || loc[1] != 0) {
                return true;
            }
            if (!(child instanceof ViewGroup) || !LayersMergeManager.isReadyToMerge((ViewGroup)child)) continue;
            return true;
        }
        return false;
    }

    public LayersMergeManager(FrameLayout parent) {
        this(parent, 0);
    }

    public LayersMergeManager(FrameLayout parent, int flag) {
        this.extractFlag = flag;
        this.rootLayout = parent;
        this.rootLoc = new Loc(LayersMergeManager.getViewLocation((View)parent));
        this.rootWidth = parent.getWidth();
        this.rootHeight = parent.getHeight();
        this.childrens = new ArrayList();
        this.childrenLoc = new ArrayList();
    }

    public void mergeChildrenLayers() {
        this.extractViewFromParent((ViewGroup)this.rootLayout);
        this.addChildrenByLoc();
        this.rootLayout = null;
        this.rootLoc = null;
    }

    private void addChildrenByLoc() {
        int childCount = this.childrens.size();
        int pl = this.rootLayout.getPaddingLeft();
        int pt = this.rootLayout.getPaddingTop();
        for (int i = 0; i < childCount; ++i) {
            View child = this.childrens.get(i);
            Loc childLoc = this.childrenLoc.get(i);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(child.getLayoutParams());
            params.setMargins(childLoc.left - this.rootLoc.left - pl, childLoc.top - this.rootLoc.top - pt, 0, 0);
            this.rootLayout.addView(child, (ViewGroup.LayoutParams)params);
        }
        ViewGroup.LayoutParams params = this.rootLayout.getLayoutParams();
        params.width = this.rootWidth;
        params.height = this.rootHeight;
        this.rootLayout.setLayoutParams(params);
        this.childrens.clear();
        this.childrenLoc.clear();
    }

    private void extractViewFromParent(ViewGroup parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View c = parent.getChildAt(i);
            if (c instanceof ViewGroup) {
                View backgroundHolder = this.createViewByExtractingFlag((ViewGroup)c);
                if (backgroundHolder != null) {
                    this.childrens.add(backgroundHolder);
                    this.childrenLoc.add(new Loc(LayersMergeManager.getViewLocation(c)));
                }
                this.extractViewFromParent((ViewGroup)c);
                continue;
            }
            this.childrens.add(c);
            this.childrenLoc.add(new Loc(LayersMergeManager.getViewLocation(c)));
        }
        parent.removeAllViews();
    }

    private View createViewByExtractingFlag(ViewGroup src) {
        View.OnLongClickListener longClickListener;
        View.OnClickListener clickListener;
        Drawable background;
        int flag = this.extractFlag;
        if (flag == 0) {
            return null;
        }
        View result = null;
        if ((flag & 1) == 1 && (background = src.getBackground()) != null) {
            result = this.createHolderViewForViewGroup(src);
            if (Build.VERSION.SDK_INT >= 16) {
                result.setBackground(background);
            } else {
                result.setBackgroundDrawable(background);
            }
        }
        if ((flag & 0x10) == 16 && (clickListener = EventExtractor.getViewOnClickListener((View)src)) != null) {
            result = result == null ? this.createHolderViewForViewGroup(src) : result;
            result.setOnClickListener(clickListener);
        }
        if ((flag & 0x100) == 256 && (longClickListener = EventExtractor.getViewOnLongClickListener((View)src)) != null) {
            result = result == null ? this.createHolderViewForViewGroup(src) : result;
            result.setOnLongClickListener(longClickListener);
        }
        return result;
    }

    private View createHolderViewForViewGroup(ViewGroup src) {
        View holder = new View(src.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(src.getWidth(), src.getHeight());
        holder.setLayoutParams(params);
        holder.setId(src.getId());
        return holder;
    }

    private static int[] getViewLocation(View view) {
        int[] loc = new int[2];
        view.getLocationInWindow(loc);
        return loc;
    }

    static class Loc {
        int left;
        int top;

        Loc() {
        }

        Loc(int[] loc) {
            this.left = loc[0];
            this.top = loc[1];
        }
    }
}

