/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview.normal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import xfy.fakeview.library.fview.FView;
import xfy.fakeview.library.fview.FViewGroup;
import xfy.fakeview.library.fview.IFViewGroup;
import xfy.fakeview.library.fview.IFViewRoot;
import xfy.fakeview.library.fview.utils.FMeasureSpec;

public class FFrameLayout
extends FViewGroup {
    private static final int DEFAULT_CHILD_GRAVITY = 0x800033;
    private final ArrayList<FView> mMatchParentChildren = new ArrayList(1);

    public FFrameLayout(Context context, IFViewRoot viewRoot) {
        super(context, viewRoot);
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        LayoutParams lp;
        FView child;
        int i;
        int count = this.getChildCount();
        boolean measureMatchParentChildren = FMeasureSpec.getMode(widthMeasureSpec) != 0x40000000 || FMeasureSpec.getMode(heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            lp = (LayoutParams)child.getFLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = FFrameLayout.combineMeasuredStates(childState, child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(FMeasureSpec.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), FMeasureSpec.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (i = 0; i < count; ++i) {
                int childHeightMeasureSpec;
                int childWidthMeasureSpec;
                child = this.mMatchParentChildren.get(i);
                lp = (LayoutParams)child.getFLayoutParams();
                if (lp.width == -1) {
                    int width = Math.max(0, this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - lp.leftMargin - lp.rightMargin);
                    childWidthMeasureSpec = FMeasureSpec.makeMeasureSpec(width, 0x40000000);
                } else {
                    childWidthMeasureSpec = FMeasureSpec.getChildMeasureSpec(widthMeasureSpec, this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin, lp.width);
                }
                if (lp.height == -1) {
                    int height = Math.max(0, this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin);
                    childHeightMeasureSpec = FMeasureSpec.makeMeasureSpec(height, 0x40000000);
                } else {
                    childHeightMeasureSpec = FMeasureSpec.getChildMeasureSpec(heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin, lp.height);
                }
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    public static int combineMeasuredStates(int curState, int newState) {
        return curState | newState;
    }

    @Override
    public void layoutChild(FView child) {
        int parentLeft = this.getPaddingLeft();
        int parentRight = this.bounds.right - this.bounds.left - this.getPaddingRight();
        int parentTop = this.getPaddingTop();
        int parentBottom = this.bounds.bottom - this.bounds.top - this.getPaddingBottom();
        this.layoutChild(child, parentLeft, parentRight, parentTop, parentBottom);
    }

    private void layoutChild(FView child, int parentLeft, int parentRight, int parentTop, int parentBottom) {
        if (child.getVisibility() != 8) {
            int childTop;
            int childLeft;
            LayoutParams lp = (LayoutParams)child.getFLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            boolean layoutDirection = false;
            int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)0);
            int verticalGravity = gravity & 0x70;
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = parentRight - width - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = parentLeft + lp.leftMargin;
                }
            }
            switch (verticalGravity) {
                case 48: {
                    childTop = parentTop + lp.topMargin;
                    break;
                }
                case 16: {
                    childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = parentBottom - height - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = parentTop + lp.topMargin;
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    @Override
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeft();
        int parentRight = this.bounds.right - this.bounds.left - this.getPaddingRight();
        int parentTop = this.getPaddingTop();
        int parentBottom = this.bounds.bottom - this.bounds.top - this.getPaddingBottom();
        for (int i = 0; i < count; ++i) {
            FView child = this.getChildAt(i);
            this.layoutChild(child, parentLeft, parentRight, parentTop, parentBottom);
        }
    }

    @Override
    public LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    protected boolean checkLayoutParams(IFViewGroup.FLayoutParams p) {
        return p instanceof LayoutParams;
    }

    @Override
    protected IFViewGroup.FLayoutParams generateLayoutParams(IFViewGroup.FLayoutParams lp) {
        if (lp instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    public static class LayoutParams
    extends IFViewGroup.FLayoutParams {
        public static final int UNSPECIFIED_GRAVITY = -1;
        public int gravity = -1;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height);
            this.gravity = gravity;
        }

        public LayoutParams(IFViewGroup.FLayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull LayoutParams source) {
            super(source);
            this.gravity = source.gravity;
        }

        public LayoutParams(@NonNull FrameLayout.LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.gravity = source.gravity;
        }
    }
}

