/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.layermerge;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import xfy.fakeview.library.layermerge.LayersMergeManager;

public class LayersMergeEngine {
    private static final String TAG = "LayersMergeEngine";
    private static boolean DEBUG = false;
    private static volatile LayersMergeEngine engine;
    private final Handler mainHandler;
    private final Scheduler mScheduler = new Scheduler("LayersMergeEngineScheduler");
    private final HashMap<Object, ArrayList<LayoutData>> mergeActions;
    private boolean mPause = false;
    private int mergingLayoutHashcode = -1;
    private boolean merging = false;

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    private LayersMergeEngine() {
        this.mScheduler.start();
        this.mergeActions = new HashMap();
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LayersMergeEngine getEngine() {
        if (engine != null) return engine;
        Class<LayersMergeEngine> clazz = LayersMergeEngine.class;
        synchronized (LayersMergeEngine.class) {
            if (engine != null) return engine;
            engine = new LayersMergeEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return engine;
        }
    }

    public synchronized void pause() {
        this.mPause = true;
    }

    public synchronized void resume() {
        this.mPause = false;
        if (!this.merging) {
            this.mScheduler.post(new NextAction());
        }
    }

    public boolean addMergeAction(Object tag, FrameLayout layout) {
        return this.addMergeAction(tag, layout, false);
    }

    public boolean addMergeAction(Object tag, FrameLayout layout, boolean createBackgroundView) {
        if (!LayersMergeManager.needMerge((ViewGroup)layout)) {
            return false;
        }
        ArrayList<LayoutData> list = this.mergeActions.get(tag);
        if (list == null) {
            list = new ArrayList();
            this.mergeActions.put(tag, list);
        }
        if (list.contains(layout) || layout.hashCode() == this.mergingLayoutHashcode) {
            return true;
        }
        list.add(new LayoutData(layout, createBackgroundView));
        if (!this.merging) {
            this.mScheduler.post(new NextAction());
        }
        return true;
    }

    public synchronized void removeMergeActionByTag(Object tag) {
        ArrayList<LayoutData> list = this.mergeActions.remove(tag);
        if (list == null) {
            return;
        }
        list.clear();
    }

    public synchronized void removeAllAction() {
        for (Object k : this.mergeActions.keySet()) {
            ArrayList<LayoutData> list = this.mergeActions.get(k);
            if (list == null) continue;
            list.clear();
        }
        this.mergeActions.clear();
    }

    private synchronized void scheduleNext() {
        if (this.mPause || this.merging || this.mergeActions.isEmpty()) {
            if (DEBUG) {
                Log.d((String)TAG, (String)("merging: " + this.merging + " pause: " + this.mPause + " or empty"));
            }
            return;
        }
        Set<Object> keys = this.mergeActions.keySet();
        if (keys.isEmpty()) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"keys is empty");
            }
            return;
        }
        Object layoutData = null;
        ArrayList<LayoutData> list = null;
        Object key = null;
        for (Object k : keys) {
            list = this.mergeActions.get(k);
            if (list == null || list.isEmpty()) continue;
            for (LayoutData l : list) {
                if (l == null) continue;
                layoutData = l;
                break;
            }
            if (layoutData == null) continue;
            key = k;
            break;
        }
        if (layoutData == null) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"no layout to merge");
            }
            return;
        }
        if (this.mPause) {
            return;
        }
        if (this.mScheduler.post(new Action((LayoutData)layoutData))) {
            list.remove(layoutData);
            if (list.isEmpty()) {
                this.mergeActions.remove(key);
            }
            this.mergingLayoutHashcode = layoutData.hashCode();
            this.merging = true;
        } else {
            if (DEBUG) {
                Log.d((String)TAG, (String)"have not created handler yet");
            }
            this.mScheduler.post(new NextAction());
        }
    }

    private class Scheduler
    extends HandlerThread {
        private Handler mHandler;
        private Looper myLooper;

        public Scheduler(String name) {
            super(name);
        }

        protected void onLooperPrepared() {
            this.mHandler = new Handler();
            this.myLooper = Looper.myLooper();
        }

        boolean post(Runnable action) {
            if (this.mHandler != null) {
                return this.mHandler.post(action);
            }
            return false;
        }

        boolean postDelay(Runnable action, long delay) {
            if (this.mHandler != null) {
                return this.mHandler.postDelayed(action, delay);
            }
            return false;
        }

        boolean removeAction(Runnable action) {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks(action);
                return true;
            }
            return false;
        }

        boolean checkLooper() {
            return Looper.myLooper() == this.myLooper;
        }
    }

    private static class LayoutData {
        FrameLayout layout;
        boolean extracting = false;

        LayoutData(FrameLayout layout, boolean extracting) {
            this.layout = layout;
            this.extracting = extracting;
        }
    }

    private class Action
    implements Runnable {
        Object lock;
        LayoutData layout;

        Action(LayoutData layout) {
            this.layout = layout;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.layout == null || this.layout.layout == null) {
                return;
            }
            if (DEBUG) {
                Log.d((String)LayersMergeEngine.TAG, (String)("run action: " + this.layout));
            }
            LayersMergeEngine.this.mainHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (DEBUG) {
                        Log.d((String)LayersMergeEngine.TAG, (String)("real run action: " + Action.this.layout));
                    }
                    LayersMergeManager manager = new LayersMergeManager(Action.this.layout.layout, Action.this.layout.extracting);
                    manager.mergeChildrenLayers();
                    Object object = Action.this.lock;
                    synchronized (object) {
                        Action.this.lock.notifyAll();
                    }
                }
            });
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (DEBUG) {
                Log.d((String)LayersMergeEngine.TAG, (String)("action done: " + this.layout));
            }
            LayersMergeEngine.this.mergingLayoutHashcode = -1;
            LayersMergeEngine.this.merging = false;
            LayersMergeEngine.this.mScheduler.postDelay(new NextAction(), 1L);
        }
    }

    private class NextAction
    implements Runnable {
        private NextAction() {
        }

        @Override
        public void run() {
            LayersMergeEngine.this.scheduleNext();
        }
    }
}

