/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.util.HashSet;
import java.util.Set;
import xfy.fakeview.library.fview.FView;
import xfy.fakeview.library.fview.IFViewGroup;
import xfy.fakeview.library.fview.IFViewRoot;
import xfy.fakeview.library.fview.utils.FMeasureSpec;

public class FViewRootImpl
extends View
implements IFViewRoot {
    private static final String TAG = "FViewRootImpl";
    private static boolean DEBUG = false;
    private FView mTargetView;
    private boolean attached = false;
    private int oldWidthMeasureSpec;
    private int oldHeightMeasureSpec;
    private Set<WrapperRunnable> runnables = new HashSet<WrapperRunnable>();

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public FViewRootImpl(Context context) {
        this(context, null);
    }

    public FViewRootImpl(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FViewRootImpl(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.setWillNotDraw(false);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTargetView != null) {
            this.mTargetView.onAttachedToWindow();
        }
        this.attached = true;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTargetView != null) {
            this.mTargetView.onDetachedFromWindow();
        }
        this.attached = false;
    }

    @Override
    public void layoutChild(FView view) {
        if (this.mTargetView == null) {
            return;
        }
        long start = System.currentTimeMillis();
        if (view == this.mTargetView) {
            int pl = this.getPaddingLeft();
            int pt = this.getPaddingTop();
            int pr = this.getPaddingRight();
            int pb = this.getPaddingBottom();
            int w = this.getWidth();
            int h = this.getHeight();
            view.layout(pl, pt, w - pl - pr, h - pt - pb);
        }
        this.d(TAG, "layout fView cast: " + (System.currentTimeMillis() - start));
    }

    @Override
    public boolean post(Runnable action) {
        boolean result = super.post(action);
        if (result) {
            this.runnables.add(new WrapperRunnable(action));
        }
        return result;
    }

    @Override
    public boolean postDelayed(Runnable action, long delayMillis) {
        boolean result = super.postDelayed(action, delayMillis);
        if (result) {
            this.runnables.add(new WrapperRunnable(action));
        }
        return result;
    }

    @Override
    public boolean removeCallbacks(Runnable action) {
        boolean result = super.removeCallbacks(action);
        this.runnables.remove(action);
        return result;
    }

    @Override
    public void onSetLayoutParams(FView child, IFViewGroup.FLayoutParams params) {
    }

    @Override
    public int getOldWidthMeasureSpec() {
        return this.oldWidthMeasureSpec;
    }

    @Override
    public int getOldHeightMeasureSpec() {
        return this.oldHeightMeasureSpec;
    }

    @Override
    public void removeAllCallbacks() {
        for (Runnable runnable : this.runnables) {
            if (runnable == null) continue;
            this.removeCallbacks(runnable);
        }
        this.runnables.clear();
    }

    @Override
    public void requestLayoutAll() {
        this.requestLayout();
    }

    @Override
    public void invalidateChild(FView child, Rect rect) {
        this.invalidate(rect);
    }

    @Override
    public void setTargetChild(FView view) {
        FView old = this.mTargetView;
        if (old != view && old != null) {
            old.isRootView = false;
            old.onDetachedFromWindow();
            old.parent = null;
        }
        this.mTargetView = view;
        if (view != null) {
            view.isRootView = true;
            view.parent = this;
            if (this.attached) {
                view.onAttachedToWindow();
            }
        }
    }

    @Override
    public FView getTargetChild() {
        return this.mTargetView;
    }

    @Override
    public FView findFViewById(int id) {
        if (id <= 0 || this.mTargetView == null) {
            return null;
        }
        return this.mTargetView.findFViewById(id);
    }

    @Override
    public void requestFViewTreeLayout() {
        if (this.mTargetView == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if (FViewRootImpl.this.mTargetView != null) {
                    FViewRootImpl.this.measureChildWithMargins(FViewRootImpl.this.mTargetView, FViewRootImpl.this.oldWidthMeasureSpec, 0, FViewRootImpl.this.oldHeightMeasureSpec, 0);
                    FViewRootImpl.this.layoutChild(FViewRootImpl.this.mTargetView);
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mTargetView != null) {
            this.measureChildWithMargins(this.mTargetView, widthMeasureSpec, 0, heightMeasureSpec, 0);
            IFViewGroup.FLayoutParams lp = this.mTargetView.getFLayoutParams();
            int maxWidth = this.mTargetView.getMeasuredWidth() + lp.leftMargin + lp.rightMargin + this.getPaddingLeft() + this.getPaddingRight();
            int maxHeight = this.mTargetView.getMeasuredHeight() + lp.topMargin + lp.bottomMargin + this.getPaddingTop() + this.getPaddingBottom();
            this.setMeasuredDimension(FMeasureSpec.resolveSizeAndState(maxWidth, widthMeasureSpec, this.mTargetView.getMeasuredState()), FMeasureSpec.resolveSizeAndState(maxHeight, heightMeasureSpec, this.mTargetView.getMeasuredState() << 16));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        this.oldWidthMeasureSpec = widthMeasureSpec;
        this.oldHeightMeasureSpec = heightMeasureSpec;
    }

    @Override
    public void measureChildWithMargins(FView child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        IFViewGroup.FLayoutParams lp = child.getFLayoutParams();
        int childWidthMeasureSpec = FMeasureSpec.getChildMeasureSpec(parentWidthMeasureSpec, this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = FMeasureSpec.getChildMeasureSpec(parentHeightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        long start = System.currentTimeMillis();
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        this.d(TAG, "measure fView cast: " + (System.currentTimeMillis() - start));
    }

    protected void onDraw(Canvas canvas) {
        if (this.mTargetView != null) {
            long start = System.currentTimeMillis();
            this.mTargetView.draw(canvas);
            this.d(TAG, "draw fView cast: " + (System.currentTimeMillis() - start));
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mTargetView != null) {
            return this.mTargetView.dispatchTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    private void d(String tag, String msg) {
        if (DEBUG) {
            Log.d((String)tag, (String)msg);
        }
    }

    class WrapperRunnable
    implements Runnable {
        Runnable action;

        WrapperRunnable(Runnable action) {
            this.action = action;
        }

        @Override
        public void run() {
            if (this.action != null) {
                this.action.run();
            }
            FViewRootImpl.this.runnables.remove(this);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == this.action) {
                return true;
            }
            if (obj instanceof WrapperRunnable) {
                return ((WrapperRunnable)obj).action == this.action;
            }
            return false;
        }
    }
}

