/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.layermerge;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;

public class LayersMergeManager {
    private FrameLayout rootLayout;
    private Loc rootLoc;
    private int rootWidth;
    private int rootHeight;
    private ArrayList<View> childrens;
    private ArrayList<Loc> childrenLoc;

    public static boolean needMerge(ViewGroup parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(parent.getChildAt(i) instanceof ViewGroup)) continue;
            return true;
        }
        return false;
    }

    public LayersMergeManager(FrameLayout parent) {
        this.rootLayout = parent;
        this.rootLoc = new Loc(LayersMergeManager.getViewLocation((View)parent));
        this.rootWidth = parent.getWidth();
        this.rootHeight = parent.getHeight();
        this.childrens = new ArrayList();
        this.childrenLoc = new ArrayList();
    }

    public void mergeChildrenLayers() {
        this.extractViewFromParent((ViewGroup)this.rootLayout);
        this.addChildrenByLoc();
        this.rootLayout = null;
        this.rootLoc = null;
    }

    private void addChildrenByLoc() {
        int childCount = this.childrens.size();
        int pl = this.rootLayout.getPaddingLeft();
        int pt = this.rootLayout.getPaddingTop();
        for (int i = 0; i < childCount; ++i) {
            View child = this.childrens.get(i);
            Loc childLoc = this.childrenLoc.get(i);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(child.getLayoutParams());
            params.setMargins(childLoc.left - this.rootLoc.left - pl, childLoc.top - this.rootLoc.top - pt, 0, 0);
            this.rootLayout.addView(child, (ViewGroup.LayoutParams)params);
        }
        ViewGroup.LayoutParams params = this.rootLayout.getLayoutParams();
        params.width = this.rootWidth;
        params.height = this.rootHeight;
        this.rootLayout.setLayoutParams(params);
        this.childrens.clear();
        this.childrenLoc.clear();
    }

    private void extractViewFromParent(ViewGroup parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View c = parent.getChildAt(i);
            if (c instanceof ViewGroup) {
                this.extractViewFromParent((ViewGroup)c);
                continue;
            }
            this.childrens.add(c);
            this.childrenLoc.add(new Loc(LayersMergeManager.getViewLocation(c)));
        }
        parent.removeAllViews();
    }

    private static int[] getViewLocation(View view) {
        int[] loc = new int[2];
        view.getLocationInWindow(loc);
        return loc;
    }

    static class Loc {
        int left;
        int top;

        Loc() {
        }

        Loc(int[] loc) {
            this.left = loc[0];
            this.top = loc[1];
        }
    }
}

