/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import xfy.fakeview.library.fview.FViewParent;
import xfy.fakeview.library.fview.FViewRootImpl;
import xfy.fakeview.library.fview.IFView;
import xfy.fakeview.library.fview.IFViewGroup;
import xfy.fakeview.library.fview.IFViewRoot;
import xfy.fakeview.library.fview.utils.FMeasureSpec;
import xfy.fakeview.library.fview.utils.FViewDebugTool;
import xfy.fakeview.library.fview.utils.ViewUtils;

public class FView
implements IFView,
Drawable.Callback {
    protected static final String TAG = "FView-----";
    protected static boolean DEBUG = true;
    protected Context mContext;
    protected IFViewRoot viewRoot;
    FViewParent parent;
    boolean isRootView = false;
    protected IFViewGroup.FLayoutParams mFLayoutParams;
    protected int mId = -1;
    private int flag;
    protected int measureWidth;
    protected int measureHeight;
    protected int oldWidthMeasureSpec;
    protected int oldHeightMeasureSpec;
    protected final Rect bounds = new Rect();
    protected final Rect padding = new Rect();
    private Drawable mBackground;
    private boolean mBackgroundSizeChanged;
    private int mBackgroundResource;
    private final HashMap<Drawable, ArrayList<Runnable>> drawableActions;
    protected final ListenerInfo listenerInfo = new ListenerInfo();
    private boolean mHasPerformedLongPress = false;
    private CheckForLongPress mPendingCheckForLongPress;
    private UnsetPressedState mUnsetPressedState;
    private FViewDebugTool debugTool;

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public FView(Context context, IFViewRoot viewRoot) {
        this.mContext = context;
        this.viewRoot = viewRoot;
        this.drawableActions = new HashMap();
    }

    @Override
    public void onAttachedToWindow() {
        this.addFlag(256);
    }

    @Override
    public void onDetachedFromWindow() {
        this.removeFlag(256);
        this.removeLongPressCallback();
        this.removeUnsetPressCallback();
        this.unscheduleDrawable(this.mBackground);
    }

    @Override
    public void setVisibility(int visibility) {
        FView.checkVisibilityMask(visibility);
        this.removeFlag(12);
        this.addFlag(visibility);
    }

    @Override
    public int getVisibility() {
        return this.getFlag(12);
    }

    protected static void checkVisibilityMask(int visibility) {
        if (visibility != 0 || visibility != 4 || visibility != 8) {
            throw new IllegalArgumentException("param visibility can only use : [VISIBLE, INVISIBLE, GONE]");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        int flag = enabled ? 0 : 32;
        this.removeFlag(32);
        this.addFlag(flag);
    }

    @Override
    public boolean isEnabled() {
        return this.getFlag(32) == 0;
    }

    @Override
    public final void measure(int widthMeasureSpec, int heightMeasureSpec) {
        this.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.oldWidthMeasureSpec = widthMeasureSpec;
        this.oldHeightMeasureSpec = heightMeasureSpec;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(FMeasureSpec.getDefaultSize(this.getSuggestedMinimumWidth(), widthMeasureSpec), FMeasureSpec.getDefaultSize(this.getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    protected final void setMeasuredDimension(int measuredWidth, int measuredHeight) {
        this.measureWidth = measuredWidth;
        this.measureHeight = measuredHeight;
    }

    @Override
    public final int getMeasuredState() {
        return this.measureWidth & 0xFF000000 | this.measureHeight >> 16 & 0xFFFFFF00;
    }

    @Override
    public void layout(int l, int t, int r, int b) {
        boolean changed = this.bounds.left != l || this.bounds.top != t || this.bounds.right != r || this.bounds.bottom != b;
        this.setFrame(l, t, r, b);
        this.onLayout(changed, l, t, r, b);
        this.addFlag(512);
    }

    protected boolean isLayout() {
        return this.getFlag(512) == 512;
    }

    protected void setFrame(int l, int t, int r, int b) {
        this.bounds.set(l, t, r, b);
        this.mBackgroundSizeChanged = true;
    }

    @Override
    public void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    @Override
    public void draw(Canvas canvas) {
        if (!this.isAttachedToWindow() || !this.isLayout() || this.getVisibility() == 8) {
            return;
        }
        if (this.mBackground != null) {
            this.setBackgroundBounds();
            this.mBackground.draw(canvas);
        }
        this.onDraw(canvas);
        this.dispatchDraw(canvas);
        if (DEBUG) {
            this.debugDraw(canvas);
        }
    }

    private void debugDraw(Canvas canvas) {
        if (this.debugTool == null) {
            this.debugTool = new FViewDebugTool();
        }
        this.debugTool.withBounds(0, 0, this.bounds.width(), this.bounds.height());
        this.debugTool.draw(canvas);
    }

    void setBackgroundBounds() {
        if (this.mBackgroundSizeChanged && this.mBackground != null) {
            this.mBackground.setBounds(0, 0, this.bounds.width(), this.bounds.height());
            this.mBackgroundSizeChanged = false;
        }
    }

    protected void dispatchDraw(Canvas canvas) {
    }

    protected void onDraw(Canvas canvas) {
    }

    @Override
    public void setId(int id) {
        this.mId = id;
    }

    @Override
    public int getId() {
        return this.mId;
    }

    @Override
    public FView findFViewById(int id) {
        if (id <= 0) {
            return null;
        }
        return this.findViewTraversal(id);
    }

    protected FView findViewTraversal(int id) {
        if (id == this.mId) {
            return this;
        }
        return null;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    protected Resources getResources() {
        return this.mContext != null ? this.mContext.getResources() : null;
    }

    @Override
    public FViewParent getFParent() {
        return this.parent;
    }

    @Override
    public void invalidate() {
        Rect dirty = new Rect(0, 0, this.bounds.width(), this.bounds.height());
        this.invalidate(dirty);
    }

    protected void invalidate(Rect dirty) {
        if (this.parent != null) {
            this.parent.invalidateChild(this, dirty);
        }
    }

    @Override
    public IFViewGroup.FLayoutParams getFLayoutParams() {
        return this.mFLayoutParams;
    }

    @Override
    public void setFLayoutParams(IFViewGroup.FLayoutParams params) {
        if (params == null) {
            throw new NullPointerException("Layout parameters cannot be null");
        }
        this.mFLayoutParams = params;
        if (this.parent != null) {
            this.parent.onSetLayoutParams(this, params);
        }
        this.requestFViewTreeLayout();
    }

    @Override
    public void setBackgroundColor(int color) {
        if (this.mBackground instanceof ColorDrawable) {
            ((ColorDrawable)this.mBackground.mutate()).setColor(color);
            this.mBackgroundResource = 0;
        } else {
            this.setBackground((Drawable)new ColorDrawable(color));
        }
    }

    @Override
    public void setBackgroundResource(int resid) {
        if (resid != 0 && resid == this.mBackgroundResource) {
            return;
        }
        Drawable d = null;
        if (resid != 0) {
            d = this.mContext.getResources().getDrawable(resid);
        }
        this.setBackground(d);
        this.mBackgroundResource = resid;
    }

    @Override
    public void setBackground(Drawable background) {
        if (background == this.mBackground) {
            return;
        }
        boolean requestLayout = false;
        this.mBackgroundResource = 0;
        if (this.mBackground != null) {
            if (this.isAttachedToWindow()) {
                this.mBackground.setVisible(false, false);
            }
            this.mBackground.setCallback(null);
            this.unscheduleDrawable(this.mBackground);
        }
        if (background != null) {
            Rect padding = new Rect();
            if (background.getPadding(padding)) {
                this.internalSetPadding(padding.left, padding.top, padding.right, padding.bottom);
            }
            if (this.mBackground == null || this.mBackground.getMinimumHeight() != background.getMinimumHeight() || this.mBackground.getMinimumWidth() != background.getMinimumWidth()) {
                requestLayout = true;
            }
            this.mBackground = background;
            if (this.isAttachedToWindow()) {
                background.setVisible(this.getVisibility() == 0, false);
            }
            background.setCallback((Drawable.Callback)this);
        } else {
            this.mBackground = null;
            requestLayout = true;
        }
        if (requestLayout) {
            this.requestFViewTreeLayout();
        }
        this.invalidate();
        this.mBackgroundSizeChanged = true;
    }

    @Override
    public Drawable getBackground() {
        return this.mBackground;
    }

    @Override
    public boolean post(Runnable action) {
        return this.viewRoot.post(action);
    }

    @Override
    public boolean postDelayed(Runnable action, long delayMillis) {
        return this.viewRoot.postDelayed(action, delayMillis);
    }

    @Override
    public boolean removeCallbacks(Runnable action) {
        return this.viewRoot.removeCallbacks(action);
    }

    @Override
    public void requestLayoutAll() {
        this.viewRoot.requestLayoutAll();
    }

    @Override
    public void requestFViewTreeLayout() {
        this.viewRoot.requestFViewTreeLayout();
    }

    @Override
    public void requestLayoutThisView() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (FView.this.parent != null) {
                    FView.this.parent.measureChildWithMargins(FView.this, FView.this.parent.getOldWidthMeasureSpec(), 0, FView.this.parent.getOldHeightMeasureSpec(), 0);
                    FView.this.parent.layoutChild(FView.this);
                }
            }
        });
    }

    @Override
    public int getMeasuredWidth() {
        return this.measureWidth;
    }

    @Override
    public int getMeasuredHeight() {
        return this.measureHeight;
    }

    @Override
    public int getWidth() {
        return this.bounds.width();
    }

    @Override
    public int getHeight() {
        return this.bounds.height();
    }

    @Override
    public int getLeft() {
        return this.bounds.left;
    }

    @Override
    public int getTop() {
        return this.bounds.top;
    }

    @Override
    public int getRight() {
        return this.bounds.right;
    }

    @Override
    public int getBottom() {
        return this.bounds.bottom;
    }

    @Override
    public int getPaddingLeft() {
        return this.padding.left;
    }

    @Override
    public int getPaddingTop() {
        return this.padding.top;
    }

    @Override
    public int getPaddingRight() {
        return this.padding.right;
    }

    @Override
    public int getPaddingBottom() {
        return this.padding.bottom;
    }

    @Override
    public void setPadding(int l, int t, int r, int b) {
        this.internalSetPadding(l, t, r, b);
    }

    @Override
    public void getLocationOnScreen(int[] outLocation) {
        this.getLocationInWindow(outLocation);
        if (this.isAttachedToWindow()) {
            int[] windowPos = new int[2];
            ViewUtils.getWindowPosition((View)this.viewRoot, windowPos);
            outLocation[0] = outLocation[0] + windowPos[0];
            outLocation[1] = outLocation[1] + windowPos[1];
        }
    }

    @Override
    public void getLocationInWindow(int[] outLocation) {
        this.transformFromViewToWindowSpace(outLocation);
    }

    protected void transformFromViewToWindowSpace(@Size(value=2L) int[] inOutLocation) {
        if (inOutLocation == null || inOutLocation.length < 2) {
            throw new IllegalArgumentException("inOutLocation must be an array of two integers");
        }
        if (!this.isAttachedToWindow()) {
            inOutLocation[1] = 0;
            inOutLocation[0] = 0;
            return;
        }
        float[] position = new float[]{this.bounds.left, this.bounds.top};
        FViewParent p = this.parent;
        while (p instanceof FView) {
            FView view = (FView)((Object)p);
            position[0] = position[0] + (float)view.bounds.left;
            position[1] = position[1] + (float)view.bounds.top;
            p = view.parent;
        }
        if (p instanceof FViewRootImpl) {
            FViewRootImpl root = (FViewRootImpl)p;
            int[] rootPos = new int[2];
            root.getLocationInWindow(rootPos);
            position[0] = position[0] + (float)rootPos[0];
            position[1] = position[1] + (float)rootPos[1];
        }
        inOutLocation[0] = Math.round(position[0]);
        inOutLocation[1] = Math.round(position[1]);
    }

    private void internalSetPadding(int left, int top, int right, int bottom) {
        boolean changed = this.padding.left != left || this.padding.top != top || this.padding.right != right || this.padding.bottom != bottom;
        this.padding.set(left, top, right, bottom);
        if (changed) {
            this.requestFViewTreeLayout();
        }
    }

    protected boolean isClickable() {
        return this.getFlag(8192) == 8192;
    }

    @Override
    public boolean isTouchInView(float x, float y) {
        if (!this.isClickable() || !this.isEnabled() || this.getVisibility() == 8) {
            return false;
        }
        return this.bounds.contains((int)x, (int)y);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        float y;
        float x = event.getX();
        if (!this.isTouchInView(x, y = event.getY())) {
            return false;
        }
        return this.onTouchEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int action = event.getAction();
        if (!this.isClickable() || !this.isEnabled() || this.getVisibility() == 8) {
            return false;
        }
        switch (action) {
            case 0: {
                this.setPressed(true);
                this.mHasPerformedLongPress = false;
                this.checkForLongClick(0);
                break;
            }
            case 2: {
                if (this.isTouchInView(x, y)) break;
                this.removeLongPressCallback();
                this.setPressed(false);
                break;
            }
            case 3: {
                this.setPressed(false);
                this.removeLongPressCallback();
                this.mHasPerformedLongPress = false;
                break;
            }
            case 1: {
                if (!this.mHasPerformedLongPress) {
                    this.removeLongPressCallback();
                    this.performClick();
                }
                if (this.mUnsetPressedState == null) {
                    this.mUnsetPressedState = new UnsetPressedState();
                }
                if (this.post(this.mUnsetPressedState)) break;
                this.mUnsetPressedState.run();
            }
        }
        return true;
    }

    private void checkForLongClick(int delayOffset) {
        if (this.getFlag(16384) == 16384) {
            this.mHasPerformedLongPress = false;
            if (this.mPendingCheckForLongPress == null) {
                this.mPendingCheckForLongPress = new CheckForLongPress();
            }
            this.postDelayed(this.mPendingCheckForLongPress, ViewConfiguration.getLongPressTimeout() - delayOffset);
        }
    }

    protected void setPressed(boolean pressed) {
        this.removeFlag(32768);
        if (pressed) {
            this.addFlag(32768);
        }
    }

    protected boolean isPressed() {
        return this.getFlag(32768) == 32768;
    }

    public void setClickable(boolean clickable) {
        this.removeFlag(8192);
        if (clickable) {
            this.addFlag(8192);
        }
    }

    @Override
    public void setOnClickListener(IFView.OnClickListener listener) {
        this.listenerInfo.onClickListener = listener;
        if (listener != null) {
            this.setClickable(true);
        }
    }

    public void setLongClickable(boolean clickable) {
        this.removeFlag(16384);
        if (clickable) {
            this.addFlag(16384);
            this.setClickable(true);
        }
    }

    @Override
    public void setOnLongClickListener(IFView.OnLongClickListener listener) {
        this.listenerInfo.onLongClickListener = listener;
        if (listener != null) {
            this.setLongClickable(true);
        }
    }

    protected boolean isAttachedToWindow() {
        return this.getFlag(256) == 256;
    }

    private void addFlag(int mask) {
        this.flag |= mask;
    }

    private int getFlag(int mask) {
        return this.flag & mask;
    }

    private void removeFlag(int mask) {
        this.flag &= ~mask;
    }

    public boolean performClick() {
        if (this.listenerInfo.onClickListener != null) {
            this.listenerInfo.onClickListener.onClick(this);
            return true;
        }
        return false;
    }

    public boolean performLongClick() {
        if (this.listenerInfo.onLongClickListener != null) {
            return this.listenerInfo.onLongClickListener.onLongClick(this);
        }
        return false;
    }

    private void removeLongPressCallback() {
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
    }

    private void removeUnsetPressCallback() {
        if (this.mUnsetPressedState != null) {
            this.removeCallbacks(this.mUnsetPressedState);
            this.setPressed(false);
        }
    }

    public String toString() {
        return this.getClass().getName() + this.hashCode();
    }

    protected void d(String tag, String log) {
        if (DEBUG) {
            Log.d((String)tag, (String)log);
        }
    }

    @CallSuper
    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.mBackground;
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        if (this.verifyDrawable(who)) {
            Rect dirty = Build.VERSION.SDK_INT >= 21 ? who.getDirtyBounds() : who.getBounds();
            this.invalidate(dirty);
        }
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        long delay;
        if (this.verifyDrawable(who) && what != null && this.postDelayed(new WrapperRunnable(who, what), delay = when - SystemClock.uptimeMillis())) {
            this.addAction(who, what);
        }
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        if (this.verifyDrawable(who) && what != null) {
            this.removeCallbacks(what);
            if (what instanceof WrapperRunnable) {
                this.removeCallbacks(((WrapperRunnable)what).action);
            }
            this.removeAction(who, what);
        }
    }

    protected void unscheduleDrawable(Drawable who) {
        ArrayList<Runnable> actions;
        if (who != null && (actions = this.drawableActions.remove(who)) != null) {
            int l = actions.size();
            for (int i = 0; i < l; ++i) {
                Runnable a = actions.get(i);
                this.removeCallbacks(a);
            }
        }
    }

    protected void addAction(@NonNull Drawable who, @NonNull Runnable what) {
        ArrayList<Runnable> actions = this.drawableActions.get(who);
        if (actions == null) {
            actions = new ArrayList();
            this.drawableActions.put(who, actions);
        }
        actions.add(what);
    }

    protected void removeAction(@NonNull Drawable who, @NonNull Runnable what) {
        ArrayList<Runnable> actions = this.drawableActions.get(who);
        if (actions != null) {
            actions.remove(what);
            if (actions.isEmpty()) {
                this.drawableActions.remove(who);
            }
        }
    }

    protected int getSuggestedMinimumHeight() {
        return this.mBackground == null ? 0 : this.mBackground.getMinimumHeight();
    }

    protected int getSuggestedMinimumWidth() {
        return this.mBackground == null ? 0 : this.mBackground.getMinimumWidth();
    }

    class WrapperRunnable
    implements Runnable {
        Runnable action;
        Drawable who;

        WrapperRunnable(Drawable who, Runnable action) {
            this.action = action;
            this.who = who;
        }

        @Override
        public void run() {
            if (this.action != null) {
                this.action.run();
            }
            FView.this.removeAction(this.who, this.action);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == this.action) {
                return true;
            }
            if (obj instanceof WrapperRunnable) {
                return ((WrapperRunnable)obj).action == this.action;
            }
            return false;
        }
    }

    static class ListenerInfo {
        IFView.OnClickListener onClickListener;
        IFView.OnLongClickListener onLongClickListener;

        ListenerInfo() {
        }
    }

    private final class UnsetPressedState
    implements Runnable {
        private UnsetPressedState() {
        }

        @Override
        public void run() {
            FView.this.setPressed(false);
        }
    }

    private final class CheckForLongPress
    implements Runnable {
        private CheckForLongPress() {
        }

        @Override
        public void run() {
            if (FView.this.isPressed() && FView.this.parent != null && FView.this.performLongClick()) {
                FView.this.mHasPerformedLongPress = true;
            }
        }
    }
}

