/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.mapping;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.java.mapping.ClassQNamePair;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.type.Type;

public class CustomTypeMapping
implements TypeMapping {
    private Map types = new HashMap();
    private Map class2Type = new HashMap();
    private Map xml2Type;
    private Map class2xml = new HashMap();
    private TypeMapping defaultTM;
    private String encodingStyleURI;

    public CustomTypeMapping(TypeMapping defaultTM) {
        this();
        this.defaultTM = defaultTM;
    }

    public CustomTypeMapping() {
        this.xml2Type = new HashMap();
    }

    public boolean isRegistered(Class javaType, QName xmlType) {
        ClassQNamePair pair = new ClassQNamePair(javaType, xmlType);
        boolean registered = this.types.containsKey(pair);
        if (!registered && this.defaultTM != null) {
            registered = this.defaultTM.isRegistered(javaType, xmlType);
        }
        return registered;
    }

    public void register(Class javaType, QName xmlType, Type type) {
        type.setTypeClass(javaType);
        type.setSchemaType(xmlType);
        type.setTypeMapping(this);
        ClassQNamePair pair = new ClassQNamePair(javaType, xmlType);
        this.types.put(pair, type);
        this.class2Type.put(javaType, type);
        this.xml2Type.put(xmlType, type);
        this.class2xml.put(javaType, xmlType);
    }

    public Type getType(Class javaType, QName xmlType) {
        ClassQNamePair pair = new ClassQNamePair(javaType, xmlType);
        Type type = (Type)this.types.get(pair);
        if (type == null && this.defaultTM != null) {
            type = this.defaultTM.getType(javaType, xmlType);
        }
        return type;
    }

    public void removeType(Class javaType, QName xmlType) {
        ClassQNamePair pair = new ClassQNamePair(javaType, xmlType);
        Type type = (Type)this.types.get(pair);
        if (type == null && this.defaultTM != null) {
            this.defaultTM.removeType(javaType, xmlType);
        } else {
            this.types.remove(pair);
            this.xml2Type.remove(type);
            this.class2Type.remove(type);
            this.class2xml.remove(xmlType);
        }
    }

    public Type getType(Class javaType) {
        Type type = (Type)this.class2Type.get(javaType);
        if (type == null && this.defaultTM != null) {
            type = this.defaultTM.getType(javaType);
        }
        return type;
    }

    public Type getType(QName xmlType) {
        Type type = (Type)this.xml2Type.get(xmlType);
        if (type == null && this.defaultTM != null) {
            type = this.defaultTM.getType(xmlType);
        }
        return type;
    }

    public QName getTypeQName(Class clazz) {
        QName qname = (QName)this.class2xml.get(clazz);
        if (qname == null && this.defaultTM != null) {
            qname = this.defaultTM.getTypeQName(clazz);
        }
        return qname;
    }

    public String getEncodingStyleURI() {
        return this.encodingStyleURI;
    }

    public void setEncodingStyleURI(String encodingStyleURI) {
        this.encodingStyleURI = encodingStyleURI;
    }
}

