/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.service.SimpleService;
import org.codehaus.xfire.session.Session;

public class DefaultJavaService
extends SimpleService
implements JavaService {
    private TypeMappingRegistry typeMappingRegistry;
    private TypeMapping typeMapping;
    private List allowedMethods = new ArrayList();
    private Class serviceClass;
    private Hashtable operations = new Hashtable();
    protected static final String SERVICE_CLASS = "serviceClass";
    protected static final String ALLOWED_METHODS = "allowedMethods";
    private boolean autoTyped = false;
    private int scope = 1;
    private Object appObj;
    static /* synthetic */ Class class$org$codehaus$xfire$java$DefaultJavaService;

    public void setServiceClass(String className) throws ClassNotFoundException {
        this.serviceClass = this.getClass().getClassLoader().loadClass(className);
        this.initializeOperations();
    }

    private void initializeOperations() {
        Method[] methods = this.serviceClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            int modifiers = method.getModifiers();
            if (!this.isAllowed(methodName) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            this.addOperation(method);
        }
    }

    private void addOperation(Method method) {
        Operation op = new Operation(method, this);
        this.operations.put(method.getName(), op);
    }

    private boolean isAllowed(String methodName) {
        return this.allowedMethods.size() == 0 || this.allowedMethods.contains(methodName);
    }

    public Operation getOperation(String localName, String namespace) {
        return (Operation)this.operations.get(localName);
    }

    public Collection getOperations() {
        return this.operations.values();
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    protected Class loadClass(String className) throws Exception {
        if (className.endsWith("[]")) {
            className = "[L" + className.substring(0, className.length() - 2) + ";";
        }
        return this.getClass().getClassLoader().loadClass(className);
    }

    public void initialize() throws Exception {
        TypeMapping tm = null;
        if (this.getUse() != null) {
            tm = this.getUse().equals("encoded") ? this.getTypeMappingRegistry().createTypeMapping("http://schemas.xmlsoap.org/soap/encoding/", this.autoTyped) : this.getTypeMappingRegistry().createTypeMapping("http://www.w3.org/2001/XMLSchema", this.autoTyped);
            this.setTypeMapping(tm);
            this.getTypeMappingRegistry().register(this.getDefaultNamespace(), tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getServiceObject(MessageContext context) throws XFireFault {
        if (this.scope == 1) {
            if (this.appObj == null) {
                Class clazz = class$org$codehaus$xfire$java$DefaultJavaService == null ? (class$org$codehaus$xfire$java$DefaultJavaService = DefaultJavaService.class$("org.codehaus.xfire.java.DefaultJavaService")) : class$org$codehaus$xfire$java$DefaultJavaService;
                synchronized (clazz) {
                    this.appObj = this.createServiceObject();
                }
            }
            return this.appObj;
        }
        if (this.scope == 2) {
            String key;
            Session session = context.getSession();
            Object sessObj = session.get((Object)(key = "service." + this.getName()));
            if (sessObj == null) {
                Class clazz = class$org$codehaus$xfire$java$DefaultJavaService == null ? (class$org$codehaus$xfire$java$DefaultJavaService = DefaultJavaService.class$("org.codehaus.xfire.java.DefaultJavaService")) : class$org$codehaus$xfire$java$DefaultJavaService;
                synchronized (clazz) {
                    sessObj = this.createServiceObject();
                    session.put((Object)key, sessObj);
                }
            }
            return sessObj;
        }
        if (this.scope == 3) {
            return this.createServiceObject();
        }
        throw new UnsupportedOperationException("Scope " + this.scope + " is invalid.");
    }

    public Object createServiceObject() throws XFireFault {
        try {
            return this.getServiceClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new XFireFault("Couldn't instantiate service object.", (Exception)e, "Receiver");
        }
        catch (IllegalAccessException e) {
            throw new XFireFault("Couldn't access service object.", (Exception)e, "Receiver");
        }
    }

    public boolean isAutoTyped() {
        return this.autoTyped;
    }

    public void setAutoTyped(boolean autoTyped) {
        this.autoTyped = autoTyped;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

