/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.dom.Message;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.message.AbstractMessageBridge;
import org.codehaus.xfire.java.message.LiteralReader;
import org.codehaus.xfire.java.message.LiteralWriter;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class WrappedBridge
extends AbstractMessageBridge {
    private Element payload;

    public WrappedBridge(JavaService service, MessageContext context, Message request, Message response) {
        super(service, context, request, response);
        this.setNamespace(this.getPayload().getNamespaceURI());
        String methodName = this.getPayload().getName();
        this.setOperation(this.getService().getOperation(methodName, this.getNamespace()));
    }

    public Element getPayload() {
        if (this.payload == null) {
            this.payload = (Element)this.getRequest().elements().get(0);
        }
        return this.payload;
    }

    public List read() throws XFireFault {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Iterator itr = this.getPayload().elementIterator();
        while (itr.hasNext()) {
            Element element = (Element)itr.next();
            Operation op = this.getOperation();
            if (op == null) {
                throw new XFireFault("Invalid operation.", "Sender");
            }
            Class clazz = op.getParameterClass(element.getName());
            if (clazz == null) {
                throw new XFireFault("Invalid parameter.", "Sender");
            }
            Type type = this.getTypeMapping().getType(clazz);
            parameters.add(type.readObject(new LiteralReader(element)));
        }
        return parameters;
    }

    public void write(Object value) {
        Namespace responseNS = NamespaceHelper.getNamespace((Element)this.getResponse(), (String)this.getNamespace());
        QName responseQ = new QName(this.getOperation().getName() + "Response", responseNS);
        Element methodResponse = this.getResponse().addElement(responseQ);
        Type type = this.getTypeMapping().getType(value.getClass());
        Namespace ns = null;
        ns = type.isComplex() ? type.getSchemaType().getNamespace() : NamespaceHelper.getNamespace((Element)this.getResponse(), (String)this.getNamespace());
        QName outQ = new QName(this.getOperation().getOutParameterName(), ns);
        Element out = methodResponse.addElement(outQ);
        type.writeObject(value, new LiteralWriter(out));
    }
}

