/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.dom.Message;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.message.AbstractMessageBridge;
import org.codehaus.xfire.java.message.LiteralReader;
import org.codehaus.xfire.java.message.LiteralWriter;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class RPCLiteralBridge
extends AbstractMessageBridge {
    private Element payload;

    public RPCLiteralBridge(JavaService service, MessageContext context, Message request, Message response) {
        super(service, context, request, response);
        this.setNamespace(this.getPayload().getNamespaceURI());
        String methodName = this.getPayload().getName();
        this.setOperation(this.getService().getOperation(methodName, this.getNamespace()));
    }

    public Element getPayload() {
        if (this.payload == null) {
            this.payload = (Element)this.getRequest().elements().get(0);
        }
        return this.payload;
    }

    public List read() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Iterator itr = this.getPayload().elementIterator();
        while (itr.hasNext()) {
            Element element = (Element)itr.next();
            Class clazz = this.operation.getParameterClass(element.getName());
            Type type = this.getTypeMapping().getType(clazz);
            parameters.add(type.readObject(new LiteralReader(element)));
        }
        return parameters;
    }

    public void write(Object value) {
        Namespace ns = NamespaceHelper.getNamespace((Element)this.getResponse(), (String)this.getNamespace());
        QName responseQ = new QName(this.getOperation().getName() + "Response", ns);
        Element methodResponse = this.getResponse().addElement(responseQ);
        QName outQ = new QName("out", ns);
        Element out = methodResponse.addElement(outQ);
        Type type = this.getTypeMapping().getType(value.getClass());
        type.writeObject(value, new LiteralWriter(out));
    }
}

