/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.object;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.codehaus.xfire.fault.FaultHandler;
import org.codehaus.xfire.fault.Soap11FaultHandler;
import org.codehaus.xfire.fault.Soap12FaultHandler;
import org.codehaus.xfire.handler.EndpointHandler;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.message.bridge.ObjectServiceHandler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.object.DefaultObjectService;
import org.codehaus.xfire.service.object.ObjectInvoker;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.SoapHandler;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.type.DefaultTypeMappingRegistry;
import org.codehaus.xfire.type.TypeMapping;
import org.codehaus.xfire.type.TypeMappingRegistry;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.wsdl.ResourceWSDL;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.wsdl11.ObjectServiceVisitor;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;

public class ObjectServiceFactory
implements ServiceFactory {
    private TypeMappingRegistry registry;
    private TransportManager transportManager;

    public ObjectServiceFactory() {
    }

    public ObjectServiceFactory(TransportManager transportManager, TypeMappingRegistry registry) {
        this.registry = null == registry ? new DefaultTypeMappingRegistry(true) : registry;
        this.transportManager = transportManager;
    }

    public Service create(Class clazz, TypeMapping tm, URL wsdlUrl) throws Exception {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        Definition def = reader.readWSDL(wsdlUrl.toString());
        DefaultObjectService service = new DefaultObjectService();
        service.setServiceClass(clazz);
        service.setTypeMapping(tm);
        ObjectServiceVisitor builder = new ObjectServiceVisitor(def, service);
        builder.configure();
        service.setFaultHandler((FaultHandler)new Soap11FaultHandler());
        service.setWSDL((WSDLWriter)new ResourceWSDL(wsdlUrl));
        SoapHandler handler = new SoapHandler((EndpointHandler)new ObjectServiceHandler());
        service.setServiceHandler((Handler)handler);
        service.setInvoker(new ObjectInvoker());
        return service;
    }

    public Service create(Class clazz) {
        return this.create(clazz, null, null, null);
    }

    public Service create(Class clazz, SoapVersion version, String style, String use) {
        return this.create(clazz, null, null, version, style, use, null);
    }

    protected String makeServiceNameFromClassName(Class clazz) {
        String name = clazz.getName();
        int last = name.lastIndexOf(".");
        if (last != -1) {
            name = name.substring(last + 1);
        }
        return name;
    }

    public Service create(Class clazz, String name, String namespace, SoapVersion version, String style, String use, String encodingStyleURI) {
        String theName = name != null ? name : this.makeServiceNameFromClassName(clazz);
        String theNamespace = namespace != null ? namespace : NamespaceHelper.makeNamespaceFromClassName((String)clazz.getName(), (String)"http");
        SoapVersion theVersion = version != null ? version : Soap11.getInstance();
        String theStyle = style != null ? style : "wrapped";
        String theUse = use != null ? use : "literal";
        DefaultObjectService service = new DefaultObjectService();
        service.setName(theName);
        service.setDefaultNamespace(theNamespace);
        service.setServiceClass(clazz);
        service.setSoapVersion(theVersion);
        service.setStyle(theStyle);
        service.setUse(theUse);
        service.setEncodingStyleURI(encodingStyleURI);
        service.setAutoTyped(true);
        if (version instanceof Soap11) {
            service.setFaultHandler((FaultHandler)new Soap11FaultHandler());
        } else {
            service.setFaultHandler((FaultHandler)new Soap12FaultHandler());
        }
        if (this.transportManager != null) {
            service.setWSDLBuilder(new WSDLBuilder(this.transportManager));
        }
        SoapHandler handler = new SoapHandler((EndpointHandler)new ObjectServiceHandler());
        service.setServiceHandler((Handler)handler);
        service.setInvoker(new ObjectInvoker());
        this.initializeTypeMapping(service);
        this.initializeOperations(service);
        return service;
    }

    protected void initializeOperations(DefaultObjectService service) {
        Method[] methods = service.getServiceClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!this.isValidMethod(method)) continue;
            this.addOperation(service, method);
        }
    }

    protected boolean isValidMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    protected void addOperation(DefaultObjectService service, Method method) {
        QName q;
        Operation op = new Operation(method);
        Class<?>[] paramClasses = method.getParameterTypes();
        boolean isDoc = service.getStyle().equals("document");
        for (int j = 0; j < paramClasses.length; ++j) {
            q = new QName(service.getDefaultNamespace(), this.getInParameterName(method, j, isDoc));
            Parameter p = new Parameter(q, paramClasses[j]);
            op.addInParameter(p);
        }
        Class<Void> returnType = method.getReturnType();
        if (!returnType.isAssignableFrom(Void.TYPE)) {
            q = new QName(service.getDefaultNamespace(), this.getOutParameterName(method, isDoc));
            Parameter outP = new Parameter(q, method.getReturnType());
            op.addOutParameter(outP);
        }
        op.setAsync(this.isAsync(method));
        service.addOperation(op);
    }

    protected boolean isAsync(Method method) {
        return false;
    }

    protected String getInParameterName(Method method, int paramNumber, boolean doc) {
        String paramName = "";
        if (doc) {
            paramName = method.getName();
        }
        return paramName + "in" + paramNumber;
    }

    protected String getOutParameterName(Method method, boolean doc) {
        String outName = "";
        if (doc) {
            outName = method.getName();
        }
        return outName + "out";
    }

    protected void initializeTypeMapping(DefaultObjectService service) {
        String encodingStyle = service.getEncodingStyleURI();
        if (encodingStyle == null) {
            encodingStyle = service.getUse().equals("encoded") ? service.getSoapVersion().getSoapEncodingStyle() : "http://www.w3.org/2001/XMLSchema";
        }
        service.setEncodingStyleURI(encodingStyle);
        TypeMapping tm = this.registry.createTypeMapping(encodingStyle, service.isAutoTyped());
        service.setTypeMapping(tm);
        this.registry.register(service.getDefaultNamespace(), tm);
    }
}

