/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.object;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.fault.FaultHandler;
import org.codehaus.xfire.fault.Soap11FaultHandler;
import org.codehaus.xfire.fault.Soap12FaultHandler;
import org.codehaus.xfire.handler.EndpointHandler;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.handler.SoapHandler;
import org.codehaus.xfire.message.ObjectServiceHandler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.object.DefaultObjectService;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.service.object.ServiceBuilder;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.type.DefaultTypeMappingRegistry;
import org.codehaus.xfire.type.TypeMapping;
import org.codehaus.xfire.type.TypeMappingRegistry;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.wsdl.ResourceWSDL;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.wsdl11.ObjectServiceVisitor;
import org.codehaus.xfire.wsdl11.builder.JavaWSDLBuilder;

public class ObjectServiceBuilder
implements ServiceBuilder {
    private TypeMappingRegistry registry;
    private XFire xfire;
    private Class invokerClass;
    private Class messageBridgeClass;

    public ObjectServiceBuilder() {
        this.registry = new DefaultTypeMappingRegistry(true);
    }

    public ObjectServiceBuilder(XFire xfire) {
        this.registry = new DefaultTypeMappingRegistry(true);
        this.xfire = xfire;
    }

    public ObjectServiceBuilder(XFire xfire, TypeMappingRegistry registry) {
        this.registry = registry;
        this.xfire = xfire;
    }

    public Service create(Class clazz, TypeMapping tm, URL wsdlUrl) throws Exception {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        Definition def = reader.readWSDL(wsdlUrl.toString());
        DefaultObjectService service = new DefaultObjectService();
        service.setServiceClass(clazz);
        service.setTypeMapping(tm);
        ObjectServiceVisitor builder = new ObjectServiceVisitor(def, service);
        builder.configure();
        service.setFaultHandler((FaultHandler)new Soap11FaultHandler());
        service.setWSDL((WSDLWriter)new ResourceWSDL(wsdlUrl));
        SoapHandler handler = new SoapHandler((EndpointHandler)new ObjectServiceHandler());
        service.setServiceHandler((Handler)handler);
        this.xfire.getServiceRegistry().register((Service)service);
        return service;
    }

    public Service create(Class clazz) {
        return this.create(clazz, (SoapVersion)Soap11.getInstance(), "wrapped", "literal");
    }

    public Service create(Class clazz, SoapVersion version, String style, String use) {
        String name = clazz.getName();
        int last = name.lastIndexOf(".");
        if (last != -1) {
            name = name.substring(last + 1);
        }
        String ns = NamespaceHelper.makeNamespaceFromClassName((String)clazz.getName(), (String)"http");
        return this.create(clazz, name, ns, version, style, use);
    }

    public Service create(Class clazz, String name, String namespace, SoapVersion version, String style, String use) {
        DefaultObjectService service = new DefaultObjectService();
        service.setName(name);
        service.setDefaultNamespace(namespace);
        service.setServiceClass(clazz);
        service.setSoapVersion(version);
        service.setStyle(style);
        service.setUse(use);
        service.setAutoTyped(true);
        if (version instanceof Soap11) {
            service.setFaultHandler((FaultHandler)new Soap11FaultHandler());
        } else {
            service.setFaultHandler((FaultHandler)new Soap12FaultHandler());
        }
        if (this.xfire != null) {
            service.setWSDLBuilder(new JavaWSDLBuilder(this.xfire.getTransportManager()));
        }
        SoapHandler handler = new SoapHandler((EndpointHandler)new ObjectServiceHandler());
        service.setServiceHandler((Handler)handler);
        this.initializeTypeMapping(service);
        this.initializeOperations(service);
        if (this.xfire != null) {
            this.xfire.getServiceRegistry().register((Service)service);
        }
        return service;
    }

    protected void initializeOperations(DefaultObjectService service) {
        Method[] methods = service.getServiceClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            this.addOperation(service, method);
        }
    }

    protected void addOperation(DefaultObjectService service, Method method) {
        QName q;
        Operation op = new Operation(method);
        Class<?>[] paramClasses = method.getParameterTypes();
        boolean isDoc = service.getStyle().equals("document");
        TypeMapping mapping = service.getTypeMapping();
        for (int j = 0; j < paramClasses.length; ++j) {
            String paramName = "";
            if (isDoc) {
                paramName = method.getName();
            }
            paramName = paramName + "in" + j;
            q = new QName(service.getDefaultNamespace(), paramName);
            Parameter p = new Parameter(q, paramClasses[j]);
            op.addInParameter(p);
        }
        Class<Void> returnType = method.getReturnType();
        if (!returnType.isAssignableFrom(Void.TYPE)) {
            String outName = "";
            if (isDoc) {
                outName = method.getName();
            }
            q = new QName(service.getDefaultNamespace(), outName + "out");
            Parameter outP = new Parameter(q, method.getReturnType());
            op.addOutParameter(outP);
        }
        service.addOperation(op);
    }

    protected void initializeTypeMapping(DefaultObjectService service) {
        String encodingStyle = service.getEncodingStyleURI();
        if (encodingStyle == null) {
            encodingStyle = service.getUse().equals("encoded") ? service.getSoapVersion().getSoapEncodingStyle() : "http://www.w3.org/2001/XMLSchema";
        }
        service.setEncodingStyleURI(encodingStyle);
        TypeMapping tm = this.registry.createTypeMapping(encodingStyle, service.isAutoTyped());
        service.setTypeMapping(tm);
        this.registry.register(service.getDefaultNamespace(), tm);
    }
}

