/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;
import sax.helpers.AttributesImpl;

public class Writer
extends DefaultHandler
implements LexicalHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;
    protected Locator fLocator;
    protected boolean fXML11;
    protected boolean fInCDATA;

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
        this.fElementDepth = 0;
        this.fXML11 = false;
        this.fInCDATA = false;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.fElementDepth > 0) {
            this.fOut.print("<?");
            this.fOut.print(string);
            if (string2 != null && string2.length() > 0) {
                this.fOut.print(' ');
                this.fOut.print(string2);
            }
            this.fOut.print("?>");
            this.fOut.flush();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.fElementDepth == 0) {
            if (this.fLocator != null) {
                this.fXML11 = "1.1".equals(this.getVersion());
                this.fLocator = null;
            }
            if (!this.fCanonical) {
                if (this.fXML11) {
                    this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                } else {
                    this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                this.fOut.flush();
            }
        }
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(string3);
        if (attributes != null) {
            attributes = this.sortAttributes(attributes);
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.fOut.print(' ');
                this.fOut.print(attributes.getQName(n2));
                this.fOut.print("=\"");
                this.normalizeAndPrint(attributes.getValue(n2), true);
                this.fOut.print('\"');
                ++n2;
            }
        }
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fInCDATA) {
            this.normalizeAndPrint(cArray, n, n2, false);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                this.fOut.print(cArray[n + n3]);
                ++n3;
            }
        }
        this.fOut.flush();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
        this.fOut.flush();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(string3);
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fOut.print("<![CDATA[");
            this.fInCDATA = true;
        }
    }

    public void endCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fInCDATA = false;
            this.fOut.print("]]>");
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fCanonical && this.fElementDepth > 0) {
            this.fOut.print("<!--");
            int n3 = 0;
            while (n3 < n2) {
                this.fOut.print(cArray[n + n3]);
                ++n3;
            }
            this.fOut.print("-->");
            this.fOut.flush();
        }
    }

    protected Attributes sortAttributes(Attributes attributes) {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = attributes != null ? attributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getQName(n2);
            int n3 = attributesImpl.getLength();
            int n4 = 0;
            while (n4 < n3) {
                if (string.compareTo(attributesImpl.getQName(n4)) < 0) break;
                ++n4;
            }
            attributesImpl.insertAttributeAt(n4, string, attributes.getType(n2), attributes.getValue(n2));
            ++n2;
        }
        return attributesImpl;
    }

    protected void normalizeAndPrint(String string, boolean bl) {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c, bl);
            ++n2;
        }
    }

    protected void normalizeAndPrint(char[] cArray, int n, int n2, boolean bl) {
        int n3 = 0;
        while (n3 < n2) {
            this.normalizeAndPrint(cArray[n + n3], bl);
            ++n3;
        }
    }

    protected void normalizeAndPrint(char c, boolean bl) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (bl) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || bl && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected String getVersion() {
        if (this.fLocator == null) {
            return null;
        }
        String string = null;
        Method method = null;
        try {
            method = this.fLocator.getClass().getMethod("getXMLVersion", new Class[0]);
            if (method != null) {
                string = (String)method.invoke((Object)this.fLocator, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = false;
        var6_6 = true;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = false;
        var11_11 = 0;
        while (var11_11 < var0.length) {
            block57: {
                var12_12 = var0[var11_11];
                if (!var12_12.startsWith("-")) ** GOTO lbl-1000
                var13_13 = var12_12.substring(1);
                if (var13_13.equals("p")) {
                    if (++var11_11 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var14_25 = var0[var11_11];
                    try {
                        var2_2 = XMLReaderFactory.createXMLReader((String)var14_25);
                    }
                    catch (Exception var15_32) {
                        try {
                            var16_33 = ParserFactory.makeParser((String)var14_25);
                            var2_2 = new ParserAdapter(var16_33);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception var16_34) {
                            var2_2 = null;
                            System.err.println("error: Unable to instantiate parser (" + (String)var14_25 + ")");
                            var15_32.printStackTrace(System.err);
                        }
                    }
                } else if (var13_13.equalsIgnoreCase("n")) {
                    var3_3 = var13_13.equals("n");
                } else if (var13_13.equalsIgnoreCase("np")) {
                    var4_4 = var13_13.equals("np");
                } else if (var13_13.equalsIgnoreCase("v")) {
                    var5_5 = var13_13.equals("v");
                } else if (var13_13.equalsIgnoreCase("xd")) {
                    var6_6 = var13_13.equals("xd");
                } else if (var13_13.equalsIgnoreCase("s")) {
                    var7_7 = var13_13.equals("s");
                } else if (var13_13.equalsIgnoreCase("f")) {
                    var8_8 = var13_13.equals("f");
                } else if (var13_13.equalsIgnoreCase("dv")) {
                    var9_9 = var13_13.equals("dv");
                } else if (var13_13.equalsIgnoreCase("c")) {
                    var10_10 = var13_13.equals("c");
                } else if (var13_13.equals("h")) {
                    Writer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var2_2 == null) {
                        try {
                            var2_2 = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                        }
                        catch (Exception var13_14) {
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                            var13_14.printStackTrace(System.err);
                            break block57;
                        }
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/namespaces", var3_3);
                    }
                    catch (SAXException var13_15) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/namespace-prefixes", var4_4);
                    }
                    catch (SAXException var13_16) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/validation", var5_5);
                    }
                    catch (SAXException var13_17) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", var6_6);
                    }
                    catch (SAXNotRecognizedException var13_18) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
                    }
                    catch (SAXNotSupportedException var14_26) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema", var7_7);
                    }
                    catch (SAXNotRecognizedException var13_19) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema)");
                    }
                    catch (SAXNotSupportedException var14_27) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var8_8);
                    }
                    catch (SAXNotRecognizedException var13_20) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    catch (SAXNotSupportedException var14_28) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/dynamic", var9_9);
                    }
                    catch (SAXNotRecognizedException var13_21) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    catch (SAXNotSupportedException var14_29) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    if (var1_1 == null) {
                        var1_1 = new Writer();
                        try {
                            var1_1.setOutput(System.out, "UTF8");
                        }
                        catch (UnsupportedEncodingException var13_22) {
                            System.err.println("error: Unable to set output. Exiting.");
                            System.exit(1);
                        }
                    }
                    var2_2.setContentHandler(var1_1);
                    var2_2.setErrorHandler(var1_1);
                    try {
                        var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", var1_1);
                    }
                    catch (SAXException var13_23) {
                        // empty catch block
                    }
                    var1_1.setCanonical(var10_10);
                    try {
                        var2_2.parse(var12_12);
                    }
                    catch (SAXParseException var13_24) {
                    }
                    catch (Exception var14_30) {
                        System.err.println("error: Parse error occurred - " + var14_30.getMessage());
                        if (var14_30 instanceof SAXException && (var15_31 = ((SAXException)var14_30).getException()) != null) {
                            var14_25 = var15_31;
                        }
                        var14_25.printStackTrace(System.err);
                    }
                }
            }
            ++var11_11;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -n | -N     Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v | -V     Turn on/off validation.");
        System.err.println("  -xd | -XD   Turn on/off loading of external DTDs.");
        System.err.println("              NOTE: Always on when -v in use and not supported by all parsers.");
        System.err.println("  -s | -S     Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -c | -C     Turn on/off Canonical XML output.");
        System.err.println("              NOTE: This is not W3C canonical output.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Load External DTD: ");
        System.err.println("on");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  Canonical:  ");
        System.err.println("off");
    }
}

