/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class DocumentTracer
extends DefaultHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler,
DocumentHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected PrintWriter fOut;
    protected int fIndent;

    public DocumentTracer() {
        this.setOutput(new PrintWriter(System.out));
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setDocumentLocator(Locator locator) {
        this.printIndent();
        this.fOut.print("setDocumentLocator(");
        this.fOut.print("locator=");
        this.fOut.print(locator);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startDocument() throws SAXException {
        this.fIndent = 0;
        this.printIndent();
        this.fOut.println("startDocument()");
        this.fOut.flush();
        ++this.fIndent;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("processingInstruction(");
        this.fOut.print("target=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("data=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("characters(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("ignorableWhitespace(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endDocument() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endDocument()");
        this.fOut.flush();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("startPrefixMapping(");
        this.fOut.print("prefix=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("uri=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.printIndent();
        this.fOut.print("startElement(");
        this.fOut.print("uri=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("localName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("qname=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (attributes == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    this.fOut.print(',');
                }
                String string4 = attributes.getLocalName(n2);
                String string5 = attributes.getQName(n2);
                String string6 = attributes.getURI(n2);
                String string7 = attributes.getType(n2);
                String string8 = attributes.getValue(n2);
                this.fOut.print('{');
                this.fOut.print("uri=");
                this.printQuotedString(string6);
                this.fOut.print(',');
                this.fOut.print("localName=");
                this.printQuotedString(string4);
                this.fOut.print(',');
                this.fOut.print("qname=");
                this.printQuotedString(string5);
                this.fOut.print(',');
                this.fOut.print("type=");
                this.printQuotedString(string7);
                this.fOut.print(',');
                this.fOut.print("value=");
                this.printQuotedString(string8);
                this.fOut.print('}');
                ++n2;
            }
            this.fOut.print('}');
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("uri=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("localName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("qname=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("endPrefixMapping(");
        this.fOut.print("prefix=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void skippedEntity(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("skippedEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.printIndent();
        this.fOut.print("startElement(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (attributeList == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = attributeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    System.out.print(',');
                }
                String string2 = attributeList.getName(n2);
                String string3 = attributeList.getType(n2);
                String string4 = attributeList.getValue(n2);
                this.fOut.print('{');
                this.fOut.print("name=");
                this.printQuotedString(string2);
                this.fOut.print(',');
                this.fOut.print("type=");
                this.printQuotedString(string3);
                this.fOut.print(',');
                this.fOut.print("value=");
                this.printQuotedString(string4);
                this.fOut.print('}');
                ++n2;
            }
            this.fOut.print('}');
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endElement(String string) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("notationDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.printIndent();
        this.fOut.print("unparsedEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("notationName=");
        this.printQuotedString(string4);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("startDTD(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void startEntity(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("startEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void startCDATA() throws SAXException {
        this.printIndent();
        this.fOut.println("startCDATA()");
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endCDATA() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endCDATA()");
        this.fOut.flush();
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("comment(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endEntity(String string) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
    }

    public void endDTD() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endDTD()");
        this.fOut.flush();
    }

    public void elementDecl(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("elementDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("contentModel=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.printIndent();
        this.fOut.print("attributeDecl(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("attributeName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("type=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("valueDefault=");
        this.printQuotedString(string4);
        this.fOut.print(',');
        this.fOut.print("value=");
        this.printQuotedString(string5);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("internalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("text=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("externalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    protected void printQuotedString(String string) {
        if (string == null) {
            this.fOut.print("null");
            return;
        }
        this.fOut.print('\"');
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c);
            ++n2;
        }
        this.fOut.print('\"');
    }

    protected void printQuotedString(char[] cArray, int n, int n2) {
        this.fOut.print('\"');
        int n3 = 0;
        while (n3 < n2) {
            this.normalizeAndPrint(cArray[n + n3]);
            ++n3;
        }
        this.fOut.print('\"');
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '\n': {
                this.fOut.print("\\n");
                break;
            }
            case '\r': {
                this.fOut.print("\\r");
                break;
            }
            case '\t': {
                this.fOut.print("\\t");
                break;
            }
            case '\\': {
                this.fOut.print("\\\\");
                break;
            }
            case '\"': {
                this.fOut.print("\\\"");
                break;
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void printIndent() {
        int n = 0;
        while (n < this.fIndent) {
            this.fOut.print(' ');
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Exception {
        if (var0.length == 0) {
            DocumentTracer.printUsage();
            System.exit(1);
        }
        var1_1 = new DocumentTracer();
        var2_2 = new PrintWriter(System.out);
        var3_3 = null;
        var4_4 = true;
        var5_5 = false;
        var6_6 = false;
        var7_7 = true;
        var8_8 = false;
        var9_9 = false;
        var10_10 = false;
        var11_11 = 0;
        while (var11_11 < var0.length) {
            block56: {
                var12_12 = var0[var11_11];
                if (!var12_12.startsWith("-")) ** GOTO lbl-1000
                var13_13 = var12_12.substring(1);
                if (var13_13.equals("p")) {
                    if (++var11_11 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var14_25 = var0[var11_11];
                    try {
                        var3_3 = XMLReaderFactory.createXMLReader((String)var14_25);
                    }
                    catch (Exception var15_32) {
                        try {
                            var16_33 = ParserFactory.makeParser((String)var14_25);
                            var3_3 = new ParserAdapter(var16_33);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception var16_34) {
                            var3_3 = null;
                            System.err.println("error: Unable to instantiate parser (" + (String)var14_25 + ")");
                        }
                    }
                } else if (var13_13.equalsIgnoreCase("n")) {
                    var4_4 = var13_13.equals("n");
                } else if (var13_13.equalsIgnoreCase("np")) {
                    var5_5 = var13_13.equals("np");
                } else if (var13_13.equalsIgnoreCase("v")) {
                    var6_6 = var13_13.equals("v");
                } else if (var13_13.equalsIgnoreCase("xd")) {
                    var7_7 = var13_13.equals("xd");
                } else if (var13_13.equalsIgnoreCase("s")) {
                    var8_8 = var13_13.equals("s");
                } else if (var13_13.equalsIgnoreCase("f")) {
                    var9_9 = var13_13.equals("f");
                } else if (var13_13.equalsIgnoreCase("dv")) {
                    var10_10 = var13_13.equals("dv");
                } else if (var13_13.equals("h")) {
                    DocumentTracer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var3_3 == null) {
                        try {
                            var3_3 = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                        }
                        catch (Exception var13_14) {
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                            break block56;
                        }
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/namespaces", var4_4);
                    }
                    catch (SAXException var13_15) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/namespace-prefixes", var5_5);
                    }
                    catch (SAXException var13_16) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/validation", var6_6);
                    }
                    catch (SAXException var13_17) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", var7_7);
                    }
                    catch (SAXNotRecognizedException var13_18) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
                    }
                    catch (SAXNotSupportedException var14_26) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema", var8_8);
                    }
                    catch (SAXNotRecognizedException var13_19) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema)");
                    }
                    catch (SAXNotSupportedException var14_27) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var9_9);
                    }
                    catch (SAXNotRecognizedException var13_20) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    catch (SAXNotSupportedException var14_28) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/dynamic", var10_10);
                    }
                    catch (SAXNotRecognizedException var13_21) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    catch (SAXNotSupportedException var14_29) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    var3_3.setDTDHandler(var1_1);
                    var3_3.setErrorHandler(var1_1);
                    if (var3_3 instanceof XMLReader) {
                        var3_3.setContentHandler(var1_1);
                        try {
                            var3_3.setProperty("http://xml.org/sax/properties/declaration-handler", var1_1);
                        }
                        catch (SAXException var13_22) {
                            var13_22.printStackTrace(System.err);
                        }
                        try {
                            var3_3.setProperty("http://xml.org/sax/properties/lexical-handler", var1_1);
                        }
                        catch (SAXException var13_23) {
                            var13_23.printStackTrace(System.err);
                        }
                    } else {
                        ((Parser)var3_3).setDocumentHandler(var1_1);
                    }
                    try {
                        var3_3.parse(var12_12);
                    }
                    catch (SAXParseException var13_24) {
                    }
                    catch (Exception var14_30) {
                        System.err.println("error: Parse error occurred - " + var14_30.getMessage());
                        if (var14_30 instanceof SAXException && (var15_31 = ((SAXException)var14_30).getException()) != null) {
                            var14_25 = var15_31;
                        }
                        var14_25.printStackTrace(System.err);
                    }
                }
            }
            ++var11_11;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.DocumentTracer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -n | -N     Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v | -V     Turn on/off validation.");
        System.err.println("  -xd | -XD   Turn on/off loading of external DTDs.");
        System.err.println("              NOTE: Always on when -v in use and not supported by all parsers.");
        System.err.println("  -s | -S     Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Load External DTD: ");
        System.err.println("on");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
    }
}

