/*
 * Decompiled with CFR 0.152.
 */
package servlet;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.objects.XString;
import org.xml.sax.SAXException;
import servlet.ApplyXSLTException;
import servlet.ApplyXSLTListener;
import servlet.ApplyXSLTProperties;
import servlet.DefaultApplyXSLTProperties;
import servlet.OrderedProps;

public class ApplyXSLT
extends HttpServlet {
    protected ApplyXSLTProperties ourDefaultParameters = null;
    private boolean useDefaultTemplates = false;
    private Templates defaultTemplates = null;
    public static final String EOL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final String ROOT = System.getProperty("server.root");
    public static String CURRENTDIR;
    protected OrderedProps ourMediaProps = null;
    protected static final String STYLESHEET_ATTRIBUTE = "media";
    protected static final String HEADER_NAME = "user-Agent";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CURRENTDIR = ROOT != null ? ROOT + FS + "servlets" + FS : System.getProperty("user.dir") + FS;
        this.setDefaultParameters(config);
        this.setMediaProps(config.getInitParameter("mediaURL"));
        String defaultXSL = config.getInitParameter("xslURL");
        try {
            if (defaultXSL != null && defaultXSL.length() > 0) {
                this.compileXSL(defaultXSL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void compileXSL(String defaultXSL) throws TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        this.defaultTemplates = tFactory.newTemplates(new StreamSource(defaultXSL));
        this.useDefaultTemplates = true;
    }

    protected void setDefaultParameters(ServletConfig config) {
        this.ourDefaultParameters = new DefaultApplyXSLTProperties(config);
    }

    protected void setMediaProps(String mediaURLstring) {
        if (mediaURLstring != null) {
            URL url = null;
            try {
                url = new URL(mediaURLstring);
            }
            catch (MalformedURLException mue1) {
                try {
                    url = new URL("file", "", CURRENTDIR + mediaURLstring);
                }
                catch (MalformedURLException mue2) {
                    this.writeLog("Unable to find the media properties file based on parameter 'mediaURL' = " + mediaURLstring, 202, mue2);
                    url = null;
                }
            }
            if (url != null) {
                try {
                    this.ourMediaProps = new OrderedProps(url.openStream());
                }
                catch (IOException ioe1) {
                    this.writeLog("Exception occurred while opening media properties file: " + mediaURLstring + ".  Media table may be invalid.", 202, ioe1);
                }
            }
        } else {
            String defaultProp = CURRENTDIR + "media.properties";
            try {
                this.ourMediaProps = new OrderedProps(new FileInputStream(defaultProp));
            }
            catch (IOException ioe2) {
                this.writeLog("Default media properties file " + defaultProp + " not found.", 202, ioe2);
            }
        }
    }

    public String getMedia(HttpServletRequest request) {
        return this.ourMediaProps.getValue(request.getHeader(HEADER_NAME));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            this.process(tFactory, request, response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void process(TransformerFactory tFactory, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SAXException {
        boolean debug = this.ourDefaultParameters.isDebug(request);
        long time = 0L;
        if (debug) {
            time = System.currentTimeMillis();
        }
        ApplyXSLTListener listener = new ApplyXSLTListener();
        listener.out.println("debug is " + debug);
        Source xmlSource = null;
        Source xslSource = null;
        try {
            xmlSource = this.getDocument(request, listener);
            if (xmlSource == null) {
                throw new ApplyXSLTException("getDocument() returned null", new NullPointerException(), 404);
            }
        }
        catch (ApplyXSLTException axe) {
            axe.appendMessage(EOL + "getDocument() resulted in ApplyXSLTException" + EOL + listener.getMessage());
            if (debug) {
                this.writeLog(axe);
            }
            this.displayException(response, axe, debug);
            xmlSource = null;
        }
        if (xmlSource != null) {
            block31: {
                try {
                    xslSource = this.getStylesheet(tFactory, request, xmlSource, listener);
                    if (xslSource == null) {
                        throw new ApplyXSLTException("getStylesheet() returned null", new NullPointerException(), 404);
                    }
                    xmlSource = this.getDocument(request, listener);
                }
                catch (ApplyXSLTException axe) {
                    axe.appendMessage(EOL + "getStylesheet() resulted in ApplyXSLTException" + EOL + listener.getMessage());
                    if (debug) {
                        this.writeLog(axe);
                    }
                    this.displayException(response, axe, debug);
                    xslSource = null;
                }
                if (this.useDefaultTemplates) {
                    try {
                        listener.out.println("Using default templates");
                        if (this.defaultTemplates == null) {
                            listener.out.println("Must recompile default templates");
                            this.defaultTemplates = tFactory.newTemplates(xslSource);
                        }
                        Transformer transformer = this.defaultTemplates.newTransformer();
                        String contentType = null;
                        contentType = this.getContentType(this.defaultTemplates);
                        if (contentType != null) {
                            // empty if block
                        }
                        response.setContentType(contentType);
                        if (transformer instanceof TransformerImpl) {
                            TransformerImpl transformerImpl = (TransformerImpl)transformer;
                            transformerImpl.setQuietConflictWarnings(this.ourDefaultParameters.isNoCW(request));
                        }
                        this.setStylesheetParams(transformer, request);
                        transformer.transform(xmlSource, new StreamResult((OutputStream)response.getOutputStream()));
                        if (debug) {
                            this.writeLog(listener.getMessage(), 200);
                        }
                    }
                    catch (Exception exc) {
                        ApplyXSLTException axe = new ApplyXSLTException("Exception occurred during Transformation:" + EOL + listener.getMessage() + EOL + exc.getMessage(), exc, 500);
                        if (debug) {
                            this.writeLog(axe);
                        }
                        this.displayException(response, axe, debug);
                    }
                } else if (xmlSource != null && xslSource != null) {
                    try {
                        listener.out.println("Performing transformation...");
                        Templates templates = tFactory.newTemplates(xslSource);
                        Transformer transformer = templates.newTransformer();
                        try {
                            block32: {
                                try {
                                    String contentType = null;
                                    contentType = this.getContentType(templates);
                                    if (contentType != null) {
                                        // empty if block
                                    }
                                    response.setContentType(contentType);
                                    if (transformer instanceof TransformerImpl) {
                                        TransformerImpl transformerImpl = (TransformerImpl)transformer;
                                        transformerImpl.setQuietConflictWarnings(this.ourDefaultParameters.isNoCW(request));
                                    }
                                    this.setStylesheetParams(transformer, request);
                                    transformer.transform(xmlSource, new StreamResult((OutputStream)response.getOutputStream()));
                                    if (!debug) break block32;
                                    this.writeLog(listener.getMessage(), 200);
                                }
                                catch (Exception exc) {
                                    ApplyXSLTException axe = new ApplyXSLTException("Exception occurred during Transformation:" + EOL + listener.getMessage() + EOL + exc.getMessage(), exc, 500);
                                    if (debug) {
                                        this.writeLog(axe);
                                    }
                                    this.displayException(response, axe, debug);
                                    Object var15_24 = null;
                                    break block31;
                                }
                            }
                            Object var15_23 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_25 = null;
                            throw throwable;
                        }
                    }
                    catch (Exception saxExc) {
                        ApplyXSLTException axe = new ApplyXSLTException("Exception occurred during ctor/Transformation:" + EOL + listener.getMessage() + EOL + saxExc.getMessage(), saxExc, 500);
                        if (debug) {
                            this.writeLog(axe);
                        }
                        this.displayException(response, axe, debug);
                    }
                }
            }
            if (debug) {
                time = System.currentTimeMillis() - time;
                this.writeLog("  No Conflict Warnings = " + this.ourDefaultParameters.isNoCW(request) + "  Transformation time: " + time + " ms", 200);
            }
        }
    }

    protected Source getDocument(HttpServletRequest request, ApplyXSLTListener listener) throws ApplyXSLTException {
        try {
            String xmlURL = null;
            xmlURL = request.getPathInfo();
            if (xmlURL != null) {
                listener.out.println("Parsing XML Document from PathInfo: " + xmlURL);
                return new StreamSource(new URL("http", ((DefaultApplyXSLTProperties)this.ourDefaultParameters).getLocalHost(), xmlURL.replace('\\', '/')).openStream());
            }
            xmlURL = this.ourDefaultParameters.getXMLurl(request);
            if (xmlURL != null) {
                listener.out.println("Parsing XML Document from request parameter: " + xmlURL);
                return new StreamSource(new URL(xmlURL).openStream());
            }
            String contentType = request.getContentType();
            if (contentType != null && contentType.startsWith("text/xml")) {
                listener.out.println("Parsing XML Document from request chain");
                return new StreamSource((InputStream)request.getInputStream());
            }
        }
        catch (IOException ioe) {
            throw new ApplyXSLTException(ioe, 404);
        }
        catch (Exception e) {
            throw new ApplyXSLTException(e, 500);
        }
        return null;
    }

    protected Source getStylesheet(TransformerFactory tFactory, HttpServletRequest request, Source xmlSource, ApplyXSLTListener listener) throws ApplyXSLTException {
        try {
            String xslURL = ((DefaultApplyXSLTProperties)this.ourDefaultParameters).getXSLRequestURL(request);
            if (xslURL != null) {
                listener.out.println("Parsing XSL Stylesheet Document from request parameter: " + xslURL);
                this.useDefaultTemplates = false;
            } else {
                SAXTransformerFactory stf = (SAXTransformerFactory)tFactory;
                Source styleSource = stf.getAssociatedStylesheet(xmlSource, this.getMedia(request), null, null);
                if (styleSource != null) {
                    listener.out.println("Parsing XSL Stylesheet from XML document stylesheet PI.");
                    this.useDefaultTemplates = false;
                    return styleSource;
                }
                xslURL = this.ourDefaultParameters.getXSLurl(null);
                if (xslURL != null) {
                    listener.out.println("Parsing XSL Stylesheet Document from configuration: " + xslURL);
                    this.useDefaultTemplates = true;
                }
            }
            return new StreamSource(xslURL);
        }
        catch (IOException ioe) {
            throw new ApplyXSLTException(ioe, 404);
        }
        catch (Exception e) {
            throw new ApplyXSLTException(e, 500);
        }
    }

    public String getContentType(Templates templates) {
        String media;
        Properties oprops = templates.getOutputProperties();
        String method = oprops.getProperty("method");
        if (method == null) {
            method = "xml";
        }
        Properties defoprops = null;
        defoprops = method.equals("html") ? OutputProperties.getDefaultMethodProperties((String)"html") : (method.equals("text") ? OutputProperties.getDefaultMethodProperties((String)"text") : OutputProperties.getDefaultMethodProperties((String)"xml"));
        String encoding = oprops.getProperty("encoding");
        if (encoding == null) {
            encoding = defoprops.getProperty("encoding");
        }
        if ((media = oprops.getProperty("media-type")) == null) {
            media = defoprops.getProperty("media-type");
        }
        return media + "; charset=" + encoding;
    }

    public void setStylesheetParams(Transformer transformer, HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            try {
                String[] paramVals = request.getParameterValues(paramName);
                if (paramVals == null) continue;
                transformer.setParameter(paramName, new XString(paramVals[0]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            transformer.setParameter("servlet-RemoteAddr", new XString(request.getRemoteAddr()));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            transformer.setParameter("servlet-RemoteHost", new XString(request.getRemoteHost()));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            transformer.setParameter("servlet-RemoteUser", new XString(request.getRemoteUser()));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void writeLog(ApplyXSLTException axe) {
        this.writeLog(axe.getMessage(), axe.getStatusCode(), axe.getException());
    }

    protected void writeLog(String msg, int statusCode, Throwable t) {
        if (t == null) {
            this.writeLog(msg, statusCode);
        } else {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes, true);
            System.out.println("Exception is " + t.getClass().getName());
            t.printStackTrace(writer);
            this.log("HTTP Status Code: " + statusCode + " - " + msg + EOL + bytes.toString());
        }
    }

    protected void writeLog(String msg, int statusCode) {
        this.log("HTTP Status Code: " + statusCode + " - " + msg);
    }

    protected void displayException(HttpServletResponse response, ApplyXSLTException xse, boolean debug) {
        String mesg = xse.getMessage();
        mesg = mesg == null ? "" : "<B>" + mesg + "</B>";
        StringTokenizer tokens = new StringTokenizer(mesg, EOL);
        StringBuffer strBuf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            strBuf.append(tokens.nextToken() + EOL + "<BR>");
        }
        mesg = strBuf.toString();
        if (debug) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes, true);
            xse.getException().printStackTrace(writer);
            mesg = mesg + " <PRE> " + bytes.toString() + " </PRE> ";
        }
        response.setContentType("text/html");
        try {
            response.sendError(xse.getStatusCode(), mesg);
        }
        catch (IOException ioe) {
            System.err.println("IOException is occurring when sendError is called");
        }
    }

    protected URLConnection toAcceptLanguageConnection(URL url, HttpServletRequest request) throws Exception {
        URLConnection tempConnection = url.openConnection();
        tempConnection.setRequestProperty("Accept-Language", request.getHeader("Accept-Language"));
        return tempConnection;
    }
}

