/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.http.interceptor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\"\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J(\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u001bH\u0002R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lx/aichen/http/interceptor/ParmInterceptor;", "Lokhttp3/Interceptor;", "parms", "", "", "", "(Ljava/util/Map;)V", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getUTF8", "()Ljava/nio/charset/Charset;", "mHttpUrl", "Lokhttp3/HttpUrl;", "addGetParamsSign", "Lokhttp3/Request;", "request", "addPostParamsSign", "createUrlFromParams", "url", "params", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "parseUrl", "updateDynamicParams", "Ljava/util/TreeMap;", "dynamicMap", "util_release"})
public final class ParmInterceptor
implements Interceptor {
    private final Charset UTF8;
    private HttpUrl mHttpUrl;
    private final Map<String, Object> parms;

    public final Charset getUTF8() {
        return this.UTF8;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Map<String, Object> map;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        if (this.parms != null && !(map = this.parms).isEmpty()) {
            if (Intrinsics.areEqual((Object)request.method(), (Object)"GET")) {
                this.mHttpUrl = request.url();
                Request request2 = request;
                Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
                request = this.addGetParamsSign(request2);
            } else if (Intrinsics.areEqual((Object)request.method(), (Object)"POST")) {
                String string = request.url().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.url().toString()");
                this.mHttpUrl = HttpUrl.parse((String)this.parseUrl(string));
                Request request3 = request;
                Intrinsics.checkExpressionValueIsNotNull((Object)request3, (String)"request");
                request = this.addPostParamsSign(request3);
            }
        }
        Response response = chain.proceed(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request)");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final Request addGetParamsSign(Request request) {
        Request request2 = request;
        HttpUrl httpUrl = request2.url();
        HttpUrl.Builder newBuilder = httpUrl.newBuilder();
        Set nameSet = httpUrl.queryParameterNames();
        ArrayList nameList = new ArrayList();
        nameList.addAll(nameSet);
        TreeMap<String, Object> oldParams = new TreeMap<String, Object>();
        int n = 0;
        int n2 = nameList.size();
        while (n < n2) {
            void i;
            String value = httpUrl.queryParameterValues((String)nameList.get((int)i)) != null && httpUrl.queryParameterValues((String)nameList.get((int)i)).size() > 0 ? (String)httpUrl.queryParameterValues((String)nameList.get((int)i)).get(0) : "";
            oldParams.put((String)nameList.get((int)i), value);
            ++i;
        }
        String nameKeys = Arrays.asList(nameList).toString();
        TreeMap<String, Object> newParams = this.updateDynamicParams(oldParams);
        for (Map.Entry<String, Object> entry : newParams.entrySet()) {
            String urlValue = URLEncoder.encode(entry.getValue().toString(), this.UTF8.name());
            CharSequence charSequence = nameKeys;
            String string = entry.getKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.key");
            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) continue;
            newBuilder.addQueryParameter(entry.getKey(), urlValue);
        }
        httpUrl = newBuilder.build();
        Request request3 = request2.newBuilder().url(httpUrl).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request3, (String)"request.newBuilder().url(httpUrl).build()");
        request2 = request3;
        return request2;
    }

    /*
     * WARNING - void declaration
     */
    private final Request addPostParamsSign(Request request) {
        Request newrequest = request;
        RequestBody requestBody = request.body();
        if (requestBody instanceof FormBody) {
            FormBody.Builder bodyBuilder = new FormBody.Builder();
            RequestBody requestBody2 = request.body();
            if (requestBody2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type okhttp3.FormBody");
            }
            FormBody formBody = (FormBody)requestBody2;
            TreeMap<String, Object> oldParams = new TreeMap<String, Object>();
            int n = 0;
            int n2 = formBody.size();
            while (n < n2) {
                void i;
                oldParams.put(formBody.encodedName((int)i), formBody.encodedValue((int)i));
                ++i;
            }
            TreeMap<String, Object> newParams = this.updateDynamicParams(oldParams);
            for (Map.Entry<String, Object> entry : newParams.entrySet()) {
                String value = URLDecoder.decode(entry.getValue().toString(), this.UTF8.name());
                bodyBuilder.addEncoded(entry.getKey(), value);
            }
            FormBody formBody2 = bodyBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)formBody2, (String)"bodyBuilder.build()");
            formBody = formBody2;
            Request request2 = request.newBuilder().post((RequestBody)formBody).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request.newBuilder().post(formBody).build()");
            newrequest = request2;
        } else if (requestBody instanceof MultipartBody) {
            RequestBody requestBody3 = request.body();
            if (requestBody3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type okhttp3.MultipartBody");
            }
            MultipartBody multipartBody = (MultipartBody)requestBody3;
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            List oldParts = multipartBody.parts();
            ArrayList<MultipartBody.Part> newParts = new ArrayList<MultipartBody.Part>();
            newParts.addAll(oldParts);
            TreeMap<String, Object> oldParams = new TreeMap<String, Object>();
            TreeMap<String, Object> newParams = this.updateDynamicParams(oldParams);
            for (Map.Entry<String, Object> paramEntry : newParams.entrySet()) {
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)paramEntry.getKey(), (String)paramEntry.getValue().toString());
                newParts.add(part);
            }
            for (MultipartBody.Part part : newParts) {
                bodyBuilder.addPart(part);
            }
            MultipartBody multipartBody2 = bodyBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)multipartBody2, (String)"bodyBuilder.build()");
            multipartBody = multipartBody2;
            Request request3 = request.newBuilder().post((RequestBody)multipartBody).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)request3, (String)"request.newBuilder().post(multipartBody).build()");
            newrequest = request3;
        } else if (requestBody instanceof RequestBody) {
            TreeMap<String, Object> params = this.updateDynamicParams(new TreeMap<String, Object>());
            HttpUrl httpUrl = this.mHttpUrl;
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            String string = httpUrl.url().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mHttpUrl!!.url().toString()");
            String url = this.createUrlFromParams(string, (Map<String, ? extends Object>)params);
            Request request4 = request.newBuilder().url(url).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)request4, (String)"request.newBuilder().url(url).build()");
            newrequest = request4;
        }
        return newrequest;
    }

    private final TreeMap<String, Object> updateDynamicParams(TreeMap<String, Object> dynamicMap) {
        Map<String, Object> map = this.parms;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        Map<String, Object> map2 = map;
        Iterator<Map.Entry<String, Object>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            String k = entry2.getKey();
            entry2 = entry;
            Object v = entry2.getValue();
            dynamicMap.put(k, v);
        }
        return dynamicMap;
    }

    @NotNull
    public final String createUrlFromParams(@NotNull String url, @NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(url);
            if (StringsKt.indexOf$default((CharSequence)url, (char)'&', (int)0, (boolean)false, (int)6, null) > 0 || StringsKt.indexOf$default((CharSequence)url, (char)'?', (int)0, (boolean)false, (int)6, null) > 0) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            Map<String, ? extends Object> map = params;
            Iterator<Map.Entry<String, ? extends Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ? extends Object> entry;
                Map.Entry<String, ? extends Object> entry2 = entry = iterator.next();
                String key = entry2.getKey();
                entry2 = entry;
                Object value = entry2.getValue();
                String urlValues = value.toString();
                String urlValue = URLEncoder.encode(urlValues, this.UTF8.name());
                sb.append(key).append("=").append(urlValue).append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return url;
        }
    }

    @NotNull
    public final String parseUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String url2 = url;
        if (Intrinsics.areEqual((Object)"", (Object)url2) ^ true && StringsKt.contains$default((CharSequence)url2, (CharSequence)"?", (boolean)false, (int)2, null)) {
            String string = url2;
            int n = 0;
            int n2 = StringsKt.indexOf$default((CharSequence)url2, (char)'?', (int)0, (boolean)false, (int)6, null);
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            url2 = string2;
        }
        return url2;
    }

    public ParmInterceptor(@Nullable Map<String, ? extends Object> parms) {
        this.parms = parms;
        this.UTF8 = Charset.forName("UTF-8");
    }
}

