/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.http.interceptor;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

public class OnlineCacheInterceptor
implements Interceptor {
    private String cacheControlValue;

    public OnlineCacheInterceptor() {
        this(60);
    }

    public OnlineCacheInterceptor(int cacheControlValue) {
        this.cacheControlValue = String.format("max-age=%d", cacheControlValue);
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Response originalResponse = chain.proceed(chain.request());
        String cacheControl = originalResponse.header("Cache-Control");
        if (TextUtils.isEmpty((CharSequence)cacheControl) || cacheControl.contains("no-store") || cacheControl.contains("no-cache") || cacheControl.contains("must-revalidate") || cacheControl.contains("max-age") || cacheControl.contains("max-stale")) {
            return originalResponse.newBuilder().header("Cache-Control", "public, " + this.cacheControlValue).removeHeader("Pragma").build();
        }
        return originalResponse;
    }
}

