package x.aichen.base

import android.app.Application
import cn.bingoogolapple.swipebacklayout.BGASwipeBackHelper
import com.blankj.utilcode.util.Utils
import com.squareup.leakcanary.LeakCanary

/**
 * author 艾晨
 * Created at 2017/3/31 12:44
 * Update at 2017/3/31 12:44
 * Update people:
 * Version:1.0
 * 说明：  基类APP
 */

abstract class XApp : Application() {

    override fun onCreate() {
        super.onCreate()
        Utils.init(this) //utilcode 初始化
        AnasyMemory()
        /**
         * 必须在 Application 的 onCreate 方法中执行 BGASwipeBackHelper.init 来初始化滑动返回
         * 第一个参数：应用程序上下文
         * 第二个参数：如果发现滑动返回后立即触摸界面时应用崩溃，请把该界面里比较特殊的 View 的 class 添加到该集合中，目前在库中已经添加了 WebView 和 SurfaceView
         */
        BGASwipeBackHelper.init(this, null)
    }


    private fun AnasyMemory() {
        if (LeakCanary.isInAnalyzerProcess(this)) {
            // This process is dedicated to LeakCanary for heap analysis.
            // You should not init your app in this process.
            return
        }
        LeakCanary.install(this)
    }

}
