/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.util;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.FileProvider;
import java.io.File;

public class UriParse {
    public static final int PERMISSION_REQUEST_TAKE_PHOTO = 2000;

    public static String getFilePathWithUri(Uri uri, Activity activity) throws Exception {
        String picturePath;
        if (uri == null) {
            Log.w((String)"see", (String)"uri is null,activity may have been recovered?");
            throw new Exception("uri is null,activity may have been recovered?");
        }
        File picture = UriParse.getFileWithUri(uri, activity);
        String string = picturePath = picture == null ? null : picture.getPath();
        if (TextUtils.isEmpty((CharSequence)picturePath)) {
            throw new Exception("uri is null");
        }
        if (!picturePath.contains("storage")) {
            picturePath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + picturePath;
        }
        return picturePath;
    }

    public static File getFileWithUri(Uri uri, Activity activity) {
        String picturePath = null;
        String scheme = uri.getScheme();
        if ("content".equals(scheme)) {
            String[] filePathColumn = new String[]{"_data"};
            Cursor cursor = activity.getContentResolver().query(uri, filePathColumn, null, null, null);
            cursor.moveToFirst();
            int columnIndex = cursor.getColumnIndex(filePathColumn[0]);
            if (columnIndex >= 0) {
                picturePath = cursor.getString(columnIndex);
            } else if (TextUtils.equals((CharSequence)uri.getAuthority(), (CharSequence)UriParse.getFileProviderName((Context)activity))) {
                picturePath = UriParse.parseOwnUri((Context)activity, uri);
            }
            cursor.close();
        } else if ("file".equals(scheme)) {
            picturePath = uri.getPath();
        }
        return TextUtils.isEmpty(picturePath) ? null : new File(picturePath);
    }

    public static final String getFileProviderName(Context context) {
        return context.getPackageName() + ".fileprovider";
    }

    public static String parseOwnUri(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        String path = TextUtils.equals((CharSequence)uri.getAuthority(), (CharSequence)UriParse.getFileProviderName(context)) ? new File(uri.getPath().replace("camera_photos/", "")).getAbsolutePath() : uri.getPath();
        return path;
    }

    public static Uri getUriForFile(Context context, File file) {
        return FileProvider.getUriForFile((Context)context, (String)UriParse.getFileProviderName(context), (File)file);
    }
}

