/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.http.interceptor;

import androidx.annotation.NonNull;
import com.blankj.utilcode.util.NetworkUtils;
import java.io.IOException;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OfflineCacheInterceptor
implements Interceptor {
    private String cacheControlValue;

    public OfflineCacheInterceptor() {
        this(86400);
    }

    public OfflineCacheInterceptor(int cacheControlValue) {
        this.cacheControlValue = String.format("max-stale=%d", cacheControlValue);
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (!NetworkUtils.isConnected()) {
            request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
            Response response = chain.proceed(request);
            return response.newBuilder().header("Cache-Control", "public, only-if-cached, " + this.cacheControlValue).removeHeader("Pragma").build();
        }
        return chain.proceed(request);
    }
}

